/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.utils;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartCompliance;
import org.eclipse.jetty.http.MultiPartConfig;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Attributes;

public class MultiPartFormParser {
    private final Path partsTempDir;
    private final long maxMemoryPartSize;

    public MultiPartFormParser(Path partsTempDir, long maxMemoryPartSize) {
        this.partsTempDir = partsTempDir;
        this.maxMemoryPartSize = maxMemoryPartSize;
    }

    public Map<String, PartItem> readParts(HttpRequest request) throws MultiPartException {
        return this.readParts(request.getData(), request.getHeader("Content-Type"));
    }

    public Map<String, PartItem> readParts(InputStream input, String contentType) throws MultiPartException {
        try {
            MultiPartFormData.Parts multipart = MultiPartFormData.getParts((Content.Source)Content.Source.from((InputStream)input), (Attributes)new Attributes.Mapped(), (String)contentType, (MultiPartConfig)new MultiPartConfig.Builder().maxPartSize(-1L).maxSize(-1L).maxHeadersSize(-1).maxParts(-1).maxMemoryPartSize(this.maxMemoryPartSize).location(this.partsTempDir).complianceMode(MultiPartCompliance.RFC7578).build());
            TreeMap<String, PartItem> result = new TreeMap<String, PartItem>();
            for (MultiPart.Part part : multipart) {
                PartItem item = new PartItem(part.getName(), Content.Source.asInputStream((Content.Source)part.getContentSource()), part.getHeaders().get(HttpHeader.CONTENT_TYPE));
                result.put(part.getName(), item);
            }
            return result;
        }
        catch (Exception e) {
            throw new MultiPartException(e);
        }
    }

    public static class PartItem {
        private final String name;
        private final InputStream data;
        private final String contentType;

        public PartItem(String name, InputStream data, String contentType) {
            this.name = name;
            this.data = data;
            this.contentType = contentType;
        }

        public String name() {
            return this.name;
        }

        public InputStream data() {
            return this.data;
        }

        public String contentType() {
            return this.contentType;
        }

        public String toString() {
            return "PartItem{name='" + this.name + "', contentType='" + this.contentType + "'}";
        }
    }

    public static class MultiPartException
    extends IOException {
        public MultiPartException(Throwable t) {
            super(Exceptions.toMessageString((Throwable)t), t);
        }
    }
}

