/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.HttpServerConformanceTestHooks;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.text.Text;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;

class JettyRequestContentReader {
    private static final Logger log = Logger.getLogger(JettyRequestContentReader.class.getName());
    private final RequestMetricReporter metricReporter;
    private final Request jettyRequest;
    private final ContentChannel contentChannel;
    private final CompletableFuture<Void> jettyReadCompletion;
    private final CompletableFuture<Void> contentReadCompletion;
    private final AtomicLong numberOfOutstandingUserCalls = new AtomicLong(1L);
    private final AtomicLong bytesRead = new AtomicLong();

    JettyRequestContentReader(RequestMetricReporter metricReporter, Janitor janitor, Request jettyRequest, ContentChannel contentChannel) {
        this.metricReporter = Objects.requireNonNull(metricReporter);
        this.jettyRequest = Objects.requireNonNull(jettyRequest);
        ConnectorConfig cfg = RequestUtils.getConnector(jettyRequest).connectorConfig();
        long maxContentSize = JettyRequestContentReader.resolveMaxContentSize(cfg);
        String msgTemplate = JettyRequestContentReader.resolveMaxContentSizeErrorMessage(cfg);
        this.contentChannel = maxContentSize >= 0L ? new ByteLimitedContentChannel(Objects.requireNonNull(contentChannel), maxContentSize, msgTemplate, jettyRequest.getLength()) : Objects.requireNonNull(contentChannel);
        Objects.requireNonNull(janitor);
        this.jettyReadCompletion = new CompletableFuture();
        this.contentReadCompletion = new CompletableFuture();
        this.jettyReadCompletion.whenComplete((result, originalError) -> {
            metricReporter.contentSize(this.bytesRead.get());
            if (originalError != null) {
                log.log(Level.FINE, (Throwable)originalError, () -> "Request content read failed");
                this.contentReadCompletion.completeExceptionally((Throwable)originalError);
            }
            janitor.scheduleTask(() -> {
                block6: {
                    if (originalError != null) {
                        try {
                            contentChannel.onError(originalError);
                        }
                        catch (Throwable throwable) {
                            log.log(Level.FINE, throwable, () -> "Failed to invoke content channel onError");
                            originalError.addSuppressed(throwable);
                        }
                    }
                    try {
                        contentChannel.close(new CompletionHandler(){
                            final /* synthetic */ Throwable val$originalError;
                            {
                                this.val$originalError = throwable;
                            }

                            public void completed() {
                                JettyRequestContentReader.this.contentReadCompletion.complete(null);
                            }

                            public void failed(Throwable t) {
                                if (this.val$originalError != null) {
                                    this.val$originalError.addSuppressed(t);
                                } else {
                                    JettyRequestContentReader.this.contentReadCompletion.completeExceptionally(t);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        log.log(Level.FINE, throwable, () -> "Failed to invoke content channel close");
                        if (originalError != null) {
                            originalError.addSuppressed(throwable);
                        }
                        if (this.contentReadCompletion.completeExceptionally(throwable)) break block6;
                        HttpServerConformanceTestHooks.markAsProcessed(throwable);
                    }
                }
            });
        });
    }

    CompletableFuture<Void> readCompletion() {
        return this.contentReadCompletion;
    }

    void start() {
        this.processChunks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunks() {
        Content.Chunk chunk;
        do {
            if ((chunk = this.jettyRequest.read()) instanceof Trailers) {
                Trailers trailers = (Trailers)chunk;
                log.log(Level.FINE, () -> "Received trailers: " + String.valueOf(trailers));
                chunk.release();
                return;
            }
            if (chunk == null) {
                log.log(Level.FINE, () -> "Received no chunk");
                this.jettyRequest.demand(this::processChunks);
                return;
            }
            if (Content.Chunk.isFailure((Content.Chunk)chunk, (boolean)false)) {
                log.log(Level.FINE, chunk.getFailure(), () -> "Failed to read non-last chunk");
                this.jettyRequest.demand(this::processChunks);
                return;
            }
            if (Content.Chunk.isFailure((Content.Chunk)chunk, (boolean)true)) {
                log.log(Level.FINE, chunk.getFailure(), () -> "Failed to read last chunk");
                this.jettyReadCompletion.completeExceptionally(chunk.getFailure());
                return;
            }
            int bytesRemaining = chunk.remaining();
            if (bytesRemaining > 0) {
                this.bytesRead.addAndGet(bytesRemaining);
                this.numberOfOutstandingUserCalls.addAndGet(2L);
                CompletionStage chunkReleaser = new CompletableFuture().whenComplete((result, error) -> chunk.release());
                try {
                    this.contentChannel.write(chunk.getByteBuffer(), new CompletionHandler(){
                        final /* synthetic */ CompletableFuture val$chunkReleaser;
                        {
                            this.val$chunkReleaser = completableFuture;
                        }

                        public void completed() {
                            JettyRequestContentReader.this.decrementOutstandingUserCalls();
                            this.val$chunkReleaser.complete(null);
                        }

                        public void failed(Throwable t) {
                            JettyRequestContentReader.this.jettyReadCompletion.completeExceptionally(t);
                            JettyRequestContentReader.this.decrementOutstandingUserCalls();
                            this.val$chunkReleaser.complete(null);
                            log.log(Level.FINE, t, () -> "Failed to write chunk to content channel");
                        }
                    });
                    this.metricReporter.successfulWrite(bytesRemaining);
                }
                catch (Throwable t) {
                    ((CompletableFuture)chunkReleaser).complete(null);
                    log.log(Level.FINE, t, () -> "Failed to invoke content channel write");
                    this.jettyReadCompletion.completeExceptionally(t);
                }
                finally {
                    this.decrementOutstandingUserCalls();
                }
            } else {
                chunk.release();
            }
        } while (!chunk.isLast());
        this.decrementOutstandingUserCalls();
    }

    private void decrementOutstandingUserCalls() {
        long remaining = this.numberOfOutstandingUserCalls.decrementAndGet();
        if (remaining == 0L) {
            this.jettyReadCompletion.complete(null);
        }
        if (remaining < 0L) {
            throw new AssertionError((Object)("Number of outstanding user calls is negative: " + remaining));
        }
    }

    private static String resolveMaxContentSizeErrorMessage(ConnectorConfig cfg) {
        return cfg.maxContentSizeErrorMessageTemplate().strip();
    }

    private static long resolveMaxContentSize(ConnectorConfig cfg) {
        long maxContentSize = cfg.maxContentSize() != 0L ? cfg.maxContentSize() : Math.min(Runtime.getRuntime().maxMemory() / 2L, 0x7FFFFFF7L);
        log.fine(() -> Text.format((String)"maxContentSize=%d", (Object[])new Object[]{maxContentSize}));
        return maxContentSize;
    }

    private class ByteLimitedContentChannel
    implements ContentChannel {
        private final long maxContentSize;
        private final String messageTemplate;
        private final long contentLengthHeader;
        private final AtomicLong bytesWritten = new AtomicLong();
        private final ContentChannel delegate;

        ByteLimitedContentChannel(ContentChannel delegate, long maxContentSize, String messageTemplate, long contentLengthHeader) {
            this.delegate = delegate;
            this.maxContentSize = maxContentSize;
            this.messageTemplate = messageTemplate;
            this.contentLengthHeader = contentLengthHeader;
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            long written = this.bytesWritten.addAndGet(buf.remaining());
            if (this.contentLengthHeader != -1L && this.contentLengthHeader > this.maxContentSize) {
                handler.failed((Throwable)new RequestException(413, this.messageTemplate.formatted(this.contentLengthHeader, this.maxContentSize)));
            } else if (written > this.maxContentSize) {
                handler.failed((Throwable)new RequestException(413, this.messageTemplate.formatted(written, this.maxContentSize)));
            } else {
                this.delegate.write(buf, handler);
            }
        }

        public void close(CompletionHandler h) {
            this.delegate.close(h);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }
    }
}

