/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import ai.vespa.metrics.ContainerMetrics;
import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.SslHandshakeFailedListener;
import com.yahoo.jdisc.http.ssl.impl.DefaultConnectorSsl;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ConnectorFactory {
    private static final Logger log = Logger.getLogger(ConnectorFactory.class.getName());
    private final ConnectorConfig connectorConfig;
    private final SslProvider sslProvider;

    @Inject
    public ConnectorFactory(ConnectorConfig connectorConfig, SslProvider sslProvider) {
        ConnectorFactory.runtimeConnectorConfigValidation(connectorConfig);
        this.connectorConfig = connectorConfig;
        this.sslProvider = sslProvider;
    }

    private static void runtimeConnectorConfigValidation(ConnectorConfig config) {
        ConnectorFactory.validateProxyProtocolConfiguration(config);
    }

    private static void validateProxyProtocolConfiguration(ConnectorConfig config) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = config.proxyProtocol();
        if (proxyProtocolConfig.enabled()) {
            boolean tlsMixedModeEnabled;
            boolean bl = tlsMixedModeEnabled = TransportSecurityUtils.getInsecureMixedMode() != MixedMode.DISABLED;
            if (!ConnectorFactory.isSslEffectivelyEnabled(config) || tlsMixedModeEnabled) {
                throw new IllegalArgumentException("Proxy protocol can only be enabled if connector is effectively HTTPS only");
            }
        }
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    JDiscServerConnector createConnector(Metric metric, Server server) {
        return new JDiscServerConnector(this.connectorConfig, metric, server, (ConnectionFactory[])this.createConnectionFactories(metric).toArray(ConnectionFactory[]::new));
    }

    private List<ConnectionFactory> createConnectionFactories(Metric metric) {
        boolean vespaTlsEnabled = TransportSecurityUtils.isTransportSecurityEnabled() && this.connectorConfig.implicitTlsEnabled();
        MixedMode tlsMixedMode = TransportSecurityUtils.getInsecureMixedMode();
        if (this.connectorConfig.ssl().enabled() || vespaTlsEnabled && tlsMixedMode == MixedMode.DISABLED) {
            return this.connectionFactoriesForHttps(metric);
        }
        if (vespaTlsEnabled) {
            if (tlsMixedMode != MixedMode.TLS_CLIENT_MIXED_SERVER && tlsMixedMode != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
                throw new IllegalArgumentException("Unknown mixed mode " + String.valueOf(tlsMixedMode));
            }
            return this.connectionFactoriesForTlsMixedMode(metric);
        }
        return this.connectorConfig.http2Enabled() ? List.of(this.newHttp1ConnectionFactory(metric), this.newHttp2ClearTextConnectionFactory(metric)) : List.of(this.newHttp1ConnectionFactory(metric));
    }

    private List<ConnectionFactory> connectionFactoriesForHttps(Metric metric) {
        SslConnectionFactory sslFactory;
        ALPNServerConnectionFactory alpnFactory;
        ArrayList<Object> factories = new ArrayList<Object>();
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = this.connectorConfig.proxyProtocol();
        HttpConnectionFactory http1Factory = this.newHttp1ConnectionFactory(metric);
        if (this.connectorConfig.http2Enabled()) {
            alpnFactory = this.newAlpnConnectionFactory();
            sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)alpnFactory);
        } else {
            alpnFactory = null;
            sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)http1Factory);
        }
        if (proxyProtocolConfig.enabled()) {
            factories.add(this.newProxyProtocolConnectionFactory((ConnectionFactory)sslFactory, proxyProtocolConfig.mixedMode()));
        }
        factories.add(sslFactory);
        if (this.connectorConfig.http2Enabled()) {
            factories.add(alpnFactory);
        }
        factories.add(http1Factory);
        if (this.connectorConfig.http2Enabled()) {
            factories.add(this.newHttp2ConnectionFactory(metric));
        }
        return List.copyOf(factories);
    }

    private List<ConnectionFactory> connectionFactoriesForTlsMixedMode(Metric metric) {
        log.warning(String.format("TLS mixed mode enabled for port %d - HTTP/2 and proxy-protocol are not supported", this.connectorConfig.listenPort()));
        HttpConnectionFactory httpFactory = this.newHttp1ConnectionFactory(metric);
        SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)httpFactory);
        DetectorConnectionFactory detectorFactory = this.newDetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory});
        return List.of(detectorFactory, httpFactory, sslFactory);
    }

    private HttpConfiguration newHttpConfiguration(Metric metric) {
        String serverNameFallback;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setHeaderCacheSize(this.connectorConfig.headerCacheSize());
        httpConfig.setOutputBufferSize(this.connectorConfig.outputBufferSize());
        httpConfig.setRequestHeaderSize(this.connectorConfig.requestHeaderSize());
        httpConfig.setResponseHeaderSize(this.connectorConfig.responseHeaderSize());
        httpConfig.addComplianceViolationListener((ComplianceViolation.Listener)new HttpComplianceViolationListener(metric));
        httpConfig.setUseInputDirectByteBuffers(false);
        httpConfig.setUseOutputDirectByteBuffers(false);
        httpConfig.setHttpCompliance(ConnectorFactory.newHttpCompliance(this.connectorConfig));
        httpConfig.setMaxUnconsumedRequestContentReads(64);
        httpConfig.setUriCompliance(UriCompliance.LEGACY);
        if (ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(false, false, -1L, false));
        }
        if (!(serverNameFallback = this.connectorConfig.serverName().fallback()).isBlank()) {
            httpConfig.setServerAuthority(new HostPort(serverNameFallback));
        }
        return httpConfig;
    }

    private static HttpCompliance newHttpCompliance(ConnectorConfig cfg) {
        List<HttpCompliance.Violation> jettyViolationsAllowed = cfg.compliance().httpViolations().stream().map(name -> {
            try {
                return HttpCompliance.Violation.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                log.warning("Ignoring unknown violation '%s'".formatted(name));
                return null;
            }
        }).filter(Objects::nonNull).toList();
        if (jettyViolationsAllowed.isEmpty()) {
            return HttpCompliance.RFC7230;
        }
        log.info("Disabling HTTP compliance checks for port %d: %s".formatted(cfg.listenPort(), jettyViolationsAllowed.stream().map(HttpCompliance.Violation::getName).toList()));
        return HttpCompliance.RFC7230.with("RFC7230_VESPA", (HttpCompliance.Violation[])jettyViolationsAllowed.toArray(HttpCompliance.Violation[]::new));
    }

    private HttpConnectionFactory newHttp1ConnectionFactory(Metric metric) {
        return new HttpConnectionFactory(this.newHttpConfiguration(metric));
    }

    private HTTP2ServerConnectionFactory newHttp2ConnectionFactory(Metric metric) {
        HTTP2ServerConnectionFactory factory = new HTTP2ServerConnectionFactory(this.newHttpConfiguration(metric));
        this.setHttp2Config((AbstractHTTP2ServerConnectionFactory)factory);
        return factory;
    }

    private HTTP2CServerConnectionFactory newHttp2ClearTextConnectionFactory(Metric metric) {
        HTTP2CServerConnectionFactory factory = new HTTP2CServerConnectionFactory(this.newHttpConfiguration(metric));
        this.setHttp2Config((AbstractHTTP2ServerConnectionFactory)factory);
        return factory;
    }

    private void setHttp2Config(AbstractHTTP2ServerConnectionFactory factory) {
        factory.setStreamIdleTimeout(ConnectorFactory.toMillis(this.connectorConfig.http2().streamIdleTimeout()));
        factory.setMaxConcurrentStreams(this.connectorConfig.http2().maxConcurrentStreams());
        factory.setInitialSessionRecvWindow(0x1000000);
        factory.setInitialStreamRecvWindow(0x100000);
    }

    private SslConnectionFactory newSslConnectionFactory(Metric metric, ConnectionFactory wrappedFactory) {
        SslConnectionFactory fac = new SslConnectionFactory(this.createSslContextFactory(), wrappedFactory.getProtocol());
        fac.setDirectBuffersForDecryption(false);
        fac.setDirectBuffersForEncryption(false);
        fac.addBean((Object)new SslHandshakeFailedListener(metric, this.connectorConfig.name(), this.connectorConfig.listenPort()));
        return fac;
    }

    private SslContextFactory.Server createSslContextFactory() {
        DefaultConnectorSsl ssl = new DefaultConnectorSsl();
        this.sslProvider.configureSsl(ssl, this.connectorConfig.name(), this.connectorConfig.listenPort());
        return ssl.createSslContextFactory();
    }

    private ALPNServerConnectionFactory newAlpnConnectionFactory() {
        ALPNServerConnectionFactory factory = new ALPNServerConnectionFactory(new String[]{"h2", "http/1.1"});
        factory.setDefaultProtocol("http/1.1");
        return factory;
    }

    private DetectorConnectionFactory newDetectorConnectionFactory(ConnectionFactory.Detecting ... alternatives) {
        return new DetectorConnectionFactory(alternatives);
    }

    private ProxyConnectionFactory newProxyProtocolConnectionFactory(ConnectionFactory wrapped, boolean mixedMode) {
        return mixedMode ? new ProxyConnectionFactory(wrapped.getProtocol()) : new MandatoryProxyConnectionFactory(wrapped.getProtocol());
    }

    private static boolean isSslEffectivelyEnabled(ConnectorConfig config) {
        return config.ssl().enabled() || config.implicitTlsEnabled() && TransportSecurityUtils.isTransportSecurityEnabled();
    }

    private static long toMillis(double seconds) {
        return (long)(seconds * 1000.0);
    }

    private record HttpComplianceViolationListener(Metric metric) implements ComplianceViolation.Listener
    {
        public void onComplianceViolation(ComplianceViolation.Event e) {
            log.fine(() -> "Compliance violation: mode=%s, violation=%s".formatted(e.mode().getName(), e.violation().getName()));
            Metric.Context ctx = this.metric.createContext(Map.of("mode", e.mode().getName(), "violation", e.violation().getName()));
            this.metric.add(ContainerMetrics.JETTY_HTTP_COMPLIANCE_VIOLATION.baseName(), (Number)1L, ctx);
        }
    }

    private static class MandatoryProxyConnectionFactory
    extends ProxyConnectionFactory {
        MandatoryProxyConnectionFactory(String next) {
            super(next);
        }

        protected String findNextProtocol(Connector __) {
            return null;
        }
    }
}

