/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.UntypedMetric;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class DimensionCache {
    private final Map<String, LinkedHashMap<Point, TimeStampedMetric>> persistentData = new HashMap<String, LinkedHashMap<Point, TimeStampedMetric>>();
    private final int pointsToKeep;
    private static final long MAX_AGE_MILLIS = 14400000L;

    public DimensionCache(int pointsToKeep) {
        this.pointsToKeep = pointsToKeep;
    }

    void updateDimensionPersistence(Bucket toDelete, Bucket toPresent) {
        this.updatePersistentData(toDelete);
        this.padPresentation(toPresent);
    }

    private void padPresentation(Bucket toPresent) {
        Map<String, List<Map.Entry<Point, UntypedMetric>>> currentMetricNames = toPresent.getValuesByMetricName();
        for (Map.Entry<String, List<Map.Entry<Point, UntypedMetric>>> metric : currentMetricNames.entrySet()) {
            int currentDataPoints = metric.getValue().size();
            if (currentDataPoints >= this.pointsToKeep) continue;
            this.padMetric(metric.getKey(), toPresent, currentDataPoints);
        }
        HashSet<String> keysMissingFromPresentation = new HashSet<String>(this.persistentData.keySet());
        keysMissingFromPresentation.removeAll(currentMetricNames.keySet());
        for (String cachedMetric : keysMissingFromPresentation) {
            this.padMetric(cachedMetric, toPresent, 0);
        }
    }

    private void updatePersistentData(Bucket toDelete) {
        if (toDelete == null) {
            return;
        }
        long millis = toDelete.gotTimeStamps ? toDelete.toMillis : System.currentTimeMillis();
        for (Map.Entry<String, List<Map.Entry<Point, UntypedMetric>>> metric : toDelete.getValuesByMetricName().entrySet()) {
            LinkedHashMap<Point, TimeStampedMetric> cachedPoints = this.getCachedMetric(metric.getKey());
            for (Map.Entry<Point, UntypedMetric> newestInterval : metric.getValue()) {
                cachedPoints.remove(newestInterval.getKey());
                TimeStampedMetric toInsert = new TimeStampedMetric(millis, newestInterval.getValue());
                cachedPoints.put(newestInterval.getKey(), toInsert);
            }
        }
    }

    private void padMetric(String metric, Bucket toPresent, int currentDataPoints) {
        LinkedHashMap<Point, TimeStampedMetric> cachedPoints = this.getCachedMetric(metric);
        int toAdd = this.pointsToKeep - currentDataPoints;
        Map.Entry[] cachedEntries = cachedPoints.entrySet().toArray(new Map.Entry[0]);
        long nowMillis = System.currentTimeMillis();
        for (int i = cachedEntries.length - 1; i >= 0 && toAdd > 0; --i) {
            Identifier id;
            Map.Entry leastOld = cachedEntries[i];
            if (((TimeStampedMetric)leastOld.getValue()).millis + 14400000L < nowMillis || toPresent.hasIdentifier(id = new Identifier(metric, (Point)leastOld.getKey()))) continue;
            toPresent.put(id, ((TimeStampedMetric)leastOld.getValue()).metric.pruneData());
            --toAdd;
        }
    }

    private LinkedHashMap<Point, TimeStampedMetric> getCachedMetric(String metricName) {
        LinkedHashMap<Point, TimeStampedMetric> points = this.persistentData.get(metricName);
        if (points == null) {
            points = new LinkedHashMap<Point, TimeStampedMetric>(16, 0.75f, false){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Point, TimeStampedMetric> eldest) {
                    return this.size() > DimensionCache.this.pointsToKeep;
                }
            };
            this.persistentData.put(metricName, points);
        }
        return points;
    }

    private static class TimeStampedMetric {
        public final long millis;
        public final UntypedMetric metric;

        public TimeStampedMetric(long millis, UntypedMetric metric) {
            this.millis = millis;
            this.metric = metric;
        }
    }
}

