/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.api.annotations.Beta;

public class Coverage {
    private boolean useTargetActiveForCoverageComputation = false;
    protected long docs;
    protected long active;
    protected long targetActive;
    protected int degradedReason;
    protected int nodes;
    private int nodesTried;
    protected int resultSets;
    protected int fullResultSets;
    protected FullCoverageDefinition fullReason = FullCoverageDefinition.DOCUMENT_COUNT;
    public static final int DEGRADED_BY_MATCH_PHASE = 1;
    public static final int DEGRADED_BY_TIMEOUT = 2;
    public static final int DEGRADED_BY_ADAPTIVE_TIMEOUT = 4;

    protected Coverage(long docs, long active, int nodes, int resultSets) {
        this(docs, active, nodes, resultSets, FullCoverageDefinition.DOCUMENT_COUNT);
    }

    public Coverage(long docs, int nodes, boolean full) {
        this(docs, nodes, full, 1);
    }

    protected Coverage(long docs, int nodes, boolean full, int resultSets) {
        this(docs, docs, nodes, resultSets, full ? FullCoverageDefinition.EXPLICITLY_FULL : FullCoverageDefinition.EXPLICITLY_INCOMPLETE);
    }

    private Coverage(long docs, long active, int nodes, int resultSets, FullCoverageDefinition fullReason) {
        this.docs = docs;
        this.nodes = nodes;
        this.nodesTried = nodes;
        this.active = active;
        this.targetActive = active;
        this.degradedReason = 0;
        this.resultSets = resultSets;
        this.fullReason = fullReason;
        this.fullResultSets = this.getFull() ? resultSets : 0;
    }

    public void merge(Coverage other) {
        if (other == null) {
            return;
        }
        this.docs += other.getDocs();
        this.nodes += other.getNodes();
        this.nodesTried += other.nodesTried;
        this.active += other.getActive();
        this.targetActive += other.getTargetActive();
        this.degradedReason |= other.degradedReason;
        this.resultSets += other.getResultSets();
        this.fullResultSets += other.getFullResultSets();
        switch (other.fullReason) {
            case EXPLICITLY_FULL: {
                break;
            }
            case EXPLICITLY_INCOMPLETE: {
                this.fullReason = FullCoverageDefinition.EXPLICITLY_INCOMPLETE;
                break;
            }
            case DOCUMENT_COUNT: {
                if (this.fullReason != FullCoverageDefinition.EXPLICITLY_FULL) break;
                this.fullReason = FullCoverageDefinition.DOCUMENT_COUNT;
            }
        }
    }

    public long getDocs() {
        return this.docs;
    }

    public long getActive() {
        return this.active;
    }

    public long getTargetActive() {
        return this.targetActive;
    }

    public boolean isDegraded() {
        return this.degradedReason != 0 || this.isDegradedByNonIdealState();
    }

    public boolean isDegradedByMatchPhase() {
        return (this.degradedReason & 1) != 0;
    }

    public boolean isDegradedByTimeout() {
        return (this.degradedReason & 2) != 0;
    }

    public boolean isDegradedByAdapativeTimeout() {
        return (this.degradedReason & 4) != 0;
    }

    public boolean isDegradedByNonIdealState() {
        return this.degradedReason == 0 && this.getResultPercentage() != 100;
    }

    public boolean getFull() {
        return switch (this.fullReason) {
            default -> throw new IncompatibleClassChangeError();
            case FullCoverageDefinition.EXPLICITLY_FULL -> true;
            case FullCoverageDefinition.EXPLICITLY_INCOMPLETE -> false;
            case FullCoverageDefinition.DOCUMENT_COUNT -> this.docs == this.active;
        };
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getNodesTried() {
        return this.nodesTried;
    }

    public Coverage setNodesTried(int nodesTried) {
        this.nodesTried = nodesTried;
        return this;
    }

    public int getFullResultSets() {
        return this.fullResultSets;
    }

    public int getResultSets() {
        return this.resultSets;
    }

    public int getResultPercentage() {
        long total;
        if (this.getResultSets() == 0) {
            return 0;
        }
        long l = total = this.useTargetActiveForCoverageComputation ? this.targetActive : this.active;
        if (this.docs < total) {
            return (int)Math.round((double)this.docs * 100.0 / (double)total);
        }
        return this.getFullResultSets() * 100 / this.getResultSets();
    }

    @Beta
    public Coverage useTargetActiveForCoverageComputation(boolean value) {
        this.useTargetActiveForCoverageComputation = value;
        return this;
    }

    public com.yahoo.container.logging.Coverage toLoggingCoverage() {
        int degradation = com.yahoo.container.logging.Coverage.toDegradation(this.isDegradedByMatchPhase(), this.isDegradedByTimeout(), this.isDegradedByAdapativeTimeout());
        return new com.yahoo.container.logging.Coverage(this.getDocs(), this.getActive(), this.getTargetActive(), degradation, this.useTargetActiveForCoverageComputation);
    }

    protected static enum FullCoverageDefinition {
        EXPLICITLY_FULL,
        EXPLICITLY_INCOMPLETE,
        DOCUMENT_COUNT;

    }
}

