/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.dependencies;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Dependencies {
    private final Set<String> provides;
    private final Set<String> before;
    private final Set<String> after;

    public Dependencies(Collection<String> provides, Collection<String> before, Collection<String> after) {
        this.provides = this.immutableSet(provides);
        this.before = this.immutableSet(before);
        this.after = this.immutableSet(after);
    }

    public static Dependencies emptyDependencies() {
        return new Dependencies(null, null, null);
    }

    public Dependencies union(Dependencies dependencies) {
        return new Dependencies(this.union(this.provides, dependencies.provides), this.union(this.before, dependencies.before), this.union(this.after, dependencies.after));
    }

    private Set<String> immutableSet(Collection<String> set) {
        if (set == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(set);
    }

    private Set<String> union(Set<String> s1, Set<String> s2) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(s1);
        result.addAll(s2);
        return result;
    }

    public String toString() {
        return "Dependencies{provides=" + String.valueOf(this.provides) + ", before=" + String.valueOf(this.before) + ", after=" + String.valueOf(this.after) + "}";
    }

    public Set<String> provides() {
        return this.provides;
    }

    public Set<String> before() {
        return this.before;
    }

    public Set<String> after() {
        return this.after;
    }
}

