/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.service.CurrentContainer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;

class HttpRequestFactory {
    private static final Logger log = Logger.getLogger(HttpRequestFactory.class.getName());

    HttpRequestFactory() {
    }

    public static HttpRequest newJDiscRequest(CurrentContainer container, Request jettyRequest) {
        try {
            HttpRequest jdiscHttpReq = HttpRequest.newServerRequest(container, HttpRequestFactory.getUri(jettyRequest), HttpRequestFactory.getMethod(jettyRequest), HttpRequest.Version.fromString(jettyRequest.getConnectionMetaData().getProtocol()), new InetSocketAddress(Request.getRemoteAddr((Request)jettyRequest), Request.getRemotePort((Request)jettyRequest)), RequestUtils.getConnection(jettyRequest).getCreatedTimeStamp(), Request.getTimeStamp((Request)jettyRequest));
            jdiscHttpReq.context().put("jdisc.request.X509Certificate", HttpRequestFactory.getCertChain(jettyRequest));
            jdiscHttpReq.context().put("jdisc.request.port", Request.getLocalPort((Request)jettyRequest));
            EndPoint.SslSessionData sslSessionData = (EndPoint.SslSessionData)jettyRequest.getAttribute("org.eclipse.jetty.io.Endpoint.SslSessionData");
            if (sslSessionData != null) {
                jdiscHttpReq.context().put("jdisc.request.SSLSession", sslSessionData.sslSession());
            }
            jettyRequest.setAttribute(HttpRequest.class.getName(), (Object)jdiscHttpReq);
            HttpRequestFactory.copyHeaders(jettyRequest, jdiscHttpReq);
            return jdiscHttpReq;
        }
        catch (IllegalArgumentException e) {
            throw HttpRequestFactory.createBadQueryException(e);
        }
    }

    private static HttpRequest.Method getMethod(Request jettyRequest) {
        String method = jettyRequest.getMethod();
        try {
            return HttpRequest.Method.valueOf(method);
        }
        catch (IllegalArgumentException e) {
            throw new RequestException(405, "Invalid method '" + method + "'");
        }
    }

    public static URI getUri(Request jettyRequest) {
        try {
            String scheme = jettyRequest.getHttpURI().getScheme();
            String host = Request.getServerName((Request)jettyRequest);
            if (host == null || host.isBlank()) {
                String localAddr = Request.getLocalAddr((Request)jettyRequest);
                log.log(Level.FINE, () -> "Warning: missing Host/:authority header in request. Falling back to " + localAddr);
                host = localAddr;
            }
            int port = RequestUtils.getConnectorLocalPort(jettyRequest);
            String path = jettyRequest.getHttpURI().getPath();
            String query = jettyRequest.getHttpURI().getQuery();
            URI uri = URI.create(scheme + "://" + host + ":" + port + (path != null ? path : "") + (String)(query != null ? "?" + query : ""));
            HttpRequestFactory.validateSchemeHostPort(scheme, host, port, uri);
            return uri;
        }
        catch (IllegalArgumentException e) {
            throw HttpRequestFactory.createBadQueryException(e);
        }
    }

    private static void validateSchemeHostPort(String scheme, String host, int port, URI uri) {
        if (!scheme.equals(uri.getScheme())) {
            throw new IllegalArgumentException("Bad scheme: " + scheme);
        }
        if (!host.equals(uri.getHost()) || port != uri.getPort()) {
            throw new IllegalArgumentException("Bad authority: " + uri.getRawAuthority() + " != " + host + ":" + port);
        }
    }

    private static RequestException createBadQueryException(IllegalArgumentException e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        return new RequestException(400, "URL violates RFC 2396: " + cause.getMessage(), cause);
    }

    public static void copyHeaders(Request jettyRequest, HttpRequest jdiscRequest) {
        jettyRequest.getHeaders().forEach(header -> {
            if (!header.getValue().isBlank()) {
                jdiscRequest.headers().add(header.getName(), header.getValue());
            }
        });
    }

    private static X509Certificate[] getCertChain(Request jettyRequest) {
        return Optional.ofNullable(jettyRequest.getAttribute("org.eclipse.jetty.io.Endpoint.SslSessionData")).map(EndPoint.SslSessionData.class::cast).map(EndPoint.SslSessionData::peerCertificates).orElse(null);
    }
}

