// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.jdisc.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of health-monitor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class HealthMonitorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "6d7a68312d6c10a53e639d77cea06c0d";
  public final static String CONFIG_DEF_NAME = "health-monitor";
  public final static String CONFIG_DEF_NAMESPACE = "container.jdisc.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.jdisc.config",
    "snapshot_interval double default=300",
    "initialStatus string default=\"initializing\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Double snapshot_interval = null;
    private String initialStatus = null;

    public Builder() { }

    public Builder(HealthMonitorConfig config) {
      snapshot_interval(config.snapshot_interval());
      initialStatus(config.initialStatus());
    }

    private Builder override(Builder __superior) {
      if (__superior.snapshot_interval != null)
        snapshot_interval(__superior.snapshot_interval);
      if (__superior.initialStatus != null)
        initialStatus(__superior.initialStatus);
      return this;
    }

    public Builder snapshot_interval(double __value) {
      snapshot_interval = __value;
      return this;
    }

    private Builder snapshot_interval(String __value) {
      return snapshot_interval(Double.valueOf(__value));
    }

    public Builder initialStatus(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      initialStatus = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public HealthMonitorConfig build() {
      return new HealthMonitorConfig(this);
    }

  }

  // How far between snapshots. 5 minutes by default
  private final DoubleNode snapshot_interval;
  // Initial status used in /state/v1/health API (value for 'code' in 'status'). See StateMonitor for valid values
  private final StringNode initialStatus;

  public HealthMonitorConfig(Builder builder) {
    this(builder, true);
  }

  private HealthMonitorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "health-monitor must be initialized: " + builder.__uninitialized);

    snapshot_interval = (builder.snapshot_interval == null) ?
        new DoubleNode(300D) : new DoubleNode(builder.snapshot_interval);
    initialStatus = (builder.initialStatus == null) ?
        new StringNode("initializing") : new StringNode(builder.initialStatus);
  }

  /**
   * @return health-monitor.snapshot_interval
   */
  public double snapshot_interval() {
    return snapshot_interval.value();
  }

  /**
   * @return health-monitor.initialStatus
   */
  public String initialStatus() {
    return initialStatus.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(HealthMonitorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("health-monitor");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
