// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.handler.threadpool;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of container-threadpool
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ContainerThreadpoolConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "da0bba9306ffe8d51489e1f8ceb3568e";
  public final static String CONFIG_DEF_NAME = "container-threadpool";
  public final static String CONFIG_DEF_NAMESPACE = "container.handler.threadpool";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.handler.threadpool",
    "maxThreads int default=0",
    "minThreads int default=0",
    "keepAliveTime double default=5.0",
    "queueSize int default=0",
    "maxThreadExecutionTimeSeconds int default=190",
    "name string default=\"default-pool\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer maxThreads = null;
    private Integer minThreads = null;
    private Double keepAliveTime = null;
    private Integer queueSize = null;
    private Integer maxThreadExecutionTimeSeconds = null;
    private String name = null;

    public Builder() { }

    public Builder(ContainerThreadpoolConfig config) {
      maxThreads(config.maxThreads());
      minThreads(config.minThreads());
      keepAliveTime(config.keepAliveTime());
      queueSize(config.queueSize());
      maxThreadExecutionTimeSeconds(config.maxThreadExecutionTimeSeconds());
      name(config.name());
    }

    private Builder override(Builder __superior) {
      if (__superior.maxThreads != null)
        maxThreads(__superior.maxThreads);
      if (__superior.minThreads != null)
        minThreads(__superior.minThreads);
      if (__superior.keepAliveTime != null)
        keepAliveTime(__superior.keepAliveTime);
      if (__superior.queueSize != null)
        queueSize(__superior.queueSize);
      if (__superior.maxThreadExecutionTimeSeconds != null)
        maxThreadExecutionTimeSeconds(__superior.maxThreadExecutionTimeSeconds);
      if (__superior.name != null)
        name(__superior.name);
      return this;
    }

    public Builder maxThreads(int __value) {
      maxThreads = __value;
      return this;
    }

    private Builder maxThreads(String __value) {
      return maxThreads(Integer.valueOf(__value));
    }

    public Builder minThreads(int __value) {
      minThreads = __value;
      return this;
    }

    private Builder minThreads(String __value) {
      return minThreads(Integer.valueOf(__value));
    }

    public Builder keepAliveTime(double __value) {
      keepAliveTime = __value;
      return this;
    }

    private Builder keepAliveTime(String __value) {
      return keepAliveTime(Double.valueOf(__value));
    }

    public Builder queueSize(int __value) {
      queueSize = __value;
      return this;
    }

    private Builder queueSize(String __value) {
      return queueSize(Integer.valueOf(__value));
    }

    public Builder maxThreadExecutionTimeSeconds(int __value) {
      maxThreadExecutionTimeSeconds = __value;
      return this;
    }

    private Builder maxThreadExecutionTimeSeconds(String __value) {
      return maxThreadExecutionTimeSeconds(Integer.valueOf(__value));
    }

    public Builder name(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      name = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ContainerThreadpoolConfig build() {
      return new ContainerThreadpoolConfig(this);
    }

  }

  // Maximum number of thread in the thread pool
  // 0 is translated to vcpu*4
  // Negative value is interpreted as scale factor ( vcpu*abs(maxThreads) )
  private final IntegerNode maxThreads;
  // Minimum number of thread in the thread pool
  // 0 is translated to vcpu*2
  // Negative value is interpreted as scale factor ( vcpu*abs(minThreads) )
  private final IntegerNode minThreads;
  // The number of seconds that excess idle threads will wait for new tasks before terminating
  private final DoubleNode keepAliveTime;
  // Max queue size
  // Negative value is interpreted as scale factor ( effectiveMaxThreads*abs(queueSize) )
  private final IntegerNode queueSize;
  // The max time the container tolerates having no threads available before it shuts down to
  // get out of a bad state. This should be set a bit higher than the expected max execution
  // time of each request when in a state of overload, i.e about "worst case execution time*2"
  private final IntegerNode maxThreadExecutionTimeSeconds;
  // Prefix for the name of the threads
  private final StringNode name;

  public ContainerThreadpoolConfig(Builder builder) {
    this(builder, true);
  }

  private ContainerThreadpoolConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "container-threadpool must be initialized: " + builder.__uninitialized);

    maxThreads = (builder.maxThreads == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxThreads);
    minThreads = (builder.minThreads == null) ?
        new IntegerNode(0) : new IntegerNode(builder.minThreads);
    keepAliveTime = (builder.keepAliveTime == null) ?
        new DoubleNode(5.0D) : new DoubleNode(builder.keepAliveTime);
    queueSize = (builder.queueSize == null) ?
        new IntegerNode(0) : new IntegerNode(builder.queueSize);
    maxThreadExecutionTimeSeconds = (builder.maxThreadExecutionTimeSeconds == null) ?
        new IntegerNode(190) : new IntegerNode(builder.maxThreadExecutionTimeSeconds);
    name = (builder.name == null) ?
        new StringNode("default-pool") : new StringNode(builder.name);
  }

  /**
   * @return container-threadpool.maxThreads
   */
  public int maxThreads() {
    return maxThreads.value();
  }

  /**
   * @return container-threadpool.minThreads
   */
  public int minThreads() {
    return minThreads.value();
  }

  /**
   * @return container-threadpool.keepAliveTime
   */
  public double keepAliveTime() {
    return keepAliveTime.value();
  }

  /**
   * @return container-threadpool.queueSize
   */
  public int queueSize() {
    return queueSize.value();
  }

  /**
   * @return container-threadpool.maxThreadExecutionTimeSeconds
   */
  public int maxThreadExecutionTimeSeconds() {
    return maxThreadExecutionTimeSeconds.value();
  }

  /**
   * @return container-threadpool.name
   */
  public String name() {
    return name.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ContainerThreadpoolConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("container-threadpool");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
