// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of log-handler
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LogHandlerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "12e451b3bc55ab74904fa3ab3aa2e3f5";
  public final static String CONFIG_DEF_NAME = "log-handler";
  public final static String CONFIG_DEF_NAMESPACE = "container.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core",
    "logDirectory string default=\"logs/vespa/logarchive/\"",
    "logPattern string default=\".*\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String logDirectory = null;
    private String logPattern = null;

    public Builder() { }

    public Builder(LogHandlerConfig config) {
      logDirectory(config.logDirectory());
      logPattern(config.logPattern());
    }

    private Builder override(Builder __superior) {
      if (__superior.logDirectory != null)
        logDirectory(__superior.logDirectory);
      if (__superior.logPattern != null)
        logPattern(__superior.logPattern);
      return this;
    }

    public Builder logDirectory(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      logDirectory = __value;
      return this;
    }


    public Builder logPattern(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      logPattern = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LogHandlerConfig build() {
      return new LogHandlerConfig(this);
    }

  }

  // Path to log directory, can be relative or absolute.
  // Relative paths will be resolved relative to $VESPA_HOME
  private final StringNode logDirectory;
  // File name regex of logs to include
  private final StringNode logPattern;

  public LogHandlerConfig(Builder builder) {
    this(builder, true);
  }

  private LogHandlerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "log-handler must be initialized: " + builder.__uninitialized);

    logDirectory = (builder.logDirectory == null) ?
        new StringNode("logs/vespa/logarchive/") : new StringNode(builder.logDirectory);
    logPattern = (builder.logPattern == null) ?
        new StringNode(".*") : new StringNode(builder.logPattern);
  }

  /**
   * @return log-handler.logDirectory
   */
  public String logDirectory() {
    return logDirectory.value();
  }

  /**
   * @return log-handler.logPattern
   */
  public String logPattern() {
    return logPattern.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LogHandlerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("log-handler");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
