/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.RequestLog;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.AccessLogRequestLog;
import com.yahoo.jdisc.http.server.jetty.ConnectionMetricAggregator;
import com.yahoo.jdisc.http.server.jetty.ConnectorFactory;
import com.yahoo.jdisc.http.server.jetty.ConnectorSpecificContextHandler;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.JdiscDispatchingHandler;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.MetricAggregatingRequestLog;
import com.yahoo.jdisc.http.server.jetty.ServerMetricReporter;
import com.yahoo.jdisc.http.server.jetty.TlsClientAuthenticationEnforcer;
import com.yahoo.jdisc.http.server.jetty.VoidConnectionLog;
import com.yahoo.jdisc.http.server.jetty.VoidRequestLog;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.service.ServerProvider;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyHttpServer
extends AbstractResource
implements ServerProvider {
    private static final Logger log = Logger.getLogger(JettyHttpServer.class.getName());
    private static final Logger jettyErrorHandlerLog = Logger.getLogger(ErrorHandler.class.getName());
    private final ServerConfig config;
    private final Server server;
    private final List<Integer> listenedPorts = new ArrayList<Integer>();
    private final ServerMetricReporter metricsReporter;
    private final Deque<JDiscContext> contexts = new ConcurrentLinkedDeque<JDiscContext>();

    @Inject
    public JettyHttpServer(Metric metric, ServerConfig serverConfig, ComponentRegistry<ConnectorFactory> connectorFactories, RequestLog requestLog, ConnectionLog connectionLog) {
        if (connectorFactories.allComponents().isEmpty()) {
            throw new IllegalArgumentException("No connectors configured.");
        }
        this.config = serverConfig;
        this.server = new Server();
        this.server.setStopTimeout((long)(serverConfig.stopTimeout() * 1000.0));
        MetricAggregatingRequestLog metricAggregatingRequestLog = new MetricAggregatingRequestLog(this.config.metric());
        this.server.addBean((Object)metricAggregatingRequestLog);
        if (requestLog instanceof VoidRequestLog) {
            this.server.setRequestLog((org.eclipse.jetty.server.RequestLog)metricAggregatingRequestLog);
        } else {
            this.server.setRequestLog((org.eclipse.jetty.server.RequestLog)new RequestLog.Collection(new org.eclipse.jetty.server.RequestLog[]{new AccessLogRequestLog(requestLog), metricAggregatingRequestLog}));
        }
        JettyHttpServer.setupJmx(this.server, serverConfig);
        JettyHttpServer.configureJettyThreadpool(this.server, serverConfig);
        ContextHandlerCollection perConnectorHandlers = new ContextHandlerCollection(new ContextHandler[0]);
        for (ConnectorFactory connectorFactory : connectorFactories.allComponents()) {
            ConnectorConfig connectorConfig = connectorFactory.getConnectorConfig();
            JDiscServerConnector connector = connectorFactory.createConnector(metric, this.server);
            this.server.addConnector((Connector)connector);
            this.listenedPorts.add(connectorConfig.listenPort());
            ConnectorConfig connectorCfg = connector.connectorConfig();
            JdiscDispatchingHandler jdiscHandler = new JdiscDispatchingHandler(this::newestContext);
            boolean authEnforcerEnabled = connectorCfg.tlsClientAuthEnforcer().enable();
            ConnectorSpecificContextHandler contextHandler = new ConnectorSpecificContextHandler(connector, (Handler)(authEnforcerEnabled ? JettyHttpServer.newTlsClientAuthEnforcerHandler(connectorCfg, (Handler)jdiscHandler) : jdiscHandler));
            this.server.addBean((Object)contextHandler);
            perConnectorHandlers.addHandler((Handler)contextHandler);
        }
        StatisticsHandler statisticsHandler = new StatisticsHandler((Handler)JettyHttpServer.newGzipHandler((Handler)perConnectorHandlers));
        ConnectionMetricAggregator connectionMetricAggregator = new ConnectionMetricAggregator(serverConfig, metric, (Handler)statisticsHandler);
        if (!(connectionLog instanceof VoidConnectionLog)) {
            JettyConnectionLogger connectionLogger = new JettyConnectionLogger(serverConfig.connectionLog(), connectionLog, (Handler)connectionMetricAggregator);
            this.server.addBeanToAllConnectors((Object)connectionLogger);
            this.server.setHandler((Handler)connectionLogger);
        } else {
            this.server.setHandler((Handler)connectionMetricAggregator);
        }
        this.server.addBeanToAllConnectors((Object)connectionMetricAggregator);
        this.metricsReporter = new ServerMetricReporter(metric, this.server, statisticsHandler, metricAggregatingRequestLog);
    }

    JDiscContext registerContext(FilterBindings filterBindings, CurrentContainer container, Janitor janitor, Metric metric) {
        JDiscContext context = JDiscContext.of(filterBindings, container, janitor, metric, this.config);
        this.contexts.addFirst(context);
        return context;
    }

    void deregisterContext(JDiscContext context) {
        this.contexts.remove(context);
    }

    JDiscContext newestContext() {
        JDiscContext context = this.contexts.peekFirst();
        if (context == null) {
            throw new IllegalStateException("JettyHttpServer has no registered JDiscContext");
        }
        return context;
    }

    private static void setupJmx(Server server, ServerConfig serverConfig) {
        if (serverConfig.jmx().enabled()) {
            System.setProperty("java.rmi.server.hostname", "localhost");
            server.addBean((Object)new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
            server.addBean((Object)new ConnectorServer(JettyHttpServer.createJmxLoopbackOnlyServiceUrl(serverConfig.jmx().listenPort()), "org.eclipse.jetty.jmx:name=rmiconnectorserver"));
        }
    }

    private static void configureJettyThreadpool(Server server, ServerConfig config) {
        int cpus = Runtime.getRuntime().availableProcessors();
        QueuedThreadPool pool = (QueuedThreadPool)server.getThreadPool();
        int maxThreads = config.maxWorkerThreads() > 0 ? config.maxWorkerThreads() : 16 + cpus;
        pool.setMaxThreads(maxThreads);
        int minThreads = config.minWorkerThreads() >= 0 ? config.minWorkerThreads() : 16 + cpus;
        pool.setMinThreads(minThreads);
        log.info(String.format("Threadpool size: min=%d, max=%d", minThreads, maxThreads));
    }

    private static JMXServiceURL createJmxLoopbackOnlyServiceUrl(int port) {
        try {
            return new JMXServiceURL("rmi", "localhost", port, "/jndi/rmi://localhost:" + port + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDisplayName(List<Integer> ports) {
        return ports.stream().map(Object::toString).collect(Collectors.joining(":"));
    }

    public void start() {
        try {
            this.server.start();
            if (this.config.metric().reporterEnabled()) {
                this.metricsReporter.start();
            }
            this.logEffectiveSslConfiguration();
        }
        catch (Exception e) {
            if (e instanceof IOException && e.getCause() instanceof BindException) {
                throw new RuntimeException("Failed to start server due to BindException. ListenPorts = " + this.listenedPorts.toString(), e.getCause());
            }
            throw new RuntimeException("Failed to start server.", e);
        }
    }

    private void logEffectiveSslConfiguration() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException();
        }
        for (Connector connector : this.server.getConnectors()) {
            ServerConnector serverConnector = (ServerConnector)connector;
            int localPort = serverConnector.getLocalPort();
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            if (sslConnectionFactory == null) continue;
            SslContextFactory.Server sslContextFactory = sslConnectionFactory.getSslContextFactory();
            String protocols = Arrays.toString(sslContextFactory.getSelectedProtocols());
            String cipherSuites = Arrays.toString(sslContextFactory.getSelectedCipherSuites());
            log.info(String.format("TLS for port '%d': %s with %s", localPort, protocols, cipherSuites));
        }
    }

    public void close() {
        try {
            log.log(Level.INFO, String.format("Shutting down Jetty server (graceful=%b, timeout=%.1fs)", this.isGracefulShutdownEnabled(), (double)this.server.getStopTimeout() / 1000.0));
            long start = System.currentTimeMillis();
            this.server.stop();
            log.log(Level.INFO, String.format("Jetty server shutdown completed in %.3f seconds", (double)(System.currentTimeMillis() - start) / 1000.0));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Jetty server shutdown threw an unexpected exception.", e);
        }
        this.metricsReporter.shutdown();
    }

    private boolean isGracefulShutdownEnabled() {
        return this.server.getStopTimeout() > 0L;
    }

    public int getListenPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    Server server() {
        return this.server;
    }

    private static TlsClientAuthenticationEnforcer newTlsClientAuthEnforcerHandler(ConnectorConfig cfg, Handler handler) {
        return new TlsClientAuthenticationEnforcer(cfg.tlsClientAuthEnforcer(), handler);
    }

    private static GzipHandler newGzipHandler(Handler handler) {
        GzipHandler h = new GzipHandler(handler);
        h.setInflateBufferSize(8192);
        h.setIncludedMethods(new String[]{"GET", "POST", "PUT", "PATCH"});
        return h;
    }

    static {
        jettyErrorHandlerLog.setLevel(Level.SEVERE);
    }
}

