/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.application.BindingSet;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class FilterBindings {
    private final Map<String, RequestFilter> requestFilters;
    private final Map<String, ResponseFilter> responseFilters;
    private final Map<Integer, String> defaultRequestFilters;
    private final Map<Integer, String> defaultResponseFilters;
    private final BindingSet<String> requestFilterBindings;
    private final BindingSet<String> responseFilterBindings;
    private final boolean strictFiltering;

    private FilterBindings(Map<String, RequestFilter> requestFilters, Map<String, ResponseFilter> responseFilters, Map<Integer, String> defaultRequestFilters, Map<Integer, String> defaultResponseFilters, BindingSet<String> requestFilterBindings, BindingSet<String> responseFilterBindings, boolean strictFiltering) {
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.defaultRequestFilters = defaultRequestFilters;
        this.defaultResponseFilters = defaultResponseFilters;
        this.requestFilterBindings = requestFilterBindings;
        this.responseFilterBindings = responseFilterBindings;
        this.strictFiltering = strictFiltering;
    }

    public Optional<String> resolveRequestFilter(URI uri, int localPort) {
        String filterId = (String)this.requestFilterBindings.resolve(uri);
        if (filterId != null) {
            return Optional.of(filterId);
        }
        return Optional.ofNullable(this.defaultRequestFilters.get(localPort));
    }

    public Optional<String> resolveResponseFilter(URI uri, int localPort) {
        String filterId = (String)this.responseFilterBindings.resolve(uri);
        if (filterId != null) {
            return Optional.of(filterId);
        }
        return Optional.ofNullable(this.defaultResponseFilters.get(localPort));
    }

    public RequestFilter getRequestFilter(String filterId) {
        return this.requestFilters.get(filterId);
    }

    public ResponseFilter getResponseFilter(String filterId) {
        return this.responseFilters.get(filterId);
    }

    public Collection<String> requestFilterIds() {
        return this.requestFilters.keySet();
    }

    public Collection<String> responseFilterIds() {
        return this.responseFilters.keySet();
    }

    public Collection<RequestFilter> requestFilters() {
        return this.requestFilters.values();
    }

    public Collection<ResponseFilter> responseFilters() {
        return this.responseFilters.values();
    }

    public boolean strictFiltering() {
        return this.strictFiltering;
    }

    public static class Builder {
        private final Map<String, RequestFilter> requestFilters = new TreeMap<String, RequestFilter>();
        private final Map<String, ResponseFilter> responseFilters = new TreeMap<String, ResponseFilter>();
        private final Map<Integer, String> defaultRequestFilters = new TreeMap<Integer, String>();
        private final Map<Integer, String> defaultResponseFilters = new TreeMap<Integer, String>();
        private final BindingRepository<String> requestFilterBindings = new BindingRepository();
        private final BindingRepository<String> responseFilterBindings = new BindingRepository();
        private boolean strictFiltering = false;

        public Builder addRequestFilter(String id, RequestFilter filter) {
            this.requestFilters.put(id, filter);
            return this;
        }

        public Builder addResponseFilter(String id, ResponseFilter filter) {
            this.responseFilters.put(id, filter);
            return this;
        }

        public Builder addRequestFilterBinding(String id, String binding) {
            this.requestFilterBindings.bind(binding, (Object)id);
            return this;
        }

        public Builder addResponseFilterBinding(String id, String binding) {
            this.responseFilterBindings.bind(binding, (Object)id);
            return this;
        }

        public Builder setRequestFilterDefaultForPort(String id, int port) {
            this.defaultRequestFilters.put(port, id);
            return this;
        }

        public Builder setResponseFilterDefaultForPort(String id, int port) {
            this.defaultResponseFilters.put(port, id);
            return this;
        }

        public Builder setStrictFiltering(boolean strictFiltering) {
            this.strictFiltering = strictFiltering;
            return this;
        }

        public FilterBindings build() {
            return new FilterBindings(Collections.unmodifiableMap(this.requestFilters), Collections.unmodifiableMap(this.responseFilters), Collections.unmodifiableMap(this.defaultRequestFilters), Collections.unmodifiableMap(this.defaultResponseFilters), (BindingSet<String>)this.requestFilterBindings.activate(), (BindingSet<String>)this.responseFilterBindings.activate(), this.strictFiltering);
        }
    }
}

