/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.OverloadException;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.AccessLoggingRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FilteringRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FormPostRequestHandler;
import com.yahoo.jdisc.http.server.jetty.HttpRequestFactory;
import com.yahoo.jdisc.http.server.jetty.HttpServerConformanceTestHooks;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.JettyRequestContentReader;
import com.yahoo.jdisc.http.server.jetty.JettyResponseWriter;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.service.BindingSetNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.internal.HttpConnection;
import org.eclipse.jetty.util.Callback;

class JdiscDispatchingHandler
extends Handler.Abstract.NonBlocking {
    public static final String ATTRIBUTE_NAME_ACCESS_LOG_ENTRY = "ai.vespa.jetty.ACCESS_LOG_ENTRY";
    public static final String ACCESS_LOG_STATUS_CODE_OVERRIDE = "ai.vespa.jetty.ACCESS_LOG_STATUS_CODE_OVERRIDE";
    private static final Logger log = Logger.getLogger(JdiscDispatchingHandler.class.getName());
    private final Supplier<JDiscContext> contextSupplier;

    JdiscDispatchingHandler(Supplier<JDiscContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    public boolean handle(org.eclipse.jetty.server.Request jettyRequest, Response jettyResponse, Callback callback) throws Exception {
        try {
            this.processJettyRequest(jettyRequest, jettyResponse, callback);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Unexpected error when processing request", t);
            callback.failed(t);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJettyRequest(org.eclipse.jetty.server.Request jettyRequest, Response jettyResponse, Callback callback) {
        JettyRequestContentReader contentReader;
        HttpRequest jdiscRequest;
        JDiscContext context = this.contextSupplier.get();
        JDiscServerConnector connector = RequestUtils.getConnector(jettyRequest);
        jettyRequest.setAttribute(JDiscServerConnector.REQUEST_ATTRIBUTE, (Object)connector);
        Metric.Context metricContext = connector.createRequestMetricContext(jettyRequest);
        context.metric().add(MetricDefinitions.NUM_REQUESTS, (Number)1, metricContext);
        context.metric().add(MetricDefinitions.JDISC_HTTP_REQUESTS, (Number)1, metricContext);
        AccessLogEntry accessLogEntry = new AccessLogEntry();
        jettyRequest.setAttribute(ATTRIBUTE_NAME_ACCESS_LOG_ENTRY, (Object)accessLogEntry);
        if (!RequestUtils.SUPPORTED_METHODS.contains(jettyRequest.getMethod().toUpperCase())) {
            Response.writeError((org.eclipse.jetty.server.Request)jettyRequest, (Response)jettyResponse, (Callback)callback, (int)405);
            return;
        }
        RequestHandler requestHandler = this.newRequestHandler(context, accessLogEntry, jettyRequest);
        RequestMetricReporter metricReporter = new RequestMetricReporter(context.metric(), metricContext, org.eclipse.jetty.server.Request.getTimeStamp((org.eclipse.jetty.server.Request)jettyRequest));
        JettyResponseWriter responseWriter = new JettyResponseWriter(jettyRequest, jettyResponse, metricReporter);
        JdiscDispatchingHandler.shutdownConnectionGracefullyIfThresholdReached(connector, jettyRequest);
        metricReporter.uriLength(jettyRequest.getHttpURI().getPath().length());
        CompletableFuture requestCompletion = new CompletableFuture();
        ResourceReference requestRef = null;
        try {
            jdiscRequest = HttpRequestFactory.newJDiscRequest(context.container(), jettyRequest);
            requestRef = References.fromResource((SharedResource)jdiscRequest);
        }
        catch (Throwable error2) {
            requestCompletion.completeExceptionally(error2);
            return;
        }
        finally {
            ResourceReference finalRequestRef = requestRef;
            requestCompletion.whenComplete((result, error) -> {
                if (error != null) {
                    this.onFailure(metricReporter, responseWriter, jettyRequest, callback, (Throwable)error, context.developerMode(), finalRequestRef);
                } else {
                    this.onSuccess(metricReporter, callback, finalRequestRef);
                }
            });
        }
        try {
            ContentChannel requestContentChannel = requestHandler.handleRequest((Request)jdiscRequest, (ResponseHandler)responseWriter);
            contentReader = new JettyRequestContentReader(metricReporter, context.janitor(), jettyRequest, requestContentChannel);
        }
        catch (Throwable error3) {
            requestCompletion.completeExceptionally(error3);
            return;
        }
        CompletionStage readCompletion = contentReader.readCompletion().exceptionally(error -> {
            requestCompletion.completeExceptionally((Throwable)error);
            return null;
        });
        CompletionStage writeCompletion = responseWriter.writeCompletion().exceptionally(error -> {
            requestCompletion.completeExceptionally((Throwable)error);
            return null;
        });
        CompletableFuture.allOf(new CompletableFuture[]{readCompletion, writeCompletion}).whenComplete((result, error) -> {
            if (error == null) {
                requestCompletion.complete(null);
            }
        });
        contentReader.start();
    }

    private void onFailure(RequestMetricReporter metricReporter, JettyResponseWriter responseWriter, org.eclipse.jetty.server.Request jettyRequest, Callback callback, Throwable error, boolean developerMode, ResourceReference requestRef) {
        JdiscDispatchingHandler.releaseReference(requestRef);
        responseWriter.tryWriteErrorResponse(JdiscDispatchingHandler.unwrapException(error), callback, developerMode);
        HttpServerConformanceTestHooks.markAsProcessed(JdiscDispatchingHandler.unwrapException(error));
        String uriPath = jettyRequest.getHttpURI().getPath();
        if (JdiscDispatchingHandler.isErrorOfType(error, EofException.class, IOException.class)) {
            log.log(Level.FINE, error, () -> "Network connection was unexpectedly terminated: " + uriPath);
            metricReporter.prematurelyClosed();
            jettyRequest.setAttribute(ACCESS_LOG_STATUS_CODE_OVERRIDE, (Object)499);
        } else if (JdiscDispatchingHandler.isErrorOfType(error, TimeoutException.class)) {
            log.log(Level.FINE, error, () -> "Request/stream was timed out by Jetty: " + uriPath);
            jettyRequest.setAttribute(ACCESS_LOG_STATUS_CODE_OVERRIDE, (Object)408);
        } else if (!JdiscDispatchingHandler.isErrorOfType(error, OverloadException.class, BindingNotFoundException.class, BindingSetNotFoundException.class, RequestException.class)) {
            log.log(Level.WARNING, "Request failed: " + uriPath, error);
        }
        metricReporter.failedResponse();
    }

    private static Throwable unwrapException(Throwable t) {
        return t instanceof CompletionException || t instanceof ExecutionException ? t.getCause() : t;
    }

    private void onSuccess(RequestMetricReporter metricReporter, Callback callback, ResourceReference requestRef) {
        JdiscDispatchingHandler.releaseReference(requestRef);
        callback.succeeded();
        metricReporter.successfulResponse();
    }

    private static void releaseReference(ResourceReference ref) {
        try {
            if (ref != null) {
                ref.close();
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Failed to close request reference", t);
        }
    }

    private static void shutdownConnectionGracefullyIfThresholdReached(JDiscServerConnector connector, org.eclipse.jetty.server.Request jettyRequest) {
        double maxConnectionLifeInSeconds;
        ConnectorConfig connectorConfig = connector.connectorConfig();
        int maxRequestsPerConnection = connectorConfig.maxRequestsPerConnection();
        Connection connection = RequestUtils.getConnection(jettyRequest);
        if (maxRequestsPerConnection > 0 && connection.getMessagesIn() >= (long)maxRequestsPerConnection) {
            JdiscDispatchingHandler.gracefulShutdown(connection);
        }
        if ((maxConnectionLifeInSeconds = connectorConfig.maxConnectionLife()) > 0.0) {
            long createdAt = connection.getCreatedTimeStamp();
            long tenPctVariance = connection.hashCode() % 10;
            Instant expiredAt = Instant.ofEpochMilli((long)((double)createdAt + maxConnectionLifeInSeconds * 10.0 * (double)(100L - tenPctVariance)));
            boolean isExpired = Instant.now().isAfter(expiredAt);
            if (isExpired) {
                JdiscDispatchingHandler.gracefulShutdown(connection);
            }
        }
    }

    private static void gracefulShutdown(Connection connection) {
        if (connection instanceof HttpConnection) {
            HttpConnection http1 = (HttpConnection)connection;
            http1.getGenerator().setPersistent(false);
        } else if (connection instanceof HTTP2ServerConnection) {
            HTTP2ServerConnection http2 = (HTTP2ServerConnection)connection;
            http2.getSession().shutdown();
        }
    }

    private RequestHandler newRequestHandler(JDiscContext context, AccessLogEntry accessLogEntry, org.eclipse.jetty.server.Request jettyRequest) {
        RequestHandler requestHandler = JdiscDispatchingHandler.wrapHandlerIfFormPost((RequestHandler)new FilteringRequestHandler(context.filterResolver(), jettyRequest), jettyRequest, context.removeRawPostBodyForWwwUrlEncodedPost());
        return new AccessLoggingRequestHandler(jettyRequest, requestHandler, accessLogEntry);
    }

    private static RequestHandler wrapHandlerIfFormPost(RequestHandler requestHandler, org.eclipse.jetty.server.Request request, boolean removeBodyForFormPost) {
        if (!request.getMethod().equals("POST")) {
            return requestHandler;
        }
        String contentType = request.getHeaders().get("Content-Type");
        if (contentType == null) {
            return requestHandler;
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded")) {
            return requestHandler;
        }
        return new FormPostRequestHandler(requestHandler, JdiscDispatchingHandler.getCharsetName(contentType), removeBodyForFormPost);
    }

    private static String getCharsetName(String contentType) {
        String charsetAnnotation = ";charset=";
        if (!contentType.startsWith(charsetAnnotation, "application/x-www-form-urlencoded".length())) {
            return StandardCharsets.UTF_8.name();
        }
        return contentType.substring("application/x-www-form-urlencoded".length() + charsetAnnotation.length());
    }

    @SafeVarargs
    private static boolean isErrorOfType(Throwable throwable, Class<? extends Throwable> ... handledTypes) {
        return Arrays.stream(handledTypes).anyMatch(exceptionType -> exceptionType.isInstance(JdiscDispatchingHandler.unwrapException(throwable)));
    }
}

