/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.http.server.jetty.SimpleConcurrentIdentityHashMap;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

class ConnectionMetricAggregator
extends AbstractLifeCycle
implements Connection.Listener,
HttpChannel.Listener {
    private final SimpleConcurrentIdentityHashMap<Connection, ConnectionMetrics> connectionsMetrics = new SimpleConcurrentIdentityHashMap();
    private final Metric metricAggregator;
    private final Collection<String> monitoringHandlerPaths;

    ConnectionMetricAggregator(ServerConfig serverConfig, Metric metricAggregator) {
        this.monitoringHandlerPaths = serverConfig.metric().monitoringHandlerPaths();
        this.metricAggregator = metricAggregator;
    }

    public void onOpened(Connection connection) {
    }

    public void onClosed(Connection connection) {
        if (RequestUtils.isHttpServerConnection(connection)) {
            this.connectionsMetrics.remove(connection).ifPresent(metrics -> this.metricAggregator.set(MetricDefinitions.REQUESTS_PER_CONNECTION, (Number)metrics.requests.get(), metrics.metricContext));
        }
    }

    public void onRequestBegin(Request request) {
        if (this.monitoringHandlerPaths.stream().anyMatch(pathPrefix -> request.getRequestURI().startsWith((String)pathPrefix))) {
            return;
        }
        Connection connection = request.getHttpChannel().getConnection();
        if (RequestUtils.isHttpServerConnection(connection)) {
            ConnectionMetrics metrics = this.connectionsMetrics.computeIfAbsent(connection, () -> new ConnectionMetrics(RequestUtils.getConnector(request).getConnectorMetricContext()));
            metrics.requests.incrementAndGet();
        }
    }

    private static class ConnectionMetrics {
        final AtomicLong requests = new AtomicLong();
        final Metric.Context metricContext;

        ConnectionMetrics(Metric.Context metricContext) {
            this.metricContext = metricContext;
        }
    }
}

