/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.ConnectorConfig;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

class TlsClientAuthenticationEnforcer
extends HandlerWrapper {
    private final ConnectorConfig.TlsClientAuthEnforcer cfg;

    TlsClientAuthenticationEnforcer(ConnectorConfig.TlsClientAuthEnforcer cfg) {
        if (!cfg.enable()) {
            throw new IllegalArgumentException();
        }
        this.cfg = cfg;
    }

    public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        if (this.isRequest(request) && !this.isRequestToWhitelistedBinding(request) && !this.isClientAuthenticated(servletRequest)) {
            servletResponse.sendError(401, "Client did not present a x509 certificate, or presented a certificate not issued by any of the CA certificates in trust store.");
        } else {
            this._handler.handle(target, request, servletRequest, servletResponse);
        }
    }

    private boolean isRequest(Request request) {
        return request.getDispatcherType() == DispatcherType.REQUEST;
    }

    private boolean isRequestToWhitelistedBinding(Request jettyRequest) {
        return this.cfg.pathWhitelist().contains(jettyRequest.getRequestURI());
    }

    private boolean isClientAuthenticated(HttpServletRequest servletRequest) {
        return servletRequest.getAttribute("jakarta.servlet.request.X509Certificate") != null;
    }
}

