/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    static SimpleDateFormat ddMMMyyyy = new SimpleDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]", Locale.US);
    static DateFormat dfMMM;
    static SimpleDateFormat yyyyMMdd;
    private boolean messageOnly = false;
    private static final int timestampFormat = 2;

    public void messageOnly(boolean messageOnly) {
        this.messageOnly = messageOnly;
    }

    @Override
    public String format(LogRecord record) {
        if (this.messageOnly) {
            return this.formatMessage(record);
        }
        String rawMsg = record.getMessage();
        boolean isLogMsg = rawMsg.charAt(0) == 'L' && rawMsg.charAt(1) == 'O' && rawMsg.charAt(2) == 'G' && rawMsg.charAt(3) == ':';
        String nameInsert = !isLogMsg ? record.getLevel().getName() + ": " : "";
        return this.timeStamp(record) + nameInsert + this.formatMessage(record) + "\n";
    }

    public static String insertDate(String pattern, long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd:HH:mm:ss.SSS Z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date(time);
        String datetime = df.format(date);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            int j = pattern.indexOf(37, i);
            if (j == -1 || j >= pattern.length() - 1) {
                result.append(pattern.substring(i));
                break;
            }
            result.append(pattern.substring(i, j));
            switch (pattern.charAt(j + 1)) {
                case 'Y': {
                    result.append(datetime.substring(0, 4));
                    break;
                }
                case 'm': {
                    result.append(datetime.substring(5, 7));
                    break;
                }
                case 'd': {
                    result.append(datetime.substring(8, 10));
                    break;
                }
                case 'H': {
                    result.append(datetime.substring(11, 13));
                    break;
                }
                case 'M': {
                    result.append(datetime.substring(14, 16));
                    break;
                }
                case 'S': {
                    result.append(datetime.substring(17, 19));
                    break;
                }
                case 's': {
                    result.append(datetime.substring(20, 23));
                    break;
                }
                case 'Z': {
                    result.append(datetime.substring(24));
                    break;
                }
                case 'T': {
                    result.append(Long.toString(time));
                    break;
                }
                case 'x': {
                    result.append(LogFormatter.capitalize(dfMMM.format(date)));
                    break;
                }
                case '%': {
                    result.append("%%");
                    break;
                }
                default: {
                    result.append("%");
                    --j;
                }
            }
            i = j + 2;
        }
        return result.toString();
    }

    private String timeStamp(LogRecord record) {
        Date date = new Date(record.getMillis());
        return switch (2) {
            case 0 -> Long.toString(record.getMillis());
            case 1 -> ddMMMyyyy.format(date);
            default -> yyyyMMdd.format(date);
        };
    }

    private static String capitalize(String string) {
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    static {
        ddMMMyyyy.setTimeZone(TimeZone.getTimeZone("UTC"));
        dfMMM = new SimpleDateFormat("MMM", Locale.US);
        dfMMM.setTimeZone(TimeZone.getTimeZone("UTC"));
        yyyyMMdd = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss]", Locale.US);
        yyyyMMdd.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

