/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request.properties;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.Properties;
import java.util.HashMap;
import java.util.Map;

public class PropertyMap
extends Properties {
    private Map<CompoundName, Object> properties = new HashMap<CompoundName, Object>();

    @Override
    public void set(CompoundName name, Object value, Map<String, String> context) {
        if (this.shouldSet(name, value)) {
            this.properties.put(name, value);
        } else {
            super.set(name, value, context);
        }
    }

    protected boolean shouldSet(CompoundName name, Object value) {
        return true;
    }

    @Override
    public Object get(CompoundName name, Map<String, String> context, Properties substitution) {
        if (!this.properties.containsKey(name)) {
            return super.get(name, context, substitution);
        }
        return this.properties.get(name);
    }

    @Override
    public PropertyMap clone() {
        PropertyMap clone = (PropertyMap)super.clone();
        clone.properties = PropertyMap.cloneMap(this.properties);
        return clone;
    }

    @Override
    public Map<String, Object> listProperties(CompoundName path, Map<String, String> context, Properties substitution) {
        Map<String, Object> map = super.listProperties(path, context, substitution);
        for (Map.Entry<CompoundName, Object> entry : this.properties.entrySet()) {
            CompoundName propertyName;
            if (!entry.getKey().hasPrefix(path) || (propertyName = entry.getKey().rest(path.size())).isEmpty()) continue;
            map.put(propertyName.toString(), entry.getValue());
        }
        return map;
    }
}

