/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.X509CertificateWithKey;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataplaneProxyCredentials
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(DataplaneProxyCredentials.class.getName());
    private final Path certificateFile;
    private final Path keyFile;
    private final X509Certificate certificate;

    @Inject
    public DataplaneProxyCredentials() {
        this(Paths.get(Defaults.getDefaults().underVespaHome("secure/proxy_cert.pem"), new String[0]), Paths.get(Defaults.getDefaults().underVespaHome("secure/proxy_key.pem"), new String[0]));
    }

    public DataplaneProxyCredentials(Path certificateFile, Path keyFile) {
        this.certificateFile = certificateFile;
        this.keyFile = keyFile;
        X509Certificate existing = this.regenerateCredentials(certificateFile, keyFile).orElse(null);
        if (existing == null) {
            X509CertificateWithKey selfSigned = X509CertificateUtils.createSelfSigned((String)"cn=vespa dataplane proxy", (Duration)Duration.ofDays(30L));
            Exceptions.uncheck(() -> Files.writeString(certificateFile, (CharSequence)X509CertificateUtils.toPem((X509Certificate)selfSigned.certificate()), new OpenOption[0]));
            Exceptions.uncheck(() -> Files.writeString(keyFile, (CharSequence)KeyUtils.toPem((PrivateKey)selfSigned.privateKey()), new OpenOption[0]));
            this.certificate = selfSigned.certificate();
        } else {
            this.certificate = existing;
        }
    }

    private Optional<X509Certificate> regenerateCredentials(Path certificateFile, Path keyFile) {
        if (!Files.exists(certificateFile, new LinkOption[0]) || !Files.exists(keyFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            X509Certificate x509Certificate = X509CertificateUtils.fromPem((String)Files.readString(certificateFile));
            PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)Files.readString(keyFile));
            if (!X509CertificateUtils.privateKeyMatchesPublicKey((PrivateKey)privateKey, (PublicKey)x509Certificate.getPublicKey())) {
                return Optional.empty();
            }
            return Optional.of(x509Certificate);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to load credentials: %s".formatted(e.getMessage()));
            log.log(Level.FINE, e.toString(), e);
            return Optional.empty();
        }
    }

    public Path certificateFile() {
        return this.certificateFile;
    }

    public Path keyFile() {
        return this.keyFile;
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public void deconstruct() {
        super.deconstruct();
    }
}

