/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class MetricsV2Handler
extends HttpHandlerBase {
    public static final String V2_PATH = "/metrics/v2";
    static final String VALUES_PATH = "/metrics/v2/values";
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private final String metricsProxyUri;
    private final CloseableHttpClient httpClient = MetricsV2Handler.createHttpClient();

    @Inject
    public MetricsV2Handler(Executor executor, MetricsProxyApiConfig config) {
        super(executor);
        this.metricsProxyUri = "http://localhost:" + config.metricsPort() + config.metricsApiPath();
    }

    @Override
    protected Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V2_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private JsonResponse valuesResponse(String consumer) {
        try {
            String uri = this.metricsProxyUri + MetricsV2Handler.consumerQuery(consumer);
            String metricsJson = (String)this.httpClient.execute((ClassicHttpRequest)new HttpGet(uri), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            return new JsonResponse(200, metricsJson);
        }
        catch (IOException e) {
            this.log.warning("Unable to retrieve metrics from " + this.metricsProxyUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create().setUserAgent("application-metrics-retriever").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000L, TimeUnit.MILLISECONDS).setResponseTimeout(30000L, TimeUnit.MILLISECONDS).build()).build();
    }

    static String consumerQuery(String consumer) {
        return consumer == null || consumer.isEmpty() ? "" : "?consumer=" + consumer;
    }

    public void destroy() {
        super.destroy();
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Failed closing http client", e);
        }
    }
}

