/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.concurrent.ThreadLocalDirectory;
import com.yahoo.metrics.ManagerConfig;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.DimensionCache;
import com.yahoo.metrics.simple.Sample;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

class MetricAggregator
implements Runnable {
    private final ThreadLocalDirectory<Bucket, Sample> metricsCollection;
    private final AtomicReference<Bucket> currentSnapshot;
    private int generation = 0;
    private final Bucket[] buffer;
    private long fromMillis;
    private final DimensionCache dimensions;

    MetricAggregator(ThreadLocalDirectory<Bucket, Sample> metricsCollection, AtomicReference<Bucket> currentSnapshot, ManagerConfig settings) {
        if (settings.reportPeriodSeconds() < 10) {
            throw new IllegalArgumentException("Do not use this metrics implementation if report periods of less than 10 seconds is desired.");
        }
        this.buffer = new Bucket[settings.reportPeriodSeconds()];
        this.dimensions = new DimensionCache(settings.pointsToKeepPerMetric());
        this.fromMillis = System.currentTimeMillis();
        this.metricsCollection = metricsCollection;
        this.currentSnapshot = currentSnapshot;
    }

    @Override
    public void run() {
        Bucket toDelete = this.updateBuffer();
        this.createSnapshot(toDelete);
    }

    private void createSnapshot(Bucket toDelete) {
        Bucket toPresent = new Bucket();
        for (Bucket b : this.buffer) {
            if (b == null) continue;
            toPresent.merge(b);
        }
        this.dimensions.updateDimensionPersistence(toDelete, toPresent);
        this.currentSnapshot.set(toPresent);
    }

    private Bucket updateBuffer() {
        List buckets = this.metricsCollection.fetch();
        long toMillis = System.currentTimeMillis();
        int bucketIndex = this.generation++ % this.buffer.length;
        Bucket bucketToDelete = this.buffer[bucketIndex];
        Bucket latest = new Bucket(this.fromMillis, toMillis);
        for (Bucket b : buckets) {
            latest.merge(b, true);
        }
        this.buffer[bucketIndex] = latest;
        this.fromMillis = toMillis;
        return bucketToDelete;
    }
}

