/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.jdisc.RequestView;
import com.yahoo.container.jdisc.utils.CapabilityRequiringRequestHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.security.tls.CapabilitySet;
import com.yahoo.security.tls.ConnectionAuthContext;
import com.yahoo.security.tls.MissingCapabilitiesException;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.net.ssl.SSLSession;

class CapabilityEnforcingRequestHandler
implements DelegatedRequestHandler {
    private final RequestHandler wrapped;

    CapabilityEnforcingRequestHandler(RequestHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ContentChannel handleRequest(Request req, ResponseHandler responseHandler) {
        CapabilityRequiringRequestHandler capabilityRequiringHandler = DelegatedRequestHandler.resolve(CapabilityRequiringRequestHandler.class, (RequestHandler)this.wrapped).orElse(null);
        CapabilitySet requiredCapabilities = capabilityRequiringHandler != null ? capabilityRequiringHandler.requiredCapabilities(new View(req)) : CapabilityRequiringRequestHandler.DEFAULT_REQUIRED_CAPABILITY.toCapabilitySet();
        ConnectionAuthContext authCtx = Optional.ofNullable(req.context().get("jdisc.request.SSLSession")).flatMap(s -> TransportSecurityUtils.getConnectionAuthContext((SSLSession)((SSLSession)s))).orElse(null);
        if (authCtx != null) {
            String peer = Optional.ofNullable(((HttpRequest)req).getRemoteAddress()).map(Object::toString).orElse("<unknown>");
            String method = ((HttpRequest)req).getMethod().name();
            try {
                authCtx.verifyCapabilities(requiredCapabilities, method, req.getUri().getPath(), peer);
            }
            catch (MissingCapabilitiesException e) {
                int code = 403;
                Response resp = new Response(code);
                resp.headers().add("Content-Type", "application/json");
                ContentChannel ch = responseHandler.handleResponse(resp);
                Slime slime = new Slime();
                Cursor root = slime.setObject();
                root.setString("error-code", Integer.toString(code));
                root.setString("message", "Missing required capabilities");
                ch.write(ByteBuffer.wrap((byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)slime))), null);
                ch.close(null);
                return null;
            }
        }
        return this.wrapped.handleRequest(req, responseHandler);
    }

    public void release() {
        this.wrapped.release();
    }

    public RequestHandler getDelegate() {
        return this.wrapped;
    }

    public void handleTimeout(Request request, ResponseHandler handler) {
        this.wrapped.handleRequest(request, handler);
    }

    public ResourceReference refer() {
        return this.wrapped.refer();
    }

    public ResourceReference refer(Object context) {
        return this.wrapped.refer(context);
    }

    private static class View
    implements RequestView {
        private final HttpRequest req;

        View(Request req) {
            this.req = (HttpRequest)req;
        }

        @Override
        public HttpRequest.Method method() {
            return this.req.getMethod();
        }

        @Override
        public URI uri() {
            return this.req.getUri();
        }
    }
}

