/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.jdisc.http.HttpRequest;
import java.io.InputStream;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpRequestBuilder {
    private final HttpRequest.Method method;
    private final String path;
    private final Map<String, List<String>> queryParameters = new TreeMap<String, List<String>>();
    private final Map<String, String> headers = new TreeMap<String, String>();
    private final Map<String, Object> attributes = new TreeMap<String, Object>();
    private String scheme;
    private String hostname;
    private InputStream content;
    private Principal principal;
    private SocketAddress socketAddress;
    private int port = -1;

    private HttpRequestBuilder(HttpRequest.Method method, String path) {
        this.method = method;
        this.path = path;
    }

    public static HttpRequestBuilder create(HttpRequest.Method method, String path) {
        return new HttpRequestBuilder(method, path);
    }

    public HttpRequestBuilder withQueryParameter(String name, String value) {
        this.queryParameters.computeIfAbsent(name, ignored -> new ArrayList()).add(value);
        return this;
    }

    public HttpRequestBuilder withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpRequestBuilder withRequestContent(InputStream content) {
        this.content = content;
        return this;
    }

    public HttpRequestBuilder withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpRequestBuilder withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public HttpRequestBuilder withPrincipal(Principal p) {
        this.principal = p;
        return this;
    }

    public HttpRequestBuilder withRemoteAddress(SocketAddress sa) {
        this.socketAddress = sa;
        return this;
    }

    public HttpRequestBuilder withAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public HttpRequestBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public HttpRequest build() {
        String scheme = this.scheme != null ? this.scheme : "http";
        String hostname = this.hostname != null ? this.hostname : "localhost";
        StringBuilder uriBuilder = new StringBuilder(scheme).append("://").append(hostname);
        if (this.port > 0) {
            uriBuilder.append(':').append(this.port);
        }
        uriBuilder.append(this.path);
        if (this.queryParameters.size() > 0) {
            uriBuilder.append('?');
            this.queryParameters.forEach((name, values) -> {
                for (String value : values) {
                    uriBuilder.append((String)name).append('=').append(value).append('&');
                }
            });
            int lastIndex = uriBuilder.length() - 1;
            if (uriBuilder.charAt(lastIndex) == '&') {
                uriBuilder.setLength(lastIndex);
            }
        }
        HttpRequest request = this.content != null ? HttpRequest.createTestRequest(uriBuilder.toString(), this.method, this.content) : HttpRequest.createTestRequest(uriBuilder.toString(), this.method);
        this.headers.forEach((name, value) -> request.getJDiscRequest().headers().put(name, value));
        if (this.principal != null) {
            request.getJDiscRequest().setUserPrincipal(this.principal);
        }
        if (this.socketAddress != null) {
            request.getJDiscRequest().setRemoteAddress(this.socketAddress);
        }
        request.getJDiscRequest().context().putAll(this.attributes);
        return request;
    }
}

