/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.io.BufferChain;
import com.yahoo.io.WritableByteTransmitter;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContentChannelOutputStream
extends OutputStream
implements WritableByteTransmitter {
    private static final Logger log = Logger.getLogger(ContentChannelOutputStream.class.getName());
    private final BufferChain buffer;
    private final ContentChannel endpoint;
    private long byteBufferData = 0L;
    private boolean failed = false;
    private final Object failLock = new Object();

    public ContentChannelOutputStream(ContentChannel endpoint) {
        this.endpoint = endpoint;
        this.buffer = new BufferChain((WritableByteTransmitter)this);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.buffer.append((byte)b);
        }
        catch (RuntimeException e) {
            throw new IOException(Exceptions.toMessageString((Throwable)e), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.buffer.flush();
        }
        catch (RuntimeException e) {
            throw new IOException(Exceptions.toMessageString((Throwable)e), e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.nonCopyingWrite(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.nonCopyingWrite(Arrays.copyOf(b, b.length));
    }

    public void nonCopyingWrite(byte[] b, int off, int len) throws IOException {
        try {
            this.buffer.append(b, off, len);
        }
        catch (RuntimeException e) {
            throw new IOException(Exceptions.toMessageString((Throwable)e), e);
        }
    }

    public void nonCopyingWrite(byte[] b) throws IOException {
        try {
            this.buffer.append(b);
        }
        catch (RuntimeException e) {
            throw new IOException(Exceptions.toMessageString((Throwable)e), e);
        }
    }

    public void send(ByteBuffer src) throws IOException {
        this.send(src, null);
    }

    protected void send(ByteBuffer src, CompletionHandler completionHandler) throws IOException {
        try {
            this.byteBufferData += (long)src.remaining();
            this.endpoint.write(src, (CompletionHandler)new LoggingCompletionHandler(completionHandler));
        }
        catch (RuntimeException e) {
            throw new IOException(Exceptions.toMessageString((Throwable)e), e);
        }
    }

    public long written() {
        return this.buffer.appended() + this.byteBufferData;
    }

    private class LoggingCompletionHandler
    implements CompletionHandler {
        private final CompletionHandler nested;

        LoggingCompletionHandler(CompletionHandler nested) {
            this.nested = nested;
        }

        public void completed() {
            if (this.nested != null) {
                this.nested.completed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable t) {
            Level logLevel;
            Object object = ContentChannelOutputStream.this.failLock;
            synchronized (object) {
                logLevel = ContentChannelOutputStream.this.failed ? Level.FINEST : Level.FINE;
                ContentChannelOutputStream.this.failed = true;
            }
            if (log.isLoggable(logLevel)) {
                log.log(logLevel, "Got exception when writing to client: " + Exceptions.toMessageString((Throwable)t));
            }
            if (this.nested != null) {
                this.nested.failed(t);
            }
        }
    }
}

