/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class AccessLoggingRequestHandler
extends AbstractRequestHandler
implements DelegatedRequestHandler {
    public static final String CONTEXT_KEY_ACCESS_LOG_ENTRY = AccessLoggingRequestHandler.class.getName() + "_access-log-entry";
    private final org.eclipse.jetty.server.Request jettyRequest;
    private final RequestHandler delegateRequestHandler;
    private final AccessLogEntry accessLogEntry;
    private final List<String> pathPrefixes;
    private final List<Double> samplingRate;
    private final Random rng = new Random();

    public static Optional<AccessLogEntry> getAccessLogEntry(HttpRequest jdiscRequest) {
        Map requestContextMap = jdiscRequest.context();
        return AccessLoggingRequestHandler.getAccessLogEntry(requestContextMap);
    }

    public static Optional<AccessLogEntry> getAccessLogEntry(Map<String, Object> requestContextMap) {
        return Optional.ofNullable((AccessLogEntry)requestContextMap.get(CONTEXT_KEY_ACCESS_LOG_ENTRY));
    }

    public AccessLoggingRequestHandler(org.eclipse.jetty.server.Request jettyRequest, RequestHandler delegateRequestHandler, AccessLogEntry accessLogEntry) {
        this.jettyRequest = jettyRequest;
        this.delegateRequestHandler = delegateRequestHandler;
        this.accessLogEntry = accessLogEntry;
        List<String> contentPathPrefixes = RequestUtils.getConnector(jettyRequest).connectorConfig().accessLog().contentPathPrefixes();
        this.pathPrefixes = contentPathPrefixes.stream().map(s -> {
            int separatorIndex = s.lastIndexOf(58);
            return s.substring(0, separatorIndex == -1 ? s.length() : separatorIndex);
        }).toList();
        this.samplingRate = contentPathPrefixes.stream().map(s -> Double.parseDouble(s.substring(s.lastIndexOf(58) + 1))).toList();
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        HttpRequest httpRequest = (HttpRequest)request;
        httpRequest.context().put(CONTEXT_KEY_ACCESS_LOG_ENTRY, this.accessLogEntry);
        List<HttpRequest.Method> methodsWithEntity = List.of(HttpRequest.Method.POST, HttpRequest.Method.PUT, HttpRequest.Method.PATCH);
        ContentChannel originalContentChannel = this.delegateRequestHandler.handleRequest(request, handler);
        String uriPath = request.getUri().getPath();
        if (methodsWithEntity.contains((Object)httpRequest.getMethod())) {
            for (int i = 0; i < this.pathPrefixes.size(); ++i) {
                if (!uriPath.startsWith(this.pathPrefixes.get(i)) || !(this.samplingRate.get(i) > this.rng.nextDouble())) continue;
                return new ContentLoggingContentChannel(originalContentChannel);
            }
        }
        return originalContentChannel;
    }

    public RequestHandler getDelegate() {
        return this.delegateRequestHandler;
    }

    private class ContentLoggingContentChannel
    implements ContentChannel {
        private static final int CONTENT_LOGGING_MAX_SIZE = 0x1000000;
        final AtomicLong length = new AtomicLong();
        final ByteArrayOutputStream accumulatedRequestContent;
        final ContentChannel originalContentChannel;

        public ContentLoggingContentChannel(ContentChannel originalContentChannel) {
            this.originalContentChannel = originalContentChannel;
            int contentLength = AccessLoggingRequestHandler.this.jettyRequest.getContentLength();
            this.accumulatedRequestContent = new ByteArrayOutputStream(contentLength == -1 ? 128 : contentLength);
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            this.length.addAndGet(buf.remaining());
            int bytesToLog = Math.min(buf.remaining(), 0x1000000 - this.accumulatedRequestContent.size());
            if (bytesToLog > 0) {
                this.accumulatedRequestContent.write(buf.array(), buf.arrayOffset() + buf.position(), bytesToLog);
            }
            if (this.originalContentChannel != null) {
                this.originalContentChannel.write(buf, handler);
            }
        }

        public void close(CompletionHandler handler) {
            byte[] bytes = this.accumulatedRequestContent.toByteArray();
            AccessLoggingRequestHandler.this.accessLogEntry.setContent(new AccessLogEntry.Content(Objects.requireNonNullElse(AccessLoggingRequestHandler.this.jettyRequest.getHeader("Content-Type"), ""), this.length.get(), bytes));
            this.accumulatedRequestContent.reset();
            this.length.set(0L);
            if (this.originalContentChannel != null) {
                this.originalContentChannel.close(handler);
            }
        }

        public void onError(Throwable error) {
            if (this.originalContentChannel != null) {
                this.originalContentChannel.onError(error);
            }
        }
    }
}

