/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.JettyHttpServer;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

class ResponseMetricAggregator
extends AbstractLifeCycle
implements HttpChannel.Listener {
    static final String requestTypeAttribute = "requestType";
    private final List<String> monitoringHandlerPaths;
    private final List<String> searchHandlerPaths;
    private final Set<String> ignoredUserAgents;
    private final boolean reporterEnabled;
    private final ConcurrentMap<StatusCodeMetric, LongAdder> statistics = new ConcurrentHashMap<StatusCodeMetric, LongAdder>();

    ResponseMetricAggregator(ServerConfig.Metric cfg) {
        this(cfg.monitoringHandlerPaths(), cfg.searchHandlerPaths(), cfg.ignoredUserAgents(), cfg.reporterEnabled());
    }

    ResponseMetricAggregator(List<String> monitoringHandlerPaths, List<String> searchHandlerPaths, Collection<String> ignoredUserAgents, boolean reporterEnabled) {
        this.monitoringHandlerPaths = monitoringHandlerPaths;
        this.searchHandlerPaths = searchHandlerPaths;
        this.ignoredUserAgents = Set.copyOf(ignoredUserAgents);
        this.reporterEnabled = reporterEnabled;
    }

    static ResponseMetricAggregator getBean(JettyHttpServer server) {
        return ResponseMetricAggregator.getBean(server.server());
    }

    static ResponseMetricAggregator getBean(Server server) {
        return Arrays.stream(server.getConnectors()).map(c -> (ResponseMetricAggregator)((Object)((Object)c.getBean(ResponseMetricAggregator.class)))).filter(Objects::nonNull).findAny().orElseThrow();
    }

    public void onResponseCommit(Request request) {
        if (this.shouldLogMetricsFor(request)) {
            Collection<StatusCodeMetric> metrics = StatusCodeMetric.of(request, this.monitoringHandlerPaths, this.searchHandlerPaths);
            metrics.forEach(metric -> this.statistics.computeIfAbsent((StatusCodeMetric)metric, __ -> new LongAdder()).increment());
        }
    }

    List<StatisticsEntry> takeStatistics() {
        if (this.reporterEnabled) {
            throw new IllegalStateException("Cannot take consistent snapshot while reporter is enabled");
        }
        ArrayList<StatisticsEntry> ret = new ArrayList<StatisticsEntry>();
        this.consume((metric, value) -> ret.add(new StatisticsEntry((StatusCodeMetric)metric, value)));
        return ret;
    }

    void reportSnapshot(Metric metricAggregator) {
        if (!this.reporterEnabled) {
            throw new IllegalStateException("Reporter is not enabled");
        }
        this.consume((metric, value) -> {
            Metric.Context ctx = metricAggregator.createContext(metric.dimensions.asMap());
            metricAggregator.add(metric.name, (Number)value, ctx);
        });
    }

    private boolean shouldLogMetricsFor(Request request) {
        String agent = request.getHeader(HttpHeader.USER_AGENT.toString());
        if (agent == null) {
            return true;
        }
        return !this.ignoredUserAgents.contains(agent);
    }

    private void consume(ObjLongConsumer<StatusCodeMetric> consumer) {
        this.statistics.forEach((metric, adder) -> {
            long value = adder.sumThenReset();
            if (value > 0L) {
                consumer.accept((StatusCodeMetric)metric, value);
            }
        });
    }

    private static int statusCode(Request r) {
        return r.getResponse().getCommittedMetaData().getStatus();
    }

    static class StatusCodeMetric {
        final Dimensions dimensions;
        final String name;

        private StatusCodeMetric(Dimensions dimensions, String name) {
            this.dimensions = dimensions;
            this.name = name;
        }

        static Collection<StatusCodeMetric> of(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            Dimensions dimensions = Dimensions.of(req, monitoringHandlerPaths, searchHandlerPaths);
            return StatusCodeMetric.metricNames(req).stream().map(name -> new StatusCodeMetric(dimensions, (String)name)).collect(Collectors.toSet());
        }

        private static Collection<String> metricNames(Request req) {
            int code = ResponseMetricAggregator.statusCode(req);
            if (code < 200) {
                return Set.of(MetricDefinitions.RESPONSES_1XX);
            }
            if (code < 300) {
                return Set.of(MetricDefinitions.RESPONSES_2XX);
            }
            if (code < 400) {
                return Set.of(MetricDefinitions.RESPONSES_3XX);
            }
            if (code < 500) {
                return Set.of(MetricDefinitions.RESPONSES_4XX);
            }
            return Set.of(MetricDefinitions.RESPONSES_5XX);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusCodeMetric that = (StatusCodeMetric)o;
            return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.name);
        }
    }

    static class Dimensions {
        final String protocol;
        final String scheme;
        final String method;
        final String requestType;
        final int statusCode;

        private Dimensions(String protocol, String scheme, String method, String requestType, int statusCode) {
            this.protocol = protocol;
            this.scheme = scheme;
            this.method = method;
            this.requestType = requestType;
            this.statusCode = statusCode;
        }

        static Dimensions of(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            String requestType = Dimensions.requestType(req, monitoringHandlerPaths, searchHandlerPaths);
            return new Dimensions(Dimensions.protocol(req), Dimensions.scheme(req), Dimensions.method(req), requestType, ResponseMetricAggregator.statusCode(req));
        }

        Map<String, Object> asMap() {
            HashMap<String, Object> builder = new HashMap<String, Object>();
            builder.put("protocol", this.protocol);
            builder.put("scheme", this.scheme);
            builder.put("httpMethod", this.method);
            builder.put(ResponseMetricAggregator.requestTypeAttribute, this.requestType);
            builder.put("statusCode", Long.valueOf(this.statusCode));
            return Map.copyOf(builder);
        }

        private static String protocol(Request req) {
            String protocol = req.getProtocol();
            if (protocol == null) {
                return "none";
            }
            return switch (protocol) {
                case "HTTP/1", "HTTP/1.0", "HTTP/1.1" -> "http1";
                case "HTTP/2", "HTTP/2.0" -> "http2";
                default -> "other";
            };
        }

        private static String scheme(Request req) {
            String scheme = req.getScheme();
            if (scheme == null) {
                return "none";
            }
            return switch (scheme) {
                case "http", "https" -> scheme;
                default -> "other";
            };
        }

        private static String method(Request req) {
            String method = req.getMethod();
            if (method == null) {
                return "none";
            }
            return switch (method) {
                case "GET", "PATCH", "POST", "PUT", "DELETE", "OPTIONS", "HEAD" -> method;
                default -> "other";
            };
        }

        private static String requestType(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            Request.RequestType requestType = (Request.RequestType)req.getAttribute(ResponseMetricAggregator.requestTypeAttribute);
            if (requestType != null) {
                return requestType.name().toLowerCase();
            }
            String path = req.getRequestURI();
            if (path == null) {
                return "none";
            }
            for (String monitoringHandlerPath : monitoringHandlerPaths) {
                if (!path.startsWith(monitoringHandlerPath)) continue;
                return "monitoring";
            }
            for (String searchHandlerPath : searchHandlerPaths) {
                if (!path.startsWith(searchHandlerPath)) continue;
                return "read";
            }
            String method = req.getMethod();
            if (method == null) {
                return "none";
            }
            if ("GET".equals(method)) {
                return "read";
            }
            return "write";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dimensions that = (Dimensions)o;
            return this.statusCode == that.statusCode && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.method, that.method) && Objects.equals(this.requestType, that.requestType);
        }

        public int hashCode() {
            return Objects.hash(this.protocol, this.scheme, this.method, this.requestType, this.statusCode);
        }
    }

    static class StatisticsEntry {
        final Dimensions dimensions;
        final String name;
        final long value;

        StatisticsEntry(StatusCodeMetric metric, long value) {
            this.dimensions = metric.dimensions;
            this.name = metric.name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatisticsEntry that = (StatisticsEntry)o;
            return this.value == that.value && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.name, this.value);
        }
    }
}

