/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.dependencies.Provides;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ChainedComponent
extends AbstractComponent {
    private Dependencies dependencies = this.getDefaultAnnotatedDependencies();

    public ChainedComponent(ComponentId id) {
        super(id);
    }

    protected ChainedComponent() {
    }

    public void initDependencies(Dependencies dependencies) {
        this.dependencies = dependencies.union(this.getDefaultAnnotatedDependencies());
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    protected Dependencies getDefaultAnnotatedDependencies() {
        Dependencies dependencies = this.getAnnotatedDependencies(com.yahoo.yolean.chain.Provides.class, com.yahoo.yolean.chain.Before.class, com.yahoo.yolean.chain.After.class);
        Dependencies legacyDependencies = this.getAnnotatedDependencies(Provides.class, Before.class, After.class);
        return dependencies.union(legacyDependencies);
    }

    protected Dependencies getAnnotatedDependencies(Class<? extends Annotation> providesClass, Class<? extends Annotation> beforeClass, Class<? extends Annotation> afterClass) {
        return new Dependencies(ChainedComponent.allOf(ChainedComponent.getSymbols(this, providesClass), ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).getClass().getName()), ChainedComponent.getSymbols(this, beforeClass), ChainedComponent.getSymbols(this, afterClass));
    }

    private static List<String> allOf(List<String> symbols, String ... otherSymbols) {
        ArrayList<String> result = new ArrayList<String>(symbols);
        result.addAll(List.of(otherSymbols));
        return result;
    }

    private static List<String> getSymbols(ChainedComponent component, Class<? extends Annotation> annotationClass) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(ChainedComponent.annotationSymbols(component, annotationClass));
        return result;
    }

    private static Collection<String> annotationSymbols(ChainedComponent component, Class<? extends Annotation> annotationClass) {
        try {
            Annotation annotation = ((Object)((Object)component)).getClass().getAnnotation(annotationClass);
            if (annotation != null) {
                Object values = annotationClass.getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                return List.of((String[])values);
            }
            return List.of();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

