/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.CookieHelper;
import com.yahoo.jdisc.http.HttpResponse;
import com.yahoo.jdisc.http.filter.JDiscCookieWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class DiscFilterResponse {
    private final Response parent;
    private final HeaderFields untreatedHeaders;
    private final List<Cookie> untreatedCookies;

    public DiscFilterResponse(HttpResponse parent) {
        this((Response)parent);
    }

    DiscFilterResponse(Response parent) {
        this.parent = parent;
        this.untreatedHeaders = new HeaderFields();
        this.untreatedHeaders.addAll((Map)parent.headers());
        this.untreatedCookies = this.getCookies();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.parent.context().keySet());
    }

    public Object getAttribute(String name) {
        return this.parent.context().get(name);
    }

    public void setAttribute(String name, Object value) {
        this.parent.context().put(name, value);
    }

    public void removeAttribute(String name) {
        this.parent.context().remove(name);
    }

    public HeaderFields getUntreatedHeaders() {
        return this.untreatedHeaders;
    }

    public List<Cookie> getUntreatedCookies() {
        return this.untreatedCookies;
    }

    public void setHeader(String name, String value) {
        this.parent.headers().put(name, value);
    }

    public void removeHeaders(String name) {
        this.parent.headers().remove((Object)name);
    }

    public void setHeaders(String name, String value) {
        this.parent.headers().put(name, value);
    }

    public void setHeaders(String name, List<String> values) {
        this.parent.headers().put(name, values);
    }

    public void addHeader(String name, String value) {
        this.parent.headers().add(name, value);
    }

    public String getHeader(String name) {
        List values = this.parent.headers().get((Object)name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(values.size() - 1);
    }

    public List<Cookie> getCookies() {
        return CookieHelper.decodeSetCookieHeader(this.parent.headers());
    }

    public void setCookies(List<Cookie> cookies) {
        CookieHelper.encodeSetCookieHeader(this.parent.headers(), cookies);
    }

    public int getStatus() {
        return this.parent.getStatus();
    }

    public void setStatus(int status) {
        this.parent.setStatus(status);
    }

    public void addCookie(JDiscCookieWrapper cookie) {
        if (cookie != null) {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            List<Cookie> c = this.getCookies();
            if (c != null && !c.isEmpty()) {
                cookies.addAll(c);
            }
            cookies.add(cookie.getCookie());
            this.setCookies(cookies);
        }
    }

    public void sendError(int errorCode) throws IOException {
        this.setStatus(errorCode);
    }

    public void setCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.setCookies(Arrays.asList(cookie));
    }
}

