/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.yahoo.collections.Pair;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.di.componentgraph.core.Exceptions;
import com.yahoo.container.di.componentgraph.core.Keys;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ComponentNode
extends Node {
    private static final Logger log = Logger.getLogger(ComponentNode.class.getName());
    private final Class<?> clazz;
    private final Annotation key;
    private Object[] arguments = null;
    private final String configId;
    private final Constructor<?> constructor;
    private Map<ConfigKey<ConfigInstance>, ConfigInstance> availableConfigs = null;

    public ComponentNode(ComponentId componentId, String configId, Class<?> clazz, Annotation XXX_key) {
        super(componentId);
        if (ComponentNode.isAbstract(clazz)) {
            throw new IllegalArgumentException("Can't instantiate abstract class " + clazz.getName());
        }
        this.configId = configId;
        this.clazz = clazz;
        this.key = XXX_key;
        this.constructor = ComponentNode.bestConstructor(clazz);
    }

    public ComponentNode(ComponentId componentId, String configId, Class<?> clazz) {
        this(componentId, configId, clazz, null);
    }

    public String configId() {
        return this.configId;
    }

    @Override
    public Key<?> instanceKey() {
        return Keys.createKey(this.clazz, this.key);
    }

    @Override
    public Class<?> instanceType() {
        return this.clazz;
    }

    @Override
    public List<Node> usedComponents() {
        if (this.arguments == null) {
            throw new IllegalStateException("Arguments must be set first.");
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Object arg : this.arguments) {
            if (!(arg instanceof Node)) continue;
            ret.add((Node)arg);
        }
        return ret;
    }

    private static List<Class<?>> allSuperClasses(Class<?> clazz) {
        ArrayList ret = new ArrayList();
        while (clazz != null) {
            ret.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return ret;
    }

    @Override
    public Class<?> componentType() {
        if (Provider.class.isAssignableFrom(this.clazz)) {
            List allGenericInterfaces = ComponentNode.allSuperClasses(this.clazz).stream().flatMap(c -> Arrays.stream(c.getGenericInterfaces())).toList();
            for (Type t : allGenericInterfaces) {
                Type[] typeArgs;
                if (!(t instanceof ParameterizedType) || !((ParameterizedType)t).getRawType().equals(Provider.class) || (typeArgs = ((ParameterizedType)t).getActualTypeArguments()) == null || typeArgs.length <= 0) continue;
                return (Class)typeArgs[0];
            }
            throw new IllegalStateException("Component type cannot be resolved");
        }
        return this.clazz;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    protected Object newInstance() {
        Object instance;
        if (this.arguments == null) {
            throw new IllegalStateException("graph.complete must be called before retrieving instances.");
        }
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        for (Object ob : this.arguments) {
            if (ob instanceof Node) {
                actualArguments.add(((Node)ob).component());
                continue;
            }
            if (ob instanceof ConfigKey) {
                actualArguments.add(this.getConfigInstance((ConfigKey)ob));
                continue;
            }
            actualArguments.add(ob);
        }
        try {
            log.log(Level.FINE, () -> "Constructing " + this.idAndType());
            Instant start = Instant.now();
            instance = this.constructor.newInstance(actualArguments.toArray());
            Duration duration = Duration.between(start, Instant.now());
            log.log(duration.compareTo(Duration.ofMinutes(1L)) > 0 ? Level.INFO : Level.FINE, () -> "Finished constructing " + this.idAndType() + " in " + duration);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            StackTraceElement dependencyInjectorMarker = new StackTraceElement("============= Dependency Injection =============", "newInstance", null, -1);
            throw Exceptions.removeStackTrace(new ComponentConstructorException("Error constructing " + this.idAndType() + ": " + e.getMessage(), Exceptions.cutStackTraceAtConstructor(e.getCause(), dependencyInjectorMarker)));
        }
        return this.initId(instance);
    }

    private Object initId(Object component) {
        if (component instanceof AbstractComponent) {
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (abstractComponent.hasInitializedId() && !abstractComponent.getId().equals((Object)this.componentId())) {
                throw new IllegalStateException("Component with id '" + this.componentId() + "' is trying to set its component id explicitly: '" + abstractComponent.getId() + "'. This is not allowed, so please remove any call to super() in your component's constructor.");
            }
            abstractComponent.initId(this.componentId());
        }
        return component;
    }

    @Override
    public String toString() {
        return "ComponentNode{" + super.toString() + ", clazz=" + this.clazz + ", key=" + this.key + ", configId='" + this.configId + "'}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.availableConfigs == null ? 0 : this.availableConfigs.hashCode());
        result = 31 * result + (this.configId == null ? 0 : this.configId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComponentNode) {
            ComponentNode that = (ComponentNode)other;
            return super.equals(that) && ComponentNode.equalEdges(Arrays.asList(this.arguments), Arrays.asList(that.arguments)) && this.usedConfigs().equals(that.usedConfigs());
        }
        return false;
    }

    private List<ConfigInstance> usedConfigs() {
        if (this.availableConfigs == null) {
            throw new IllegalStateException("setAvailableConfigs must be called!");
        }
        ArrayList<ConfigInstance> ret = new ArrayList<ConfigInstance>();
        for (Object arg : this.arguments) {
            if (!(arg instanceof ConfigKey)) continue;
            ret.add(this.getConfigInstance((ConfigKey)arg));
        }
        return ret;
    }

    protected List<Pair<Type, List<Annotation>>> getAnnotatedConstructorParams() {
        Type[] types = this.constructor.getGenericParameterTypes();
        Annotation[][] annotations = this.constructor.getParameterAnnotations();
        ArrayList<Pair<Type, List<Annotation>>> ret = new ArrayList<Pair<Type, List<Annotation>>>();
        for (int i = 0; i < types.length; ++i) {
            ret.add((Pair<Type, List<Annotation>>)new Pair((Object)types[i], Arrays.asList(annotations[i])));
        }
        return ret;
    }

    public void setAvailableConfigs(Map<ConfigKey<ConfigInstance>, ConfigInstance> configs) {
        if (this.arguments == null) {
            throw new IllegalStateException("graph.complete must be called before graph.setAvailableConfigs.");
        }
        this.availableConfigs = configs;
    }

    private ConfigInstance getConfigInstance(ConfigKey<?> key) {
        if (!this.availableConfigs.containsKey(key)) {
            throw new IllegalArgumentException("Config not found in the map of available configs: " + key);
        }
        if (this.availableConfigs.get(key) == null) {
            throw new IllegalStateException("The map of available configs has a null config for: " + key);
        }
        return this.availableConfigs.get(key);
    }

    @Override
    public Set<ConfigKey<ConfigInstance>> configKeys() {
        return this.configParameterClasses().stream().map(par -> new ConfigKey(par, this.configId)).collect(Collectors.toSet());
    }

    private List<Class<ConfigInstance>> configParameterClasses() {
        ArrayList<Class<ConfigInstance>> ret = new ArrayList<Class<ConfigInstance>>();
        for (Type type : this.constructor.getGenericParameterTypes()) {
            if (!(type instanceof Class) || !ConfigInstance.class.isAssignableFrom((Class)type)) continue;
            ret.add((Class)type);
        }
        return ret;
    }

    @Override
    public String label() {
        LinkedList configNames = this.configKeys().stream().map(k -> k.getName() + ".def").collect(Collectors.toCollection(LinkedList::new));
        configNames.addFirst(this.instanceType().getSimpleName());
        configNames.addFirst(Node.packageName(this.instanceType()));
        return "{" + String.join((CharSequence)"|", configNames) + "}";
    }

    private static Constructor<?> bestConstructor(Class<?> clazz) {
        Constructor<?>[] publicConstructors = clazz.getConstructors();
        Constructor<?> annotated = null;
        for (Constructor<?> ctor : publicConstructors) {
            Inject annotation = ctor.getAnnotation(Inject.class);
            if (annotation == null) {
                annotation = ctor.getAnnotation(com.yahoo.component.annotation.Inject.class);
            }
            if (annotation == null) continue;
            if (annotated == null) {
                annotated = ctor;
                continue;
            }
            throw ComponentNode.componentConstructorException("Multiple constructor annotated with @Inject in class " + clazz.getName());
        }
        if (annotated != null) {
            return annotated;
        }
        if (publicConstructors.length == 0) {
            throw ComponentNode.componentConstructorException("No public constructors in class " + clazz.getName());
        }
        if (publicConstructors.length == 1) {
            return publicConstructors[0];
        }
        log.warning(String.format("Multiple public constructors found in class %s, there should only be one. If more than one public constructor is needed, the primary one must be annotated with @Inject.", clazz.getName()));
        ArrayList<Pair> withParameterCount = new ArrayList<Pair>();
        for (Constructor<?> ctor : publicConstructors) {
            long count = Arrays.stream(ctor.getParameterTypes()).filter(ConfigInstance.class::isAssignableFrom).count();
            withParameterCount.add(new Pair(ctor, (Object)((int)count)));
        }
        withParameterCount.sort(Comparator.comparingInt(Pair::getSecond));
        return (Constructor)((Pair)withParameterCount.get(withParameterCount.size() - 1)).getFirst();
    }

    private static ComponentConstructorException componentConstructorException(String message) {
        return Exceptions.removeStackTrace(new ComponentConstructorException(message));
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static class ComponentConstructorException
    extends RuntimeException {
        ComponentConstructorException(String message) {
            super(message);
        }

        ComponentConstructorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

