/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import ai.vespa.http.HttpURL;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.AclMapping;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.RequestHandlerSpec;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.JacksonJsonMapper;
import com.yahoo.restapi.Path;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.RestApiMappers;
import com.yahoo.security.tls.Capability;
import com.yahoo.security.tls.CapabilitySet;
import com.yahoo.security.tls.ConnectionAuthContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

class RestApiImpl
implements RestApi {
    private static final Logger log = Logger.getLogger(RestApiImpl.class.getName());
    private final Route defaultRoute;
    private final List<Route> routes;
    private final List<RestApiMappers.ExceptionMapperHolder<?>> exceptionMappers;
    private final List<RestApiMappers.ResponseMapperHolder<?>> responseMappers;
    private final List<RestApiMappers.RequestMapperHolder<?>> requestMappers;
    private final List<RestApi.Filter> filters;
    private final ObjectMapper jacksonJsonMapper;
    private final boolean disableDefaultAclMapping;
    private final CapabilitySet requiredCapabilities;
    private static final CapabilitySet DEFAULT_REQUIRED_CAPABILITIES = Capability.RESTAPI_UNCLASSIFIED.toCapabilitySet();

    private RestApiImpl(RestApi.Builder builder) {
        BuilderImpl builderImpl = (BuilderImpl)builder;
        ObjectMapper jacksonJsonMapper = builderImpl.jacksonJsonMapper != null ? builderImpl.jacksonJsonMapper : JacksonJsonMapper.instance.copy();
        this.defaultRoute = builderImpl.defaultRoute != null ? builderImpl.defaultRoute : RestApiImpl.createDefaultRoute();
        this.routes = List.copyOf(builderImpl.routes);
        this.exceptionMappers = RestApiImpl.combineWithDefaultExceptionMappers(builderImpl.exceptionMappers, Boolean.TRUE.equals(builderImpl.disableDefaultExceptionMappers));
        this.responseMappers = RestApiImpl.combineWithDefaultResponseMappers(builderImpl.responseMappers, Boolean.TRUE.equals(builderImpl.disableDefaultResponseMappers));
        this.requestMappers = RestApiImpl.combineWithDefaultRequestMappers(builderImpl.requestMappers);
        this.filters = List.copyOf(builderImpl.filters);
        this.jacksonJsonMapper = jacksonJsonMapper;
        this.disableDefaultAclMapping = Boolean.TRUE.equals(builderImpl.disableDefaultAclMapping);
        this.requiredCapabilities = builderImpl.requiredCapabilities;
    }

    @Override
    public HttpResponse handleRequest(HttpRequest request) {
        AclMapping.Action aclAction;
        RequestContextImpl requestContext;
        Path pathMatcher = new Path(request.getUri());
        Route resolvedRoute = this.resolveRoute(pathMatcher);
        FilterContextImpl filterContext = this.createFilterContextRecursive(resolvedRoute, requestContext = new RequestContextImpl(request, pathMatcher, aclAction = this.getAclMapping(request.getMethod(), request.getUri()), this.jacksonJsonMapper), this.filters, this.createFilterContextRecursive(resolvedRoute, requestContext, resolvedRoute.filters, null));
        if (filterContext != null) {
            try {
                return filterContext.executeFirst();
            }
            catch (RuntimeException e) {
                return this.mapException(requestContext, e);
            }
        }
        return this.dispatchToRoute(resolvedRoute, requestContext);
    }

    @Override
    public ObjectMapper jacksonJsonMapper() {
        return this.jacksonJsonMapper;
    }

    @Override
    public RequestHandlerSpec requestHandlerSpec() {
        return RequestHandlerSpec.builder().withAclMapping(requestView -> this.getAclMapping(requestView.method(), requestView.uri())).build();
    }

    @Override
    public CapabilitySet requiredCapabilities(RequestView req) {
        Path pathMatcher = new Path(req.uri());
        Route route = this.resolveRoute(pathMatcher);
        HandlerHolder<?> handler = this.resolveHandler(req.method(), route);
        return Optional.ofNullable(handler.config.requiredCapabilities).or(() -> Optional.ofNullable(route.requiredCapabilities)).or(() -> Optional.ofNullable(this.requiredCapabilities)).orElse(DEFAULT_REQUIRED_CAPABILITIES);
    }

    private AclMapping.Action getAclMapping(final HttpRequest.Method method, final URI uri) {
        Path pathMatcher = new Path(uri);
        Route route = this.resolveRoute(pathMatcher);
        HandlerHolder<?> handler = this.resolveHandler(method, route);
        AclMapping.Action aclAction = handler.config.aclAction;
        if (aclAction != null) {
            return aclAction;
        }
        if (!this.disableDefaultAclMapping) {
            return RequestHandlerSpec.DEFAULT_INSTANCE.aclMapping().get(new RequestView(){

                @Override
                public HttpRequest.Method method() {
                    return method;
                }

                @Override
                public URI uri() {
                    return uri;
                }
            });
        }
        throw new IllegalStateException(String.format("No ACL mapping configured for '%s' to '%s'", new Object[]{method, route.name}));
    }

    private HttpResponse dispatchToRoute(Route route, RequestContextImpl context) {
        Object responseEntity;
        Object requestEntity;
        HandlerHolder<?> resolvedHandler = this.resolveHandler(context.request.getMethod(), route);
        RestApiMappers.RequestMapperHolder<?> resolvedRequestMapper = this.resolveRequestMapper(resolvedHandler);
        try {
            requestEntity = resolvedRequestMapper.mapper.toRequestEntity(context).orElse(null);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
        try {
            responseEntity = resolvedHandler.executeHandler(context, requestEntity);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
        if (responseEntity == null) {
            throw new NullPointerException("Handler must return non-null value");
        }
        RestApiMappers.ResponseMapperHolder<?> resolvedResponseMapper = this.resolveResponseMapper(responseEntity);
        try {
            return resolvedResponseMapper.toHttpResponse(context, responseEntity);
        }
        catch (RuntimeException e) {
            return this.mapException(context, e);
        }
    }

    private HandlerHolder<?> resolveHandler(HttpRequest.Method method, Route route) {
        HandlerHolder<?> resolvedHandler = route.handlerPerMethod.get((Object)method);
        return resolvedHandler == null ? route.defaultHandler : resolvedHandler;
    }

    private RestApiMappers.RequestMapperHolder<?> resolveRequestMapper(HandlerHolder<?> resolvedHandler) {
        return this.requestMappers.stream().filter(holder -> resolvedHandler.type.isAssignableFrom(holder.type)).findFirst().orElseThrow(() -> new IllegalStateException("No mapper configured for " + resolvedHandler.type));
    }

    private RestApiMappers.ResponseMapperHolder<?> resolveResponseMapper(Object responseEntity) {
        return this.responseMappers.stream().filter(holder -> holder.type.isAssignableFrom(responseEntity.getClass())).findFirst().orElseThrow(() -> new IllegalStateException("No mapper configured for " + responseEntity.getClass()));
    }

    private HttpResponse mapException(RequestContextImpl context, RuntimeException e) {
        log.log(Level.FINE, e, e::getMessage);
        RestApiMappers.ExceptionMapperHolder mapper = this.exceptionMappers.stream().filter(holder -> holder.type.isAssignableFrom(e.getClass())).min((a, b) -> (a.type.isAssignableFrom(b.type) ? 1 : 0) + (b.type.isAssignableFrom(a.type) ? -1 : 0)).orElseThrow(() -> e);
        return mapper.toResponse(context, e);
    }

    private Route resolveRoute(Path pathMatcher) {
        Route matchingRoute = this.routes.stream().filter(route -> pathMatcher.matches(route.pathPattern)).findFirst().orElse(null);
        if (matchingRoute != null) {
            return matchingRoute;
        }
        pathMatcher.matches(this.defaultRoute.pathPattern);
        return this.defaultRoute;
    }

    private FilterContextImpl createFilterContextRecursive(Route route, RequestContextImpl requestContext, List<RestApi.Filter> filters, FilterContextImpl previousContext) {
        FilterContextImpl filterContext = previousContext;
        ListIterator<RestApi.Filter> iterator = filters.listIterator(filters.size());
        while (iterator.hasPrevious()) {
            filterContext = new FilterContextImpl(route, iterator.previous(), requestContext, filterContext);
        }
        return filterContext;
    }

    private static Route createDefaultRoute() {
        RestApi.RouteBuilder routeBuilder = new RouteBuilderImpl("{*}").defaultHandler(context -> {
            throw new RestApiException.NotFound(context.request());
        });
        return ((RouteBuilderImpl)routeBuilder).build();
    }

    private static List<RestApiMappers.ExceptionMapperHolder<?>> combineWithDefaultExceptionMappers(List<RestApiMappers.ExceptionMapperHolder<?>> configuredExceptionMappers, boolean disableDefaultMappers) {
        ArrayList exceptionMappers = new ArrayList(configuredExceptionMappers);
        if (!disableDefaultMappers) {
            exceptionMappers.addAll(RestApiMappers.DEFAULT_EXCEPTION_MAPPERS);
        }
        return exceptionMappers;
    }

    private static List<RestApiMappers.ResponseMapperHolder<?>> combineWithDefaultResponseMappers(List<RestApiMappers.ResponseMapperHolder<?>> configuredResponseMappers, boolean disableDefaultMappers) {
        ArrayList responseMappers = new ArrayList(configuredResponseMappers);
        if (!disableDefaultMappers) {
            responseMappers.addAll(RestApiMappers.DEFAULT_RESPONSE_MAPPERS);
        }
        return responseMappers;
    }

    private static List<RestApiMappers.RequestMapperHolder<?>> combineWithDefaultRequestMappers(List<RestApiMappers.RequestMapperHolder<?>> configuredRequestMappers) {
        ArrayList requestMappers = new ArrayList(configuredRequestMappers);
        requestMappers.addAll(RestApiMappers.DEFAULT_REQUEST_MAPPERS);
        return requestMappers;
    }

    static class BuilderImpl
    implements RestApi.Builder {
        private final List<Route> routes = new ArrayList<Route>();
        private final List<RestApiMappers.ExceptionMapperHolder<?>> exceptionMappers = new ArrayList();
        private final List<RestApiMappers.ResponseMapperHolder<?>> responseMappers = new ArrayList();
        private final List<RestApiMappers.RequestMapperHolder<?>> requestMappers = new ArrayList();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private Route defaultRoute;
        private ObjectMapper jacksonJsonMapper;
        private Boolean disableDefaultExceptionMappers;
        private Boolean disableDefaultResponseMappers;
        private Boolean disableDefaultAclMapping;
        private CapabilitySet requiredCapabilities;

        BuilderImpl() {
        }

        @Override
        public RestApi.Builder setObjectMapper(ObjectMapper mapper) {
            this.jacksonJsonMapper = mapper;
            return this;
        }

        @Override
        public RestApi.Builder setDefaultRoute(RestApi.RouteBuilder route) {
            this.defaultRoute = ((RouteBuilderImpl)route).build();
            return this;
        }

        @Override
        public RestApi.Builder addRoute(RestApi.RouteBuilder route) {
            this.routes.add(((RouteBuilderImpl)route).build());
            return this;
        }

        @Override
        public RestApi.Builder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public <EXCEPTION extends RuntimeException> RestApi.Builder addExceptionMapper(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.exceptionMappers.add(new RestApiMappers.ExceptionMapperHolder<EXCEPTION>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder addResponseMapper(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.responseMappers.add(new RestApiMappers.ResponseMapperHolder<ENTITY>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder addRequestMapper(Class<ENTITY> type, RestApi.RequestMapper<ENTITY> mapper) {
            this.requestMappers.add(new RestApiMappers.RequestMapperHolder<ENTITY>(type, mapper));
            return this;
        }

        public <ENTITY> RestApi.Builder registerJacksonResponseEntity(Class<ENTITY> type) {
            this.addResponseMapper(type, new RestApiMappers.JacksonResponseMapper());
            return this;
        }

        public <ENTITY> RestApi.Builder registerJacksonRequestEntity(Class<ENTITY> type) {
            this.addRequestMapper(type, new RestApiMappers.JacksonRequestMapper<ENTITY>(type));
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultExceptionMappers() {
            this.disableDefaultExceptionMappers = true;
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultResponseMappers() {
            this.disableDefaultResponseMappers = true;
            return this;
        }

        @Override
        public RestApi.Builder disableDefaultAclMapping() {
            this.disableDefaultAclMapping = true;
            return this;
        }

        @Override
        public RestApi.Builder requiredCapabilities(Capability ... capabilities) {
            return this.requiredCapabilities(CapabilitySet.of((Capability[])capabilities));
        }

        @Override
        public RestApi.Builder requiredCapabilities(CapabilitySet capabilities) {
            if (this.requiredCapabilities != null) {
                throw new IllegalStateException("Capabilities already set");
            }
            this.requiredCapabilities = capabilities;
            return this;
        }

        @Override
        public RestApi build() {
            return new RestApiImpl(this);
        }
    }

    static class Route {
        private final String pathPattern;
        private final String name;
        private final Map<HttpRequest.Method, HandlerHolder<?>> handlerPerMethod;
        private final HandlerHolder<?> defaultHandler;
        private final List<RestApi.Filter> filters;
        private final CapabilitySet requiredCapabilities;

        private Route(RestApi.RouteBuilder builder) {
            RouteBuilderImpl builderImpl = (RouteBuilderImpl)builder;
            this.pathPattern = builderImpl.pathPattern;
            this.name = builderImpl.name;
            this.handlerPerMethod = Map.copyOf(builderImpl.handlerPerMethod);
            this.defaultHandler = builderImpl.defaultHandler != null ? builderImpl.defaultHandler : this.createDefaultMethodHandler();
            this.filters = List.copyOf(builderImpl.filters);
            this.requiredCapabilities = builderImpl.requiredCapabilities;
        }

        private HandlerHolder<?> createDefaultMethodHandler() {
            return HandlerHolder.of(context -> {
                throw new RestApiException.MethodNotAllowed(context.request());
            }, HandlerConfig.empty());
        }
    }

    private static class RequestContextImpl
    implements RestApi.RequestContext {
        final HttpRequest request;
        final Path pathMatcher;
        final ObjectMapper jacksonJsonMapper;
        final RestApi.RequestContext.PathParameters pathParameters = new PathParametersImpl();
        final RestApi.RequestContext.QueryParameters queryParameters = new QueryParametersImpl();
        final RestApi.RequestContext.Headers headers = new HeadersImpl();
        final RestApi.RequestContext.Attributes attributes = new AttributesImpl();
        final RestApi.RequestContext.RequestContent requestContent;
        final AclMapping.Action aclAction;

        RequestContextImpl(HttpRequest request, Path pathMatcher, AclMapping.Action aclAction, ObjectMapper jacksonJsonMapper) {
            this.request = request;
            this.pathMatcher = pathMatcher;
            this.jacksonJsonMapper = jacksonJsonMapper;
            this.requestContent = request.getData() != null ? new RequestContentImpl() : null;
            this.aclAction = aclAction;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public HttpRequest.Method method() {
            return this.request.getMethod();
        }

        @Override
        public RestApi.RequestContext.PathParameters pathParameters() {
            return this.pathParameters;
        }

        @Override
        public RestApi.RequestContext.QueryParameters queryParameters() {
            return this.queryParameters;
        }

        @Override
        public RestApi.RequestContext.Headers headers() {
            return this.headers;
        }

        @Override
        public RestApi.RequestContext.Attributes attributes() {
            return this.attributes;
        }

        @Override
        public Optional<RestApi.RequestContext.RequestContent> requestContent() {
            return Optional.ofNullable(this.requestContent);
        }

        @Override
        public RestApi.RequestContext.RequestContent requestContentOrThrow() {
            return this.requestContent().orElseThrow(() -> new RestApiException.BadRequest("Request content missing"));
        }

        @Override
        public ObjectMapper jacksonJsonMapper() {
            return this.jacksonJsonMapper;
        }

        @Override
        public HttpURL baseRequestURL() {
            URI uri = this.request.getUri();
            StringBuilder sb = new StringBuilder(uri.getScheme()).append("://");
            String hostHeader = this.request.getHeader("X-Forwarded-Host");
            if (hostHeader == null || hostHeader.isBlank()) {
                hostHeader = this.request.getHeader("Host");
            }
            if (hostHeader != null && !hostHeader.isBlank()) {
                sb.append(hostHeader);
            } else {
                sb.append(uri.getHost());
                if (uri.getPort() > 0) {
                    sb.append(":").append(uri.getPort());
                }
            }
            return HttpURL.from((URI)URI.create(sb.toString()));
        }

        @Override
        public AclMapping.Action aclAction() {
            return this.aclAction;
        }

        @Override
        public Optional<Principal> userPrincipal() {
            return Optional.ofNullable(this.request.getJDiscRequest().getUserPrincipal());
        }

        @Override
        public Principal userPrincipalOrThrow() {
            return this.userPrincipal().orElseThrow(RestApiException.Unauthorized::new);
        }

        @Override
        public Optional<SSLSession> sslSession() {
            return Optional.ofNullable((SSLSession)this.request.context().get("jdisc.request.SSLSession"));
        }

        @Override
        public Optional<ConnectionAuthContext> connectionAuthContext() {
            return this.sslSession().flatMap(TransportSecurityUtils::getConnectionAuthContext);
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return (InetSocketAddress)this.request.getJDiscRequest().getRemoteAddress();
        }

        private class PathParametersImpl
        implements RestApi.RequestContext.PathParameters {
            private PathParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.pathMatcher.get(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.NotFound("Path parameter '" + name + "' is missing"));
            }

            @Override
            public HttpURL.Path getFullPath() {
                return RequestContextImpl.this.pathMatcher.getPath();
            }

            @Override
            public Optional<HttpURL.Path> getRest() {
                return Optional.ofNullable(RequestContextImpl.this.pathMatcher.getRest());
            }
        }

        private class QueryParametersImpl
        implements RestApi.RequestContext.QueryParameters {
            private QueryParametersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getProperty(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Query parameter '" + name + "' is missing"));
            }

            @Override
            public List<String> getStringList(String name) {
                List<String> result = RequestContextImpl.this.request.getJDiscRequest().parameters().get(name);
                if (result == null) {
                    return List.of();
                }
                return List.copyOf(result);
            }

            @Override
            public HttpURL.Query getFullQuery() {
                return HttpURL.Query.empty().add(RequestContextImpl.this.request.getJDiscRequest().parameters());
            }
        }

        private class HeadersImpl
        implements RestApi.RequestContext.Headers {
            private HeadersImpl() {
            }

            @Override
            public Optional<String> getString(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getHeader(name));
            }

            @Override
            public String getStringOrThrow(String name) {
                return this.getString(name).orElseThrow(() -> new RestApiException.BadRequest("Header '" + name + "' missing"));
            }
        }

        private class AttributesImpl
        implements RestApi.RequestContext.Attributes {
            private AttributesImpl() {
            }

            @Override
            public Optional<Object> get(String name) {
                return Optional.ofNullable(RequestContextImpl.this.request.getJDiscRequest().context().get(name));
            }

            @Override
            public void set(String name, Object value) {
                RequestContextImpl.this.request.getJDiscRequest().context().put(name, value);
            }
        }

        private class RequestContentImpl
        implements RestApi.RequestContext.RequestContent {
            private RequestContentImpl() {
            }

            @Override
            public String contentType() {
                return RequestContextImpl.this.request.getHeader("Content-Type");
            }

            @Override
            public InputStream content() {
                return RequestContextImpl.this.request.getData();
            }
        }
    }

    private class FilterContextImpl
    implements RestApi.FilterContext {
        final Route route;
        final RestApi.Filter filter;
        final RequestContextImpl requestContext;
        final FilterContextImpl next;

        FilterContextImpl(Route route, RestApi.Filter filter, RequestContextImpl requestContext, FilterContextImpl next) {
            this.route = route;
            this.filter = filter;
            this.requestContext = requestContext;
            this.next = next;
        }

        @Override
        public RestApi.RequestContext requestContext() {
            return this.requestContext;
        }

        @Override
        public String route() {
            return this.route.name != null ? this.route.name : this.route.pathPattern;
        }

        @Override
        public void setPrincipal(Principal p) {
            this.requestContext.request.getJDiscRequest().setUserPrincipal(p);
        }

        HttpResponse executeFirst() {
            return this.filter.filterRequest(this);
        }

        @Override
        public HttpResponse executeNext() {
            if (this.next != null) {
                return this.next.filter.filterRequest(this.next);
            }
            return RestApiImpl.this.dispatchToRoute(this.route, this.requestContext);
        }
    }

    private static class HandlerHolder<REQUEST_ENTITY> {
        final Class<REQUEST_ENTITY> type;
        final RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler;
        final HandlerConfig config;

        private HandlerHolder(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler, HandlerConfig config) {
            this.type = type;
            this.handler = handler;
            this.config = config;
        }

        static <RESPONSE_ENTITY, REQUEST_ENTITY> HandlerHolder<REQUEST_ENTITY> of(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, RESPONSE_ENTITY> handler, HandlerConfig config) {
            return new HandlerHolder<REQUEST_ENTITY>(type, handler, config);
        }

        static <RESPONSE_ENTITY> HandlerHolder<Void> of(RestApi.Handler<RESPONSE_ENTITY> handler, HandlerConfig config) {
            return new HandlerHolder<Void>(Void.class, (context, nullEntity) -> handler.handleRequest(context), config);
        }

        Object executeHandler(RestApi.RequestContext context, Object entity) {
            return this.handler.handleRequest(context, this.type.cast(entity));
        }
    }

    private static class HandlerConfig {
        final AclMapping.Action aclAction;
        final CapabilitySet requiredCapabilities;

        HandlerConfig(HandlerConfigBuilderImpl builder) {
            this.aclAction = builder.aclAction;
            this.requiredCapabilities = builder.requiredCapabilities;
        }

        static HandlerConfig empty() {
            return new HandlerConfigBuilderImpl().build();
        }
    }

    static class RouteBuilderImpl
    implements RestApi.RouteBuilder {
        private final String pathPattern;
        private String name;
        private final Map<HttpRequest.Method, HandlerHolder<?>> handlerPerMethod = new HashMap();
        private final List<RestApi.Filter> filters = new ArrayList<RestApi.Filter>();
        private HandlerHolder<?> defaultHandler;
        private CapabilitySet requiredCapabilities;

        RouteBuilderImpl(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        @Override
        public RestApi.RouteBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public RestApi.RouteBuilder requiredCapabilities(Capability ... capabilities) {
            return this.requiredCapabilities(CapabilitySet.of((Capability[])capabilities));
        }

        @Override
        public RestApi.RouteBuilder requiredCapabilities(CapabilitySet capabilities) {
            if (this.requiredCapabilities != null) {
                throw new IllegalStateException("Capabilities already set");
            }
            this.requiredCapabilities = capabilities;
            return this;
        }

        @Override
        public RestApi.RouteBuilder addFilter(RestApi.Filter filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public RestApi.RouteBuilder get(RestApi.Handler<?> handler) {
            return this.get(handler, null);
        }

        @Override
        public RestApi.RouteBuilder get(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.GET, handler, config);
        }

        @Override
        public RestApi.RouteBuilder post(RestApi.Handler<?> handler) {
            return this.post(handler, null);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder post(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler) {
            return this.post(type, handler, null);
        }

        @Override
        public RestApi.RouteBuilder post(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.POST, handler, config);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder post(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.POST, type, handler, config);
        }

        @Override
        public RestApi.RouteBuilder put(RestApi.Handler<?> handler) {
            return this.put(handler, null);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder put(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler) {
            return this.put(type, handler, null);
        }

        @Override
        public RestApi.RouteBuilder put(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.PUT, handler, null);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder put(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.PUT, type, handler, config);
        }

        @Override
        public RestApi.RouteBuilder delete(RestApi.Handler<?> handler) {
            return this.delete(handler, null);
        }

        @Override
        public RestApi.RouteBuilder delete(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.DELETE, handler, config);
        }

        @Override
        public RestApi.RouteBuilder patch(RestApi.Handler<?> handler) {
            return this.patch(handler, null);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder patch(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler) {
            return this.patch(type, handler, null);
        }

        @Override
        public RestApi.RouteBuilder patch(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.PATCH, handler, config);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder patch(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler, RestApi.HandlerConfigBuilder config) {
            return this.addHandler(HttpRequest.Method.PATCH, type, handler, config);
        }

        @Override
        public RestApi.RouteBuilder defaultHandler(RestApi.Handler<?> handler) {
            return this.defaultHandler(handler, null);
        }

        @Override
        public RestApi.RouteBuilder defaultHandler(RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            this.defaultHandler = HandlerHolder.of(handler, RouteBuilderImpl.build(config));
            return this;
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder defaultHandler(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler) {
            return this.defaultHandler(type, handler, null);
        }

        @Override
        public <REQUEST_ENTITY> RestApi.RouteBuilder defaultHandler(Class<REQUEST_ENTITY> type, RestApi.HandlerWithRequestEntity<REQUEST_ENTITY, ?> handler, RestApi.HandlerConfigBuilder config) {
            this.defaultHandler = HandlerHolder.of(type, handler, RouteBuilderImpl.build(config));
            return this;
        }

        private RestApi.RouteBuilder addHandler(HttpRequest.Method method, RestApi.Handler<?> handler, RestApi.HandlerConfigBuilder config) {
            this.handlerPerMethod.put(method, HandlerHolder.of(handler, RouteBuilderImpl.build(config)));
            return this;
        }

        private <ENTITY> RestApi.RouteBuilder addHandler(HttpRequest.Method method, Class<ENTITY> type, RestApi.HandlerWithRequestEntity<ENTITY, ?> handler, RestApi.HandlerConfigBuilder config) {
            this.handlerPerMethod.put(method, HandlerHolder.of(type, handler, RouteBuilderImpl.build(config)));
            return this;
        }

        private static HandlerConfig build(RestApi.HandlerConfigBuilder builder) {
            if (builder == null) {
                return HandlerConfig.empty();
            }
            return ((HandlerConfigBuilderImpl)builder).build();
        }

        private Route build() {
            return new Route(this);
        }
    }

    static class HandlerConfigBuilderImpl
    implements RestApi.HandlerConfigBuilder {
        private AclMapping.Action aclAction;
        private CapabilitySet requiredCapabilities;

        HandlerConfigBuilderImpl() {
        }

        @Override
        public RestApi.HandlerConfigBuilder withRequiredCapabilities(Capability ... capabilities) {
            return this.withRequiredCapabilities(CapabilitySet.of((Capability[])capabilities));
        }

        @Override
        public RestApi.HandlerConfigBuilder withRequiredCapabilities(CapabilitySet capabilities) {
            if (this.requiredCapabilities != null) {
                throw new IllegalStateException("Capabilities already set");
            }
            this.requiredCapabilities = capabilities;
            return this;
        }

        @Override
        public RestApi.HandlerConfigBuilder withReadAclAction() {
            return this.withCustomAclAction(AclMapping.Action.READ);
        }

        @Override
        public RestApi.HandlerConfigBuilder withWriteAclAction() {
            return this.withCustomAclAction(AclMapping.Action.WRITE);
        }

        @Override
        public RestApi.HandlerConfigBuilder withCustomAclAction(AclMapping.Action action) {
            this.aclAction = action;
            return this;
        }

        HandlerConfig build() {
            return new HandlerConfig(this);
        }
    }
}

