/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.JacksonJsonResponse;
import com.yahoo.restapi.Json;
import com.yahoo.restapi.MessageResponse;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.JsonParseException;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestApiMappers {
    private static final Logger log = Logger.getLogger(RestApiMappers.class.getName());
    static List<RequestMapperHolder<?>> DEFAULT_REQUEST_MAPPERS = List.of(new RequestMapperHolder<Slime>(Slime.class, RestApiMappers::toSlime), new RequestMapperHolder<Json>(Json.class, ctx -> RestApiMappers.toSlime(ctx).map(Json::of)), new RequestMapperHolder<JsonNode>(JsonNode.class, ctx -> RestApiMappers.toJsonNode(ctx, ctx.jacksonJsonMapper())), new RequestMapperHolder<String>(String.class, RestApiMappers::toString), new RequestMapperHolder<byte[]>(byte[].class, RestApiMappers::toByteArray), new RequestMapperHolder<InputStream>(InputStream.class, RestApiMappers::toInputStream), new RequestMapperHolder<Void>(Void.class, ctx -> Optional.empty()));
    static List<ResponseMapperHolder<?>> DEFAULT_RESPONSE_MAPPERS = List.of(new ResponseMapperHolder<HttpResponse>(HttpResponse.class, (context, entity) -> entity), new ResponseMapperHolder<String>(String.class, (context, entity) -> new MessageResponse((String)entity)), new ResponseMapperHolder<Slime>(Slime.class, (context, entity) -> new SlimeJsonResponse((Slime)entity)), new ResponseMapperHolder<JsonNode>(JsonNode.class, (context, entity) -> new JacksonJsonResponse<JsonNode>(200, (JsonNode)entity, context.jacksonJsonMapper(), true)));
    static List<ExceptionMapperHolder<?>> DEFAULT_EXCEPTION_MAPPERS = List.of(new ExceptionMapperHolder<RestApiException>(RestApiException.class, (context, exception) -> exception.response()));

    private RestApiMappers() {
    }

    private static Optional<InputStream> toInputStream(RestApi.RequestContext context) {
        return context.requestContent().map(RestApi.RequestContext.RequestContent::content);
    }

    private static Optional<byte[]> toByteArray(RestApi.RequestContext context) {
        InputStream in = RestApiMappers.toInputStream(context).orElse(null);
        if (in == null) {
            return Optional.empty();
        }
        return RestApiMappers.convertIoException(() -> Optional.of(in.readAllBytes()));
    }

    private static Optional<String> toString(RestApi.RequestContext context) {
        try {
            return RestApiMappers.toByteArray(context).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
        }
        catch (RuntimeException e) {
            throw new RestApiException.BadRequest("Failed parse request content as UTF-8: " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private static Optional<JsonNode> toJsonNode(RestApi.RequestContext context, ObjectMapper jacksonJsonMapper) {
        if (log.isLoggable(Level.FINE)) {
            return RestApiMappers.toString(context).map(string -> {
                log.fine(() -> "Request content: " + string);
                return RestApiMappers.convertIoException("Failed to parse JSON", () -> jacksonJsonMapper.readTree(string));
            });
        }
        return RestApiMappers.toInputStream(context).map(in -> RestApiMappers.convertIoException("Invalid JSON", () -> jacksonJsonMapper.readTree(in)));
    }

    private static <T> T convertIoException(String messagePrefix, SupplierThrowingIoException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.getMessage(), e);
            throw new RestApiException.InternalServerError(messagePrefix + ": " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private static <T> T convertIoException(SupplierThrowingIoException<T> supplier) {
        return RestApiMappers.convertIoException("Failed to read request content", supplier);
    }

    private static Optional<Slime> toSlime(RestApi.RequestContext context) {
        try {
            return RestApiMappers.toString(context).map(string -> {
                log.fine(() -> "Request content: " + string);
                return SlimeUtils.jsonToSlimeOrThrow((String)string);
            });
        }
        catch (JsonParseException e) {
            log.log(Level.FINE, e.getMessage(), e);
            throw new RestApiException.BadRequest("Invalid JSON: " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    @FunctionalInterface
    private static interface SupplierThrowingIoException<T> {
        public T get() throws IOException;
    }

    static class RequestMapperHolder<ENTITY> {
        final Class<ENTITY> type;
        final RestApi.RequestMapper<ENTITY> mapper;

        RequestMapperHolder(Class<ENTITY> type, RestApi.RequestMapper<ENTITY> mapper) {
            this.type = type;
            this.mapper = mapper;
        }
    }

    static class ResponseMapperHolder<ENTITY> {
        final Class<ENTITY> type;
        final RestApi.ResponseMapper<ENTITY> mapper;

        ResponseMapperHolder(Class<ENTITY> type, RestApi.ResponseMapper<ENTITY> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        HttpResponse toHttpResponse(RestApi.RequestContext ctx, Object entity) {
            return this.mapper.toHttpResponse(ctx, this.type.cast(entity));
        }
    }

    static class ExceptionMapperHolder<EXCEPTION extends RuntimeException> {
        final Class<EXCEPTION> type;
        final RestApi.ExceptionMapper<EXCEPTION> mapper;

        ExceptionMapperHolder(Class<EXCEPTION> type, RestApi.ExceptionMapper<EXCEPTION> mapper) {
            this.type = type;
            this.mapper = mapper;
        }

        HttpResponse toResponse(RestApi.RequestContext ctx, RuntimeException e) {
            return this.mapper.toResponse(ctx, (RuntimeException)this.type.cast(e));
        }
    }

    public static class JacksonResponseMapper<ENTITY>
    implements RestApi.ResponseMapper<ENTITY> {
        @Override
        public HttpResponse toHttpResponse(RestApi.RequestContext context, ENTITY responseEntity) throws RestApiException {
            return new JacksonJsonResponse<ENTITY>(200, responseEntity, context.jacksonJsonMapper(), true);
        }
    }

    public static class JacksonRequestMapper<ENTITY>
    implements RestApi.RequestMapper<ENTITY> {
        private final Class<ENTITY> type;

        JacksonRequestMapper(Class<ENTITY> type) {
            this.type = type;
        }

        @Override
        public Optional<ENTITY> toRequestEntity(RestApi.RequestContext context) throws RestApiException {
            if (log.isLoggable(Level.FINE)) {
                return RestApiMappers.toString(context).map(string -> {
                    log.fine(() -> "Request content: " + string);
                    return RestApiMappers.convertIoException("Failed to parse JSON", () -> context.jacksonJsonMapper().readValue(string, this.type));
                });
            }
            return RestApiMappers.toInputStream(context).map(in -> RestApiMappers.convertIoException("Invalid JSON", () -> context.jacksonJsonMapper().readValue(in, this.type)));
        }
    }
}

