/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.common.base.Preconditions;
import com.yahoo.container.jdisc.HttpRequestHandler;
import com.yahoo.container.jdisc.RequestHandlerSpec;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.RequestDeniedException;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlers;
import com.yahoo.jdisc.http.server.jetty.FilterResolver;
import com.yahoo.jdisc.http.server.jetty.ReferenceCountingRequestHandler;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

class FilteringRequestHandler
extends AbstractRequestHandler {
    private static final ContentChannel COMPLETING_CONTENT_CHANNEL = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            CompletionHandlers.tryComplete(handler);
        }

        public void close(CompletionHandler handler) {
            CompletionHandlers.tryComplete(handler);
        }
    };
    private final FilterResolver filterResolver;
    private final org.eclipse.jetty.server.Request jettyRequest;

    public FilteringRequestHandler(FilterResolver filterResolver, org.eclipse.jetty.server.Request jettyRequest) {
        this.filterResolver = filterResolver;
        this.jettyRequest = jettyRequest;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler originalResponseHandler) {
        ContentChannel contentChannel;
        Preconditions.checkArgument((boolean)(request instanceof HttpRequest), (Object)("Expected HttpRequest, got " + request));
        Objects.requireNonNull(originalResponseHandler, "responseHandler");
        RequestFilter requestFilter = this.filterResolver.resolveRequestFilter(this.jettyRequest, request.getUri()).orElse(null);
        ResponseFilter responseFilter = this.filterResolver.resolveResponseFilter(this.jettyRequest, request.getUri()).orElse(null);
        RequestHandler resolvedRequestHandler = request.container().resolveHandler(request);
        if (resolvedRequestHandler == null) {
            throw new BindingNotFoundException(request.getUri());
        }
        this.getRequestHandlerSpec(resolvedRequestHandler).ifPresent(requestHandlerSpec -> request.context().put(RequestHandlerSpec.ATTRIBUTE_NAME, requestHandlerSpec));
        ReferenceCountingRequestHandler requestHandler = new ReferenceCountingRequestHandler(resolvedRequestHandler);
        ResponseHandler responseHandler = responseFilter != null ? new FilteringResponseHandler(originalResponseHandler, responseFilter, request) : originalResponseHandler;
        if (requestFilter != null) {
            InterceptingResponseHandler interceptingResponseHandler = new InterceptingResponseHandler(responseHandler);
            requestFilter.filter((HttpRequest)((Object)HttpRequest.class.cast(request)), interceptingResponseHandler);
            if (interceptingResponseHandler.hasProducedResponse()) {
                return COMPLETING_CONTENT_CHANNEL;
            }
        }
        if ((contentChannel = requestHandler.handleRequest(request, responseHandler)) == null) {
            throw new RequestDeniedException(request);
        }
        return contentChannel;
    }

    private Optional<RequestHandlerSpec> getRequestHandlerSpec(RequestHandler resolvedRequestHandler) {
        RequestHandler delegate = resolvedRequestHandler;
        if (delegate instanceof DelegatedRequestHandler) {
            delegate = ((DelegatedRequestHandler)delegate).getDelegateRecursive();
        }
        if (delegate instanceof HttpRequestHandler) {
            return Optional.ofNullable(((HttpRequestHandler)delegate).requestHandlerSpec());
        }
        return Optional.empty();
    }

    private static class FilteringResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final ResponseFilter responseFilter;
        private final Request request;

        public FilteringResponseHandler(ResponseHandler delegate, ResponseFilter responseFilter, Request request) {
            this.delegate = Objects.requireNonNull(delegate);
            this.responseFilter = Objects.requireNonNull(responseFilter);
            this.request = request;
        }

        public ContentChannel handleResponse(Response response) {
            this.responseFilter.filter(response, this.request);
            return this.delegate.handleResponse(response);
        }
    }

    private static class InterceptingResponseHandler
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private AtomicBoolean hasResponded = new AtomicBoolean(false);

        public InterceptingResponseHandler(ResponseHandler delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public ContentChannel handleResponse(Response response) {
            ContentChannel content = this.delegate.handleResponse(response);
            this.hasResponded.set(true);
            return content;
        }

        public boolean hasProducedResponse() {
            return this.hasResponded.get();
        }
    }
}

