/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;

class ConnectorSpecificContextHandler
extends ContextHandler {
    private final JDiscServerConnector connector;

    ConnectorSpecificContextHandler(JDiscServerConnector c) {
        this.connector = c;
        List<String> allowedServerNames = c.connectorConfig().serverName().allowed();
        if (allowedServerNames.isEmpty()) {
            this.setVirtualHosts(new String[]{"@%s".formatted(c.getName())});
        } else {
            String[] virtualHosts = (String[])allowedServerNames.stream().map(name -> "%s@%s".formatted(name, c.getName())).toArray(String[]::new);
            this.setVirtualHosts(virtualHosts);
        }
    }

    public boolean checkVirtualHost(Request req) {
        if (req.getRequestURI().equals("/status.html") && req.getHttpChannel().getConnector() == this.connector) {
            return true;
        }
        return super.checkVirtualHost(req);
    }
}

