/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ConnectorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "11b6bd8958cee055c0d4e0a4986b7d3c";
    public static final String CONFIG_DEF_NAME = "connector";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http", "listenPort int default=0", "name string default=\"default\"", "headerCacheSize int default=512", "outputBufferSize int default=65536", "requestHeaderSize int default=65536", "responseHeaderSize int default=65536", "acceptQueueSize int default=0", "maxContentSize long default=-1", "reuseAddress bool default=true", "idleTimeout double default=180.0", "tcpKeepAliveEnabled bool default=false", "tcpNoDelay bool default=true", "throttling.enabled bool default=false", "throttling.maxConnections int default=-1", "throttling.maxHeapUtilization double default=-1.0", "throttling.maxAcceptRate int default=-1", "throttling.idleTimeout double default=-1.0", "implicitTlsEnabled bool default=true", "ssl.enabled bool default=false", "ssl.privateKeyFile string default=\"\"", "ssl.privateKey string default=\"\"", "ssl.certificateFile string default=\"\"", "ssl.certificate string default=\"\"", "ssl.caCertificateFile string default=\"\"", "ssl.caCertificate string default=\"\"", "ssl.clientAuth enum { DISABLED, WANT_AUTH, NEED_AUTH } default=DISABLED", "ssl.enabledCipherSuites[] string", "ssl.enabledProtocols[] string", "tlsClientAuthEnforcer.enable bool default=false", "tlsClientAuthEnforcer.pathWhitelist[] string", "healthCheckProxy.enable bool default=false", "healthCheckProxy.port int default=8080", "healthCheckProxy.clientTimeout double default=1.0", "healthCheckProxy.handlerTimeout double default=1.5", "healthCheckProxy.cacheExpiry double default=1.0", "proxyProtocol.enabled bool default=false", "proxyProtocol.mixedMode bool default=false", "maxRequestsPerConnection int default=0", "maxConnectionLife double default=0.0", "http2Enabled bool default=true", "http2.streamIdleTimeout double default=600", "http2.maxConcurrentStreams int default=512", "serverName.fallback string default=\"\"", "serverName.allowed[] string", "serverName.known[] string", "accessLog.remoteAddressHeaders[] string", "accessLog.remotePortHeaders[] string"};
    private final IntegerNode listenPort;
    private final StringNode name;
    private final IntegerNode headerCacheSize;
    private final IntegerNode outputBufferSize;
    private final IntegerNode requestHeaderSize;
    private final IntegerNode responseHeaderSize;
    private final IntegerNode acceptQueueSize;
    private final LongNode maxContentSize;
    private final BooleanNode reuseAddress;
    private final DoubleNode idleTimeout;
    private final BooleanNode tcpKeepAliveEnabled;
    private final BooleanNode tcpNoDelay;
    private final Throttling throttling;
    private final BooleanNode implicitTlsEnabled;
    private final Ssl ssl;
    private final TlsClientAuthEnforcer tlsClientAuthEnforcer;
    private final HealthCheckProxy healthCheckProxy;
    private final ProxyProtocol proxyProtocol;
    private final IntegerNode maxRequestsPerConnection;
    private final DoubleNode maxConnectionLife;
    private final BooleanNode http2Enabled;
    private final Http2 http2;
    private final ServerName serverName;
    private final AccessLog accessLog;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ConnectorConfig(Builder builder) {
        this(builder, true);
    }

    private ConnectorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for connector must be initialized: " + builder.__uninitialized);
        }
        this.listenPort = builder.listenPort == null ? new IntegerNode(0) : new IntegerNode(builder.listenPort.intValue());
        this.name = builder.name == null ? new StringNode("default") : new StringNode(builder.name);
        this.headerCacheSize = builder.headerCacheSize == null ? new IntegerNode(512) : new IntegerNode(builder.headerCacheSize.intValue());
        this.outputBufferSize = builder.outputBufferSize == null ? new IntegerNode(65536) : new IntegerNode(builder.outputBufferSize.intValue());
        this.requestHeaderSize = builder.requestHeaderSize == null ? new IntegerNode(65536) : new IntegerNode(builder.requestHeaderSize.intValue());
        this.responseHeaderSize = builder.responseHeaderSize == null ? new IntegerNode(65536) : new IntegerNode(builder.responseHeaderSize.intValue());
        this.acceptQueueSize = builder.acceptQueueSize == null ? new IntegerNode(0) : new IntegerNode(builder.acceptQueueSize.intValue());
        this.maxContentSize = builder.maxContentSize == null ? new LongNode(-1L) : new LongNode(builder.maxContentSize.longValue());
        this.reuseAddress = builder.reuseAddress == null ? new BooleanNode(true) : new BooleanNode(builder.reuseAddress.booleanValue());
        this.idleTimeout = builder.idleTimeout == null ? new DoubleNode(180.0) : new DoubleNode(builder.idleTimeout.doubleValue());
        this.tcpKeepAliveEnabled = builder.tcpKeepAliveEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.tcpKeepAliveEnabled.booleanValue());
        this.tcpNoDelay = builder.tcpNoDelay == null ? new BooleanNode(true) : new BooleanNode(builder.tcpNoDelay.booleanValue());
        this.throttling = new Throttling(builder.throttling, throwIfUninitialized);
        this.implicitTlsEnabled = builder.implicitTlsEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.implicitTlsEnabled.booleanValue());
        this.ssl = new Ssl(builder.ssl, throwIfUninitialized);
        this.tlsClientAuthEnforcer = new TlsClientAuthEnforcer(builder.tlsClientAuthEnforcer, throwIfUninitialized);
        this.healthCheckProxy = new HealthCheckProxy(builder.healthCheckProxy, throwIfUninitialized);
        this.proxyProtocol = new ProxyProtocol(builder.proxyProtocol, throwIfUninitialized);
        this.maxRequestsPerConnection = builder.maxRequestsPerConnection == null ? new IntegerNode(0) : new IntegerNode(builder.maxRequestsPerConnection.intValue());
        this.maxConnectionLife = builder.maxConnectionLife == null ? new DoubleNode(0.0) : new DoubleNode(builder.maxConnectionLife.doubleValue());
        this.http2Enabled = builder.http2Enabled == null ? new BooleanNode(true) : new BooleanNode(builder.http2Enabled.booleanValue());
        this.http2 = new Http2(builder.http2, throwIfUninitialized);
        this.serverName = new ServerName(builder.serverName, throwIfUninitialized);
        this.accessLog = new AccessLog(builder.accessLog, throwIfUninitialized);
    }

    public int listenPort() {
        return this.listenPort.value();
    }

    public String name() {
        return this.name.value();
    }

    public int headerCacheSize() {
        return this.headerCacheSize.value();
    }

    public int outputBufferSize() {
        return this.outputBufferSize.value();
    }

    public int requestHeaderSize() {
        return this.requestHeaderSize.value();
    }

    public int responseHeaderSize() {
        return this.responseHeaderSize.value();
    }

    public int acceptQueueSize() {
        return this.acceptQueueSize.value();
    }

    public long maxContentSize() {
        return this.maxContentSize.value();
    }

    public boolean reuseAddress() {
        return this.reuseAddress.value();
    }

    public double idleTimeout() {
        return this.idleTimeout.value();
    }

    public boolean tcpKeepAliveEnabled() {
        return this.tcpKeepAliveEnabled.value();
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay.value();
    }

    public Throttling throttling() {
        return this.throttling;
    }

    public boolean implicitTlsEnabled() {
        return this.implicitTlsEnabled.value();
    }

    public Ssl ssl() {
        return this.ssl;
    }

    public TlsClientAuthEnforcer tlsClientAuthEnforcer() {
        return this.tlsClientAuthEnforcer;
    }

    public HealthCheckProxy healthCheckProxy() {
        return this.healthCheckProxy;
    }

    public ProxyProtocol proxyProtocol() {
        return this.proxyProtocol;
    }

    public int maxRequestsPerConnection() {
        return this.maxRequestsPerConnection.value();
    }

    public double maxConnectionLife() {
        return this.maxConnectionLife.value();
    }

    public boolean http2Enabled() {
        return this.http2Enabled.value();
    }

    public Http2 http2() {
        return this.http2;
    }

    public ServerName serverName() {
        return this.serverName;
    }

    public AccessLog accessLog() {
        return this.accessLog;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ConnectorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer listenPort = null;
        private String name = null;
        private Integer headerCacheSize = null;
        private Integer outputBufferSize = null;
        private Integer requestHeaderSize = null;
        private Integer responseHeaderSize = null;
        private Integer acceptQueueSize = null;
        private Long maxContentSize = null;
        private Boolean reuseAddress = null;
        private Double idleTimeout = null;
        private Boolean tcpKeepAliveEnabled = null;
        private Boolean tcpNoDelay = null;
        public Throttling.Builder throttling = new Throttling.Builder();
        private Boolean implicitTlsEnabled = null;
        public Ssl.Builder ssl = new Ssl.Builder();
        public TlsClientAuthEnforcer.Builder tlsClientAuthEnforcer = new TlsClientAuthEnforcer.Builder();
        public HealthCheckProxy.Builder healthCheckProxy = new HealthCheckProxy.Builder();
        public ProxyProtocol.Builder proxyProtocol = new ProxyProtocol.Builder();
        private Integer maxRequestsPerConnection = null;
        private Double maxConnectionLife = null;
        private Boolean http2Enabled = null;
        public Http2.Builder http2 = new Http2.Builder();
        public ServerName.Builder serverName = new ServerName.Builder();
        public AccessLog.Builder accessLog = new AccessLog.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ConnectorConfig config) {
            this.listenPort(config.listenPort());
            this.name(config.name());
            this.headerCacheSize(config.headerCacheSize());
            this.outputBufferSize(config.outputBufferSize());
            this.requestHeaderSize(config.requestHeaderSize());
            this.responseHeaderSize(config.responseHeaderSize());
            this.acceptQueueSize(config.acceptQueueSize());
            this.maxContentSize(config.maxContentSize());
            this.reuseAddress(config.reuseAddress());
            this.idleTimeout(config.idleTimeout());
            this.tcpKeepAliveEnabled(config.tcpKeepAliveEnabled());
            this.tcpNoDelay(config.tcpNoDelay());
            this.throttling(new Throttling.Builder(config.throttling()));
            this.implicitTlsEnabled(config.implicitTlsEnabled());
            this.ssl(new Ssl.Builder(config.ssl()));
            this.tlsClientAuthEnforcer(new TlsClientAuthEnforcer.Builder(config.tlsClientAuthEnforcer()));
            this.healthCheckProxy(new HealthCheckProxy.Builder(config.healthCheckProxy()));
            this.proxyProtocol(new ProxyProtocol.Builder(config.proxyProtocol()));
            this.maxRequestsPerConnection(config.maxRequestsPerConnection());
            this.maxConnectionLife(config.maxConnectionLife());
            this.http2Enabled(config.http2Enabled());
            this.http2(new Http2.Builder(config.http2()));
            this.serverName(new ServerName.Builder(config.serverName()));
            this.accessLog(new AccessLog.Builder(config.accessLog()));
        }

        private Builder override(Builder __superior) {
            if (__superior.listenPort != null) {
                this.listenPort(__superior.listenPort);
            }
            if (__superior.name != null) {
                this.name(__superior.name);
            }
            if (__superior.headerCacheSize != null) {
                this.headerCacheSize(__superior.headerCacheSize);
            }
            if (__superior.outputBufferSize != null) {
                this.outputBufferSize(__superior.outputBufferSize);
            }
            if (__superior.requestHeaderSize != null) {
                this.requestHeaderSize(__superior.requestHeaderSize);
            }
            if (__superior.responseHeaderSize != null) {
                this.responseHeaderSize(__superior.responseHeaderSize);
            }
            if (__superior.acceptQueueSize != null) {
                this.acceptQueueSize(__superior.acceptQueueSize);
            }
            if (__superior.maxContentSize != null) {
                this.maxContentSize(__superior.maxContentSize);
            }
            if (__superior.reuseAddress != null) {
                this.reuseAddress(__superior.reuseAddress);
            }
            if (__superior.idleTimeout != null) {
                this.idleTimeout(__superior.idleTimeout);
            }
            if (__superior.tcpKeepAliveEnabled != null) {
                this.tcpKeepAliveEnabled(__superior.tcpKeepAliveEnabled);
            }
            if (__superior.tcpNoDelay != null) {
                this.tcpNoDelay(__superior.tcpNoDelay);
            }
            this.throttling(this.throttling.override(__superior.throttling));
            if (__superior.implicitTlsEnabled != null) {
                this.implicitTlsEnabled(__superior.implicitTlsEnabled);
            }
            this.ssl(this.ssl.override(__superior.ssl));
            this.tlsClientAuthEnforcer(this.tlsClientAuthEnforcer.override(__superior.tlsClientAuthEnforcer));
            this.healthCheckProxy(this.healthCheckProxy.override(__superior.healthCheckProxy));
            this.proxyProtocol(this.proxyProtocol.override(__superior.proxyProtocol));
            if (__superior.maxRequestsPerConnection != null) {
                this.maxRequestsPerConnection(__superior.maxRequestsPerConnection);
            }
            if (__superior.maxConnectionLife != null) {
                this.maxConnectionLife(__superior.maxConnectionLife);
            }
            if (__superior.http2Enabled != null) {
                this.http2Enabled(__superior.http2Enabled);
            }
            this.http2(this.http2.override(__superior.http2));
            this.serverName(this.serverName.override(__superior.serverName));
            this.accessLog(this.accessLog.override(__superior.accessLog));
            return this;
        }

        public Builder listenPort(int __value) {
            this.listenPort = __value;
            return this;
        }

        private Builder listenPort(String __value) {
            return this.listenPort(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.name = __value;
            return this;
        }

        public Builder headerCacheSize(int __value) {
            this.headerCacheSize = __value;
            return this;
        }

        private Builder headerCacheSize(String __value) {
            return this.headerCacheSize(Integer.valueOf(__value));
        }

        public Builder outputBufferSize(int __value) {
            this.outputBufferSize = __value;
            return this;
        }

        private Builder outputBufferSize(String __value) {
            return this.outputBufferSize(Integer.valueOf(__value));
        }

        public Builder requestHeaderSize(int __value) {
            this.requestHeaderSize = __value;
            return this;
        }

        private Builder requestHeaderSize(String __value) {
            return this.requestHeaderSize(Integer.valueOf(__value));
        }

        public Builder responseHeaderSize(int __value) {
            this.responseHeaderSize = __value;
            return this;
        }

        private Builder responseHeaderSize(String __value) {
            return this.responseHeaderSize(Integer.valueOf(__value));
        }

        public Builder acceptQueueSize(int __value) {
            this.acceptQueueSize = __value;
            return this;
        }

        private Builder acceptQueueSize(String __value) {
            return this.acceptQueueSize(Integer.valueOf(__value));
        }

        public Builder maxContentSize(long __value) {
            this.maxContentSize = __value;
            return this;
        }

        private Builder maxContentSize(String __value) {
            return this.maxContentSize(Long.valueOf(__value));
        }

        public Builder reuseAddress(boolean __value) {
            this.reuseAddress = __value;
            return this;
        }

        private Builder reuseAddress(String __value) {
            return this.reuseAddress(Boolean.valueOf(__value));
        }

        public Builder idleTimeout(double __value) {
            this.idleTimeout = __value;
            return this;
        }

        private Builder idleTimeout(String __value) {
            return this.idleTimeout(Double.valueOf(__value));
        }

        public Builder tcpKeepAliveEnabled(boolean __value) {
            this.tcpKeepAliveEnabled = __value;
            return this;
        }

        private Builder tcpKeepAliveEnabled(String __value) {
            return this.tcpKeepAliveEnabled(Boolean.valueOf(__value));
        }

        public Builder tcpNoDelay(boolean __value) {
            this.tcpNoDelay = __value;
            return this;
        }

        private Builder tcpNoDelay(String __value) {
            return this.tcpNoDelay(Boolean.valueOf(__value));
        }

        public Builder throttling(Throttling.Builder __builder) {
            this.throttling = __builder;
            return this;
        }

        public Builder throttling(Consumer<Throttling.Builder> __func) {
            Throttling.Builder __inner = new Throttling.Builder();
            __func.accept(__inner);
            this.throttling = __inner;
            return this;
        }

        public Builder implicitTlsEnabled(boolean __value) {
            this.implicitTlsEnabled = __value;
            return this;
        }

        private Builder implicitTlsEnabled(String __value) {
            return this.implicitTlsEnabled(Boolean.valueOf(__value));
        }

        public Builder ssl(Ssl.Builder __builder) {
            this.ssl = __builder;
            return this;
        }

        public Builder ssl(Consumer<Ssl.Builder> __func) {
            Ssl.Builder __inner = new Ssl.Builder();
            __func.accept(__inner);
            this.ssl = __inner;
            return this;
        }

        public Builder tlsClientAuthEnforcer(TlsClientAuthEnforcer.Builder __builder) {
            this.tlsClientAuthEnforcer = __builder;
            return this;
        }

        public Builder tlsClientAuthEnforcer(Consumer<TlsClientAuthEnforcer.Builder> __func) {
            TlsClientAuthEnforcer.Builder __inner = new TlsClientAuthEnforcer.Builder();
            __func.accept(__inner);
            this.tlsClientAuthEnforcer = __inner;
            return this;
        }

        public Builder healthCheckProxy(HealthCheckProxy.Builder __builder) {
            this.healthCheckProxy = __builder;
            return this;
        }

        public Builder healthCheckProxy(Consumer<HealthCheckProxy.Builder> __func) {
            HealthCheckProxy.Builder __inner = new HealthCheckProxy.Builder();
            __func.accept(__inner);
            this.healthCheckProxy = __inner;
            return this;
        }

        public Builder proxyProtocol(ProxyProtocol.Builder __builder) {
            this.proxyProtocol = __builder;
            return this;
        }

        public Builder proxyProtocol(Consumer<ProxyProtocol.Builder> __func) {
            ProxyProtocol.Builder __inner = new ProxyProtocol.Builder();
            __func.accept(__inner);
            this.proxyProtocol = __inner;
            return this;
        }

        public Builder maxRequestsPerConnection(int __value) {
            this.maxRequestsPerConnection = __value;
            return this;
        }

        private Builder maxRequestsPerConnection(String __value) {
            return this.maxRequestsPerConnection(Integer.valueOf(__value));
        }

        public Builder maxConnectionLife(double __value) {
            this.maxConnectionLife = __value;
            return this;
        }

        private Builder maxConnectionLife(String __value) {
            return this.maxConnectionLife(Double.valueOf(__value));
        }

        public Builder http2Enabled(boolean __value) {
            this.http2Enabled = __value;
            return this;
        }

        private Builder http2Enabled(String __value) {
            return this.http2Enabled(Boolean.valueOf(__value));
        }

        public Builder http2(Http2.Builder __builder) {
            this.http2 = __builder;
            return this;
        }

        public Builder http2(Consumer<Http2.Builder> __func) {
            Http2.Builder __inner = new Http2.Builder();
            __func.accept(__inner);
            this.http2 = __inner;
            return this;
        }

        public Builder serverName(ServerName.Builder __builder) {
            this.serverName = __builder;
            return this;
        }

        public Builder serverName(Consumer<ServerName.Builder> __func) {
            ServerName.Builder __inner = new ServerName.Builder();
            __func.accept(__inner);
            this.serverName = __inner;
            return this;
        }

        public Builder accessLog(AccessLog.Builder __builder) {
            this.accessLog = __builder;
            return this;
        }

        public Builder accessLog(Consumer<AccessLog.Builder> __func) {
            AccessLog.Builder __inner = new AccessLog.Builder();
            __func.accept(__inner);
            this.accessLog = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ConnectorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ConnectorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ConnectorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ConnectorConfig build() {
            return new ConnectorConfig(this);
        }
    }

    public static final class Throttling
    extends InnerNode {
        private final BooleanNode enabled;
        private final IntegerNode maxConnections;
        private final DoubleNode maxHeapUtilization;
        private final IntegerNode maxAcceptRate;
        private final DoubleNode idleTimeout;

        public Throttling(Builder builder) {
            this(builder, true);
        }

        private Throttling(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.throttling must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.maxConnections = builder.maxConnections == null ? new IntegerNode(-1) : new IntegerNode(builder.maxConnections.intValue());
            this.maxHeapUtilization = builder.maxHeapUtilization == null ? new DoubleNode(-1.0) : new DoubleNode(builder.maxHeapUtilization.doubleValue());
            this.maxAcceptRate = builder.maxAcceptRate == null ? new IntegerNode(-1) : new IntegerNode(builder.maxAcceptRate.intValue());
            this.idleTimeout = builder.idleTimeout == null ? new DoubleNode(-1.0) : new DoubleNode(builder.idleTimeout.doubleValue());
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public int maxConnections() {
            return this.maxConnections.value();
        }

        public double maxHeapUtilization() {
            return this.maxHeapUtilization.value();
        }

        public int maxAcceptRate() {
            return this.maxAcceptRate.value();
        }

        public double idleTimeout() {
            return this.idleTimeout.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Throttling newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("throttling");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private Integer maxConnections = null;
            private Double maxHeapUtilization = null;
            private Integer maxAcceptRate = null;
            private Double idleTimeout = null;

            public Builder() {
            }

            public Builder(Throttling config) {
                this.enabled(config.enabled());
                this.maxConnections(config.maxConnections());
                this.maxHeapUtilization(config.maxHeapUtilization());
                this.maxAcceptRate(config.maxAcceptRate());
                this.idleTimeout(config.idleTimeout());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.maxConnections != null) {
                    this.maxConnections(__superior.maxConnections);
                }
                if (__superior.maxHeapUtilization != null) {
                    this.maxHeapUtilization(__superior.maxHeapUtilization);
                }
                if (__superior.maxAcceptRate != null) {
                    this.maxAcceptRate(__superior.maxAcceptRate);
                }
                if (__superior.idleTimeout != null) {
                    this.idleTimeout(__superior.idleTimeout);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder maxConnections(int __value) {
                this.maxConnections = __value;
                return this;
            }

            private Builder maxConnections(String __value) {
                return this.maxConnections(Integer.valueOf(__value));
            }

            public Builder maxHeapUtilization(double __value) {
                this.maxHeapUtilization = __value;
                return this;
            }

            private Builder maxHeapUtilization(String __value) {
                return this.maxHeapUtilization(Double.valueOf(__value));
            }

            public Builder maxAcceptRate(int __value) {
                this.maxAcceptRate = __value;
                return this;
            }

            private Builder maxAcceptRate(String __value) {
                return this.maxAcceptRate(Integer.valueOf(__value));
            }

            public Builder idleTimeout(double __value) {
                this.idleTimeout = __value;
                return this;
            }

            private Builder idleTimeout(String __value) {
                return this.idleTimeout(Double.valueOf(__value));
            }

            public Throttling build() {
                return new Throttling(this);
            }
        }
    }

    public static final class Ssl
    extends InnerNode {
        private final BooleanNode enabled;
        private final StringNode privateKeyFile;
        private final StringNode privateKey;
        private final StringNode certificateFile;
        private final StringNode certificate;
        private final StringNode caCertificateFile;
        private final StringNode caCertificate;
        private final ClientAuth clientAuth;
        private final LeafNodeVector<String, StringNode> enabledCipherSuites;
        private final LeafNodeVector<String, StringNode> enabledProtocols;

        public Ssl(Builder builder) {
            this(builder, true);
        }

        private Ssl(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.ssl must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.privateKeyFile = builder.privateKeyFile == null ? new StringNode("") : new StringNode(builder.privateKeyFile);
            this.privateKey = builder.privateKey == null ? new StringNode("") : new StringNode(builder.privateKey);
            this.certificateFile = builder.certificateFile == null ? new StringNode("") : new StringNode(builder.certificateFile);
            this.certificate = builder.certificate == null ? new StringNode("") : new StringNode(builder.certificate);
            this.caCertificateFile = builder.caCertificateFile == null ? new StringNode("") : new StringNode(builder.caCertificateFile);
            this.caCertificate = builder.caCertificate == null ? new StringNode("") : new StringNode(builder.caCertificate);
            this.clientAuth = builder.clientAuth == null ? new ClientAuth(ClientAuth.DISABLED) : new ClientAuth(builder.clientAuth);
            this.enabledCipherSuites = new LeafNodeVector(builder.enabledCipherSuites, (LeafNode)new StringNode());
            this.enabledProtocols = new LeafNodeVector(builder.enabledProtocols, (LeafNode)new StringNode());
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public String privateKeyFile() {
            return this.privateKeyFile.value();
        }

        public String privateKey() {
            return this.privateKey.value();
        }

        public String certificateFile() {
            return this.certificateFile.value();
        }

        public String certificate() {
            return this.certificate.value();
        }

        public String caCertificateFile() {
            return this.caCertificateFile.value();
        }

        public String caCertificate() {
            return this.caCertificate.value();
        }

        public ClientAuth.Enum clientAuth() {
            return (ClientAuth.Enum)((Object)this.clientAuth.value());
        }

        public List<String> enabledCipherSuites() {
            return this.enabledCipherSuites.asList();
        }

        public String enabledCipherSuites(int i) {
            return ((StringNode)this.enabledCipherSuites.get(i)).value();
        }

        public List<String> enabledProtocols() {
            return this.enabledProtocols.asList();
        }

        public String enabledProtocols(int i) {
            return ((StringNode)this.enabledProtocols.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Ssl newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("ssl");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private String privateKeyFile = null;
            private String privateKey = null;
            private String certificateFile = null;
            private String certificate = null;
            private String caCertificateFile = null;
            private String caCertificate = null;
            private ClientAuth.Enum clientAuth = null;
            public List<String> enabledCipherSuites = new ArrayList<String>();
            public List<String> enabledProtocols = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Ssl config) {
                this.enabled(config.enabled());
                this.privateKeyFile(config.privateKeyFile());
                this.privateKey(config.privateKey());
                this.certificateFile(config.certificateFile());
                this.certificate(config.certificate());
                this.caCertificateFile(config.caCertificateFile());
                this.caCertificate(config.caCertificate());
                this.clientAuth(config.clientAuth());
                this.enabledCipherSuites(config.enabledCipherSuites());
                this.enabledProtocols(config.enabledProtocols());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.privateKeyFile != null) {
                    this.privateKeyFile(__superior.privateKeyFile);
                }
                if (__superior.privateKey != null) {
                    this.privateKey(__superior.privateKey);
                }
                if (__superior.certificateFile != null) {
                    this.certificateFile(__superior.certificateFile);
                }
                if (__superior.certificate != null) {
                    this.certificate(__superior.certificate);
                }
                if (__superior.caCertificateFile != null) {
                    this.caCertificateFile(__superior.caCertificateFile);
                }
                if (__superior.caCertificate != null) {
                    this.caCertificate(__superior.caCertificate);
                }
                if (__superior.clientAuth != null) {
                    this.clientAuth(__superior.clientAuth);
                }
                if (!__superior.enabledCipherSuites.isEmpty()) {
                    this.enabledCipherSuites.addAll(__superior.enabledCipherSuites);
                }
                if (!__superior.enabledProtocols.isEmpty()) {
                    this.enabledProtocols.addAll(__superior.enabledProtocols);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder privateKeyFile(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.privateKeyFile = __value;
                return this;
            }

            public Builder privateKey(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.privateKey = __value;
                return this;
            }

            public Builder certificateFile(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.certificateFile = __value;
                return this;
            }

            public Builder certificate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.certificate = __value;
                return this;
            }

            public Builder caCertificateFile(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.caCertificateFile = __value;
                return this;
            }

            public Builder caCertificate(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.caCertificate = __value;
                return this;
            }

            public Builder clientAuth(ClientAuth.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.clientAuth = __value;
                return this;
            }

            private Builder clientAuth(String __value) {
                return this.clientAuth(ClientAuth.Enum.valueOf(__value));
            }

            public Builder enabledCipherSuites(String __value) {
                this.enabledCipherSuites.add(__value);
                return this;
            }

            public Builder enabledCipherSuites(Collection<String> __values) {
                this.enabledCipherSuites.addAll(__values);
                return this;
            }

            public Builder enabledProtocols(String __value) {
                this.enabledProtocols.add(__value);
                return this;
            }

            public Builder enabledProtocols(Collection<String> __values) {
                this.enabledProtocols.addAll(__values);
                return this;
            }

            public Ssl build() {
                return new Ssl(this);
            }
        }

        public static final class ClientAuth
        extends EnumNode<Enum> {
            public static final Enum DISABLED = Enum.DISABLED;
            public static final Enum WANT_AUTH = Enum.WANT_AUTH;
            public static final Enum NEED_AUTH = Enum.NEED_AUTH;

            public ClientAuth() {
                this.value = null;
            }

            public ClientAuth(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                DISABLED,
                WANT_AUTH,
                NEED_AUTH;

            }
        }
    }

    public static final class TlsClientAuthEnforcer
    extends InnerNode {
        private final BooleanNode enable;
        private final LeafNodeVector<String, StringNode> pathWhitelist;

        public TlsClientAuthEnforcer(Builder builder) {
            this(builder, true);
        }

        private TlsClientAuthEnforcer(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.tlsClientAuthEnforcer must be initialized: " + builder.__uninitialized);
            }
            this.enable = builder.enable == null ? new BooleanNode(false) : new BooleanNode(builder.enable.booleanValue());
            this.pathWhitelist = new LeafNodeVector(builder.pathWhitelist, (LeafNode)new StringNode());
        }

        public boolean enable() {
            return this.enable.value();
        }

        public List<String> pathWhitelist() {
            return this.pathWhitelist.asList();
        }

        public String pathWhitelist(int i) {
            return ((StringNode)this.pathWhitelist.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(TlsClientAuthEnforcer newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("tlsClientAuthEnforcer");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enable = null;
            public List<String> pathWhitelist = new ArrayList<String>();

            public Builder() {
            }

            public Builder(TlsClientAuthEnforcer config) {
                this.enable(config.enable());
                this.pathWhitelist(config.pathWhitelist());
            }

            private Builder override(Builder __superior) {
                if (__superior.enable != null) {
                    this.enable(__superior.enable);
                }
                if (!__superior.pathWhitelist.isEmpty()) {
                    this.pathWhitelist.addAll(__superior.pathWhitelist);
                }
                return this;
            }

            public Builder enable(boolean __value) {
                this.enable = __value;
                return this;
            }

            private Builder enable(String __value) {
                return this.enable(Boolean.valueOf(__value));
            }

            public Builder pathWhitelist(String __value) {
                this.pathWhitelist.add(__value);
                return this;
            }

            public Builder pathWhitelist(Collection<String> __values) {
                this.pathWhitelist.addAll(__values);
                return this;
            }

            public TlsClientAuthEnforcer build() {
                return new TlsClientAuthEnforcer(this);
            }
        }
    }

    public static final class HealthCheckProxy
    extends InnerNode {
        private final BooleanNode enable;
        private final IntegerNode port;
        private final DoubleNode clientTimeout;
        private final DoubleNode handlerTimeout;
        private final DoubleNode cacheExpiry;

        public HealthCheckProxy(Builder builder) {
            this(builder, true);
        }

        private HealthCheckProxy(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.healthCheckProxy must be initialized: " + builder.__uninitialized);
            }
            this.enable = builder.enable == null ? new BooleanNode(false) : new BooleanNode(builder.enable.booleanValue());
            this.port = builder.port == null ? new IntegerNode(8080) : new IntegerNode(builder.port.intValue());
            this.clientTimeout = builder.clientTimeout == null ? new DoubleNode(1.0) : new DoubleNode(builder.clientTimeout.doubleValue());
            this.handlerTimeout = builder.handlerTimeout == null ? new DoubleNode(1.5) : new DoubleNode(builder.handlerTimeout.doubleValue());
            this.cacheExpiry = builder.cacheExpiry == null ? new DoubleNode(1.0) : new DoubleNode(builder.cacheExpiry.doubleValue());
        }

        public boolean enable() {
            return this.enable.value();
        }

        public int port() {
            return this.port.value();
        }

        public double clientTimeout() {
            return this.clientTimeout.value();
        }

        public double handlerTimeout() {
            return this.handlerTimeout.value();
        }

        public double cacheExpiry() {
            return this.cacheExpiry.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(HealthCheckProxy newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("healthCheckProxy");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enable = null;
            private Integer port = null;
            private Double clientTimeout = null;
            private Double handlerTimeout = null;
            private Double cacheExpiry = null;

            public Builder() {
            }

            public Builder(HealthCheckProxy config) {
                this.enable(config.enable());
                this.port(config.port());
                this.clientTimeout(config.clientTimeout());
                this.handlerTimeout(config.handlerTimeout());
                this.cacheExpiry(config.cacheExpiry());
            }

            private Builder override(Builder __superior) {
                if (__superior.enable != null) {
                    this.enable(__superior.enable);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (__superior.clientTimeout != null) {
                    this.clientTimeout(__superior.clientTimeout);
                }
                if (__superior.handlerTimeout != null) {
                    this.handlerTimeout(__superior.handlerTimeout);
                }
                if (__superior.cacheExpiry != null) {
                    this.cacheExpiry(__superior.cacheExpiry);
                }
                return this;
            }

            public Builder enable(boolean __value) {
                this.enable = __value;
                return this;
            }

            private Builder enable(String __value) {
                return this.enable(Boolean.valueOf(__value));
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder clientTimeout(double __value) {
                this.clientTimeout = __value;
                return this;
            }

            private Builder clientTimeout(String __value) {
                return this.clientTimeout(Double.valueOf(__value));
            }

            public Builder handlerTimeout(double __value) {
                this.handlerTimeout = __value;
                return this;
            }

            private Builder handlerTimeout(String __value) {
                return this.handlerTimeout(Double.valueOf(__value));
            }

            public Builder cacheExpiry(double __value) {
                this.cacheExpiry = __value;
                return this;
            }

            private Builder cacheExpiry(String __value) {
                return this.cacheExpiry(Double.valueOf(__value));
            }

            public HealthCheckProxy build() {
                return new HealthCheckProxy(this);
            }
        }
    }

    public static final class ProxyProtocol
    extends InnerNode {
        private final BooleanNode enabled;
        private final BooleanNode mixedMode;

        public ProxyProtocol(Builder builder) {
            this(builder, true);
        }

        private ProxyProtocol(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.proxyProtocol must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.mixedMode = builder.mixedMode == null ? new BooleanNode(false) : new BooleanNode(builder.mixedMode.booleanValue());
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public boolean mixedMode() {
            return this.mixedMode.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(ProxyProtocol newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("proxyProtocol");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private Boolean mixedMode = null;

            public Builder() {
            }

            public Builder(ProxyProtocol config) {
                this.enabled(config.enabled());
                this.mixedMode(config.mixedMode());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.mixedMode != null) {
                    this.mixedMode(__superior.mixedMode);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder mixedMode(boolean __value) {
                this.mixedMode = __value;
                return this;
            }

            private Builder mixedMode(String __value) {
                return this.mixedMode(Boolean.valueOf(__value));
            }

            public ProxyProtocol build() {
                return new ProxyProtocol(this);
            }
        }
    }

    public static final class Http2
    extends InnerNode {
        private final DoubleNode streamIdleTimeout;
        private final IntegerNode maxConcurrentStreams;

        public Http2(Builder builder) {
            this(builder, true);
        }

        private Http2(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.http2 must be initialized: " + builder.__uninitialized);
            }
            this.streamIdleTimeout = builder.streamIdleTimeout == null ? new DoubleNode(600.0) : new DoubleNode(builder.streamIdleTimeout.doubleValue());
            this.maxConcurrentStreams = builder.maxConcurrentStreams == null ? new IntegerNode(512) : new IntegerNode(builder.maxConcurrentStreams.intValue());
        }

        public double streamIdleTimeout() {
            return this.streamIdleTimeout.value();
        }

        public int maxConcurrentStreams() {
            return this.maxConcurrentStreams.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Http2 newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("http2");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double streamIdleTimeout = null;
            private Integer maxConcurrentStreams = null;

            public Builder() {
            }

            public Builder(Http2 config) {
                this.streamIdleTimeout(config.streamIdleTimeout());
                this.maxConcurrentStreams(config.maxConcurrentStreams());
            }

            private Builder override(Builder __superior) {
                if (__superior.streamIdleTimeout != null) {
                    this.streamIdleTimeout(__superior.streamIdleTimeout);
                }
                if (__superior.maxConcurrentStreams != null) {
                    this.maxConcurrentStreams(__superior.maxConcurrentStreams);
                }
                return this;
            }

            public Builder streamIdleTimeout(double __value) {
                this.streamIdleTimeout = __value;
                return this;
            }

            private Builder streamIdleTimeout(String __value) {
                return this.streamIdleTimeout(Double.valueOf(__value));
            }

            public Builder maxConcurrentStreams(int __value) {
                this.maxConcurrentStreams = __value;
                return this;
            }

            private Builder maxConcurrentStreams(String __value) {
                return this.maxConcurrentStreams(Integer.valueOf(__value));
            }

            public Http2 build() {
                return new Http2(this);
            }
        }
    }

    public static final class ServerName
    extends InnerNode {
        private final StringNode fallback;
        private final LeafNodeVector<String, StringNode> allowed;
        private final LeafNodeVector<String, StringNode> known;

        public ServerName(Builder builder) {
            this(builder, true);
        }

        private ServerName(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.serverName must be initialized: " + builder.__uninitialized);
            }
            this.fallback = builder.fallback == null ? new StringNode("") : new StringNode(builder.fallback);
            this.allowed = new LeafNodeVector(builder.allowed, (LeafNode)new StringNode());
            this.known = new LeafNodeVector(builder.known, (LeafNode)new StringNode());
        }

        public String fallback() {
            return this.fallback.value();
        }

        public List<String> allowed() {
            return this.allowed.asList();
        }

        public String allowed(int i) {
            return ((StringNode)this.allowed.get(i)).value();
        }

        public List<String> known() {
            return this.known.asList();
        }

        public String known(int i) {
            return ((StringNode)this.known.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(ServerName newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("serverName");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String fallback = null;
            public List<String> allowed = new ArrayList<String>();
            public List<String> known = new ArrayList<String>();

            public Builder() {
            }

            public Builder(ServerName config) {
                this.fallback(config.fallback());
                this.allowed(config.allowed());
                this.known(config.known());
            }

            private Builder override(Builder __superior) {
                if (__superior.fallback != null) {
                    this.fallback(__superior.fallback);
                }
                if (!__superior.allowed.isEmpty()) {
                    this.allowed.addAll(__superior.allowed);
                }
                if (!__superior.known.isEmpty()) {
                    this.known.addAll(__superior.known);
                }
                return this;
            }

            public Builder fallback(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fallback = __value;
                return this;
            }

            public Builder allowed(String __value) {
                this.allowed.add(__value);
                return this;
            }

            public Builder allowed(Collection<String> __values) {
                this.allowed.addAll(__values);
                return this;
            }

            public Builder known(String __value) {
                this.known.add(__value);
                return this;
            }

            public Builder known(Collection<String> __values) {
                this.known.addAll(__values);
                return this;
            }

            public ServerName build() {
                return new ServerName(this);
            }
        }
    }

    public static final class AccessLog
    extends InnerNode {
        private final LeafNodeVector<String, StringNode> remoteAddressHeaders;
        private final LeafNodeVector<String, StringNode> remotePortHeaders;

        public AccessLog(Builder builder) {
            this(builder, true);
        }

        private AccessLog(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for connector.accessLog must be initialized: " + builder.__uninitialized);
            }
            this.remoteAddressHeaders = new LeafNodeVector(builder.remoteAddressHeaders, (LeafNode)new StringNode());
            this.remotePortHeaders = new LeafNodeVector(builder.remotePortHeaders, (LeafNode)new StringNode());
        }

        public List<String> remoteAddressHeaders() {
            return this.remoteAddressHeaders.asList();
        }

        public String remoteAddressHeaders(int i) {
            return ((StringNode)this.remoteAddressHeaders.get(i)).value();
        }

        public List<String> remotePortHeaders() {
            return this.remotePortHeaders.asList();
        }

        public String remotePortHeaders(int i) {
            return ((StringNode)this.remotePortHeaders.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(AccessLog newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("accessLog");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<String> remoteAddressHeaders = new ArrayList<String>();
            public List<String> remotePortHeaders = new ArrayList<String>();

            public Builder() {
            }

            public Builder(AccessLog config) {
                this.remoteAddressHeaders(config.remoteAddressHeaders());
                this.remotePortHeaders(config.remotePortHeaders());
            }

            private Builder override(Builder __superior) {
                if (!__superior.remoteAddressHeaders.isEmpty()) {
                    this.remoteAddressHeaders.addAll(__superior.remoteAddressHeaders);
                }
                if (!__superior.remotePortHeaders.isEmpty()) {
                    this.remotePortHeaders.addAll(__superior.remotePortHeaders);
                }
                return this;
            }

            public Builder remoteAddressHeaders(String __value) {
                this.remoteAddressHeaders.add(__value);
                return this;
            }

            public Builder remoteAddressHeaders(Collection<String> __values) {
                this.remoteAddressHeaders.addAll(__values);
                return this;
            }

            public Builder remotePortHeaders(String __value) {
                this.remotePortHeaders.add(__value);
                return this;
            }

            public Builder remotePortHeaders(Collection<String> __values) {
                this.remotePortHeaders.addAll(__values);
                return this;
            }

            public AccessLog build() {
                return new AccessLog(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

