/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.http;

import com.yahoo.jdisc.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;

public class AccessLogUtil {
    public static String getHttpMethod(HttpRequest httpRequest) {
        return httpRequest.getMethod().toString();
    }

    public static URI getUri(HttpRequest httpRequest) {
        return httpRequest.getUri();
    }

    public static String getHttpVersion(HttpRequest httpRequest) {
        return httpRequest.getVersion().toString();
    }

    public static String getReferrerHeader(HttpRequest httpRequest) {
        return AccessLogUtil.getFirstHeaderValue(httpRequest, "Referer");
    }

    public static String getUserAgentHeader(HttpRequest httpRequest) {
        return AccessLogUtil.getFirstHeaderValue(httpRequest, "User-Agent");
    }

    public static InetSocketAddress getRemoteAddress(HttpRequest httpRequest) {
        return (InetSocketAddress)httpRequest.getRemoteAddress();
    }

    private static String getFirstHeaderValue(HttpRequest httpRequest, String headerName) {
        List headerValues = httpRequest.headers().get((Object)headerName);
        return headerValues == null || headerValues.isEmpty() ? "" : (String)headerValues.get(0);
    }
}

