/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class QrConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "af6fca3c2d21d32c91f54f2b5f1ef2ca";
    public static final String CONFIG_DEF_NAME = "qr";
    public static final String CONFIG_DEF_NAMESPACE = "container";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container", "filedistributor.configid reference default=\"\" restart", "rpc.enabled bool default=false restart", "rpc.port int default=8086 restart", "rpc.host string default=\"\" restart", "rpc.slobrokId string default=\"\" restart", "discriminator string default=\"qrserver.0\" restart", "clustername string default=\"\"", "nodeIndex int default=0", "restartOnDeploy bool default=false restart", "restartOnInternalRedeploy enum { always, node_changes, content_changes, never } default=never restart", "shutdown.dumpHeapOnTimeout bool default=false", "shutdown.timeout double default=50.0"};
    private final Filedistributor filedistributor;
    private final Rpc rpc;
    private final StringNode discriminator;
    private final StringNode clustername;
    private final IntegerNode nodeIndex;
    private final BooleanNode restartOnDeploy;
    private final RestartOnInternalRedeploy restartOnInternalRedeploy;
    private final Shutdown shutdown;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public QrConfig(Builder builder) {
        this(builder, true);
    }

    private QrConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for qr must be initialized: " + builder.__uninitialized);
        }
        this.filedistributor = new Filedistributor(builder.filedistributor, throwIfUninitialized);
        this.rpc = new Rpc(builder.rpc, throwIfUninitialized);
        this.discriminator = builder.discriminator == null ? new StringNode("qrserver.0") : new StringNode(builder.discriminator);
        this.clustername = builder.clustername == null ? new StringNode("") : new StringNode(builder.clustername);
        this.nodeIndex = builder.nodeIndex == null ? new IntegerNode(0) : new IntegerNode(builder.nodeIndex.intValue());
        this.restartOnDeploy = builder.restartOnDeploy == null ? new BooleanNode(false) : new BooleanNode(builder.restartOnDeploy.booleanValue());
        this.restartOnInternalRedeploy = builder.restartOnInternalRedeploy == null ? new RestartOnInternalRedeploy(RestartOnInternalRedeploy.never) : new RestartOnInternalRedeploy(builder.restartOnInternalRedeploy);
        this.shutdown = new Shutdown(builder.shutdown, throwIfUninitialized);
    }

    public Filedistributor filedistributor() {
        return this.filedistributor;
    }

    public Rpc rpc() {
        return this.rpc;
    }

    public String discriminator() {
        return this.discriminator.value();
    }

    public String clustername() {
        return this.clustername.value();
    }

    public int nodeIndex() {
        return this.nodeIndex.value();
    }

    public boolean restartOnDeploy() {
        return this.restartOnDeploy.value();
    }

    public RestartOnInternalRedeploy.Enum restartOnInternalRedeploy() {
        return (RestartOnInternalRedeploy.Enum)((Object)this.restartOnInternalRedeploy.value());
    }

    public Shutdown shutdown() {
        return this.shutdown;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(QrConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.mergeChanges("filedistributor", this.filedistributor.getChangesRequiringRestart(newConfig.filedistributor));
        changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
        changes.compare((Node)this.discriminator, (Node)newConfig.discriminator, "discriminator", "A unique identifier string for this QRS. The only guarantee given is\nthis string will be unique for every QRS in a Vespa application.");
        changes.compare((Node)this.restartOnDeploy, (Node)newConfig.restartOnDeploy, "restartOnDeploy", "Force restart of container on deploy, and defer any changes until restart");
        changes.compare((Node)this.restartOnInternalRedeploy, (Node)newConfig.restartOnInternalRedeploy, "restartOnInternalRedeploy", "Specifies under what circumstances restart on deploy should apply to internal redeployments");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Filedistributor.Builder filedistributor = new Filedistributor.Builder();
        public Rpc.Builder rpc = new Rpc.Builder();
        private String discriminator = null;
        private String clustername = null;
        private Integer nodeIndex = null;
        private Boolean restartOnDeploy = null;
        private RestartOnInternalRedeploy.Enum restartOnInternalRedeploy = null;
        public Shutdown.Builder shutdown = new Shutdown.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(QrConfig config) {
            this.filedistributor(new Filedistributor.Builder(config.filedistributor()));
            this.rpc(new Rpc.Builder(config.rpc()));
            this.discriminator(config.discriminator());
            this.clustername(config.clustername());
            this.nodeIndex(config.nodeIndex());
            this.restartOnDeploy(config.restartOnDeploy());
            this.restartOnInternalRedeploy(config.restartOnInternalRedeploy());
            this.shutdown(new Shutdown.Builder(config.shutdown()));
        }

        private Builder override(Builder __superior) {
            this.filedistributor(this.filedistributor.override(__superior.filedistributor));
            this.rpc(this.rpc.override(__superior.rpc));
            if (__superior.discriminator != null) {
                this.discriminator(__superior.discriminator);
            }
            if (__superior.clustername != null) {
                this.clustername(__superior.clustername);
            }
            if (__superior.nodeIndex != null) {
                this.nodeIndex(__superior.nodeIndex);
            }
            if (__superior.restartOnDeploy != null) {
                this.restartOnDeploy(__superior.restartOnDeploy);
            }
            if (__superior.restartOnInternalRedeploy != null) {
                this.restartOnInternalRedeploy(__superior.restartOnInternalRedeploy);
            }
            this.shutdown(this.shutdown.override(__superior.shutdown));
            return this;
        }

        public Builder filedistributor(Filedistributor.Builder __builder) {
            this.filedistributor = __builder;
            return this;
        }

        public Builder filedistributor(Consumer<Filedistributor.Builder> __func) {
            Filedistributor.Builder __inner = new Filedistributor.Builder();
            __func.accept(__inner);
            this.filedistributor = __inner;
            return this;
        }

        public Builder rpc(Rpc.Builder __builder) {
            this.rpc = __builder;
            return this;
        }

        public Builder rpc(Consumer<Rpc.Builder> __func) {
            Rpc.Builder __inner = new Rpc.Builder();
            __func.accept(__inner);
            this.rpc = __inner;
            return this;
        }

        public Builder discriminator(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.discriminator = __value;
            return this;
        }

        public Builder clustername(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clustername = __value;
            return this;
        }

        public Builder nodeIndex(int __value) {
            this.nodeIndex = __value;
            return this;
        }

        private Builder nodeIndex(String __value) {
            return this.nodeIndex(Integer.valueOf(__value));
        }

        public Builder restartOnDeploy(boolean __value) {
            this.restartOnDeploy = __value;
            return this;
        }

        private Builder restartOnDeploy(String __value) {
            return this.restartOnDeploy(Boolean.valueOf(__value));
        }

        public Builder restartOnInternalRedeploy(RestartOnInternalRedeploy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.restartOnInternalRedeploy = __value;
            return this;
        }

        private Builder restartOnInternalRedeploy(String __value) {
            return this.restartOnInternalRedeploy(RestartOnInternalRedeploy.Enum.valueOf(__value));
        }

        public Builder shutdown(Shutdown.Builder __builder) {
            this.shutdown = __builder;
            return this;
        }

        public Builder shutdown(Consumer<Shutdown.Builder> __func) {
            Shutdown.Builder __inner = new Shutdown.Builder();
            __func.accept(__inner);
            this.shutdown = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return QrConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return QrConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return QrConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public QrConfig build() {
            return new QrConfig(this);
        }
    }

    public static final class Filedistributor
    extends InnerNode {
        private final ReferenceNode configid;

        public Filedistributor(Builder builder) {
            this(builder, true);
        }

        private Filedistributor(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr.filedistributor must be initialized: " + builder.__uninitialized);
            }
            this.configid = builder.configid == null ? new ReferenceNode("") : new ReferenceNode(builder.configid);
        }

        public String configid() {
            return this.configid.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Filedistributor newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("filedistributor");
            changes.compare((Node)this.configid, (Node)newConfig.configid, "configid", "Changes to this config requires restart because it is used to initialize\nconnection to the config system\n\nfiledistributor rpc configuration");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String configid = null;

            public Builder() {
            }

            public Builder(Filedistributor config) {
                this.configid(config.configid());
            }

            private Builder override(Builder __superior) {
                if (__superior.configid != null) {
                    this.configid(__superior.configid);
                }
                return this;
            }

            public Builder configid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configid = __value;
                return this;
            }

            public Filedistributor build() {
                return new Filedistributor(this);
            }
        }
    }

    public static final class Rpc
    extends InnerNode {
        private final BooleanNode enabled;
        private final IntegerNode port;
        private final StringNode host;
        private final StringNode slobrokId;

        public Rpc(Builder builder) {
            this(builder, true);
        }

        private Rpc(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr.rpc must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.port = builder.port == null ? new IntegerNode(8086) : new IntegerNode(builder.port.intValue());
            this.host = builder.host == null ? new StringNode("") : new StringNode(builder.host);
            this.slobrokId = builder.slobrokId == null ? new StringNode("") : new StringNode(builder.slobrokId);
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public int port() {
            return this.port.value();
        }

        public String host() {
            return this.host.value();
        }

        public String slobrokId() {
            return this.slobrokId.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
            changes.compare((Node)this.enabled, (Node)newConfig.enabled, "enabled", "Is RPC server enabled?");
            changes.compare((Node)this.port, (Node)newConfig.port, "port", "RPC server listen port");
            changes.compare((Node)this.host, (Node)newConfig.host, "host", "Which interface to bind to.");
            changes.compare((Node)this.slobrokId, (Node)newConfig.slobrokId, "slobrokId", "The id this service should register itself with in slobrok");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private Integer port = null;
            private String host = null;
            private String slobrokId = null;

            public Builder() {
            }

            public Builder(Rpc config) {
                this.enabled(config.enabled());
                this.port(config.port());
                this.host(config.host());
                this.slobrokId(config.slobrokId());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.slobrokId != null) {
                    this.slobrokId(__superior.slobrokId);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                return this;
            }

            public Builder slobrokId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.slobrokId = __value;
                return this;
            }

            public Rpc build() {
                return new Rpc(this);
            }
        }
    }

    public static final class RestartOnInternalRedeploy
    extends EnumNode<Enum> {
        public static final Enum always = Enum.always;
        public static final Enum node_changes = Enum.node_changes;
        public static final Enum content_changes = Enum.content_changes;
        public static final Enum never = Enum.never;

        public RestartOnInternalRedeploy() {
            this.value = null;
        }

        public RestartOnInternalRedeploy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            always,
            node_changes,
            content_changes,
            never;

        }
    }

    public static final class Shutdown
    extends InnerNode {
        private final BooleanNode dumpHeapOnTimeout;
        private final DoubleNode timeout;

        public Shutdown(Builder builder) {
            this(builder, true);
        }

        private Shutdown(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for qr.shutdown must be initialized: " + builder.__uninitialized);
            }
            this.dumpHeapOnTimeout = builder.dumpHeapOnTimeout == null ? new BooleanNode(false) : new BooleanNode(builder.dumpHeapOnTimeout.booleanValue());
            this.timeout = builder.timeout == null ? new DoubleNode(50.0) : new DoubleNode(builder.timeout.doubleValue());
        }

        public boolean dumpHeapOnTimeout() {
            return this.dumpHeapOnTimeout.value();
        }

        public double timeout() {
            return this.timeout.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Shutdown newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("shutdown");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean dumpHeapOnTimeout = null;
            private Double timeout = null;

            public Builder() {
            }

            public Builder(Shutdown config) {
                this.dumpHeapOnTimeout(config.dumpHeapOnTimeout());
                this.timeout(config.timeout());
            }

            private Builder override(Builder __superior) {
                if (__superior.dumpHeapOnTimeout != null) {
                    this.dumpHeapOnTimeout(__superior.dumpHeapOnTimeout);
                }
                if (__superior.timeout != null) {
                    this.timeout(__superior.timeout);
                }
                return this;
            }

            public Builder dumpHeapOnTimeout(boolean __value) {
                this.dumpHeapOnTimeout = __value;
                return this;
            }

            private Builder dumpHeapOnTimeout(String __value) {
                return this.dumpHeapOnTimeout(Boolean.valueOf(__value));
            }

            public Builder timeout(double __value) {
                this.timeout = __value;
                return this;
            }

            private Builder timeout(String __value) {
                return this.timeout(Double.valueOf(__value));
            }

            public Shutdown build() {
                return new Shutdown(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

