/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.security.tls.TrustAllX509TrustManager;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProxyProtocolClientConnectionFactory;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class HealthCheckProxyHandler
extends HandlerWrapper {
    private static final Logger log = Logger.getLogger(HealthCheckProxyHandler.class.getName());
    private static final String HEALTH_CHECK_PATH = "/status.html";
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("health-check-proxy-client-"));
    private final Map<Integer, ProxyTarget> portToProxyTargetMapping;

    HealthCheckProxyHandler(List<JDiscServerConnector> connectors) {
        this.portToProxyTargetMapping = HealthCheckProxyHandler.createPortToProxyTargetMapping(connectors);
    }

    private static Map<Integer, ProxyTarget> createPortToProxyTargetMapping(List<JDiscServerConnector> connectors) {
        HashMap<Integer, ProxyTarget> mapping = new HashMap<Integer, ProxyTarget>();
        for (JDiscServerConnector connector : connectors) {
            ConnectorConfig.HealthCheckProxy proxyConfig = connector.connectorConfig().healthCheckProxy();
            if (!proxyConfig.enable()) continue;
            Duration targetTimeout = Duration.ofMillis((int)(proxyConfig.clientTimeout() * 1000.0));
            Duration handlerTimeout = Duration.ofMillis((int)(proxyConfig.handlerTimeout() * 1000.0));
            Duration cacheExpiry = Duration.ofMillis((int)(proxyConfig.cacheExpiry() * 1000.0));
            ProxyTarget target = HealthCheckProxyHandler.createProxyTarget(proxyConfig.port(), targetTimeout, handlerTimeout, cacheExpiry, connectors);
            mapping.put(connector.listenPort(), target);
            log.info(String.format("Port %1$d is configured as a health check proxy for port %2$d. HTTP requests to '%3$s' on %1$d are proxied as HTTPS to %2$d.", connector.listenPort(), proxyConfig.port(), HEALTH_CHECK_PATH));
        }
        return mapping;
    }

    private static ProxyTarget createProxyTarget(int targetPort, Duration clientTimeout, Duration handlerTimeout, Duration cacheExpiry, List<JDiscServerConnector> connectors) {
        JDiscServerConnector targetConnector = connectors.stream().filter(connector -> connector.listenPort() == targetPort).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find any connector with listen port " + targetPort));
        SslContextFactory.Server sslContextFactory = Optional.ofNullable((SslConnectionFactory)targetConnector.getConnectionFactory(SslConnectionFactory.class)).or(() -> Optional.ofNullable((DetectorConnectionFactory)targetConnector.getConnectionFactory(DetectorConnectionFactory.class)).map(detectorConnFactory -> (SslConnectionFactory)detectorConnFactory.getBean(SslConnectionFactory.class))).map(connFactory -> (SslContextFactory.Server)connFactory.getSslContextFactory()).orElseThrow(() -> new IllegalArgumentException("Health check proxy can only target https port"));
        ConnectorConfig.ProxyProtocol proxyProtocolCfg = targetConnector.connectorConfig().proxyProtocol();
        boolean proxyProtocol = proxyProtocolCfg.enabled() && !proxyProtocolCfg.mixedMode();
        return new ProxyTarget(targetPort, clientTimeout, handlerTimeout, cacheExpiry, sslContextFactory, proxyProtocol);
    }

    public void handle(String target, org.eclipse.jetty.server.Request request, HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws IOException, ServletException {
        int localPort = RequestUtils.getConnectorLocalPort(request);
        ProxyTarget proxyTarget = this.portToProxyTargetMapping.get(localPort);
        if (proxyTarget != null) {
            final AsyncContext asyncContext = servletRequest.startAsync();
            ServletOutputStream out = servletResponse.getOutputStream();
            if (servletRequest.getRequestURI().equals(HEALTH_CHECK_PATH)) {
                final ProxyRequestTask task = new ProxyRequestTask(asyncContext, proxyTarget, servletResponse, out);
                asyncContext.setTimeout(proxyTarget.handlerTimeout.toMillis());
                asyncContext.addListener(new AsyncListener(){

                    public void onStartAsync(AsyncEvent event) {
                    }

                    public void onComplete(AsyncEvent event) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onError(AsyncEvent event) {
                        log.log(Level.FINE, event.getThrowable(), () -> "AsyncListener.onError()");
                        Object object = task.monitor;
                        synchronized (object) {
                            if (task.state == ProxyRequestTask.State.DONE) {
                                return;
                            }
                            task.state = ProxyRequestTask.State.DONE;
                            servletResponse.setStatus(500);
                            asyncContext.complete();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onTimeout(AsyncEvent event) {
                        log.log(Level.FINE, event.getThrowable(), () -> "AsyncListener.onTimeout()");
                        Object object = task.monitor;
                        synchronized (object) {
                            if (task.state == ProxyRequestTask.State.DONE) {
                                return;
                            }
                            task.state = ProxyRequestTask.State.DONE;
                            servletResponse.setStatus(504);
                            asyncContext.complete();
                        }
                    }
                });
                this.executor.execute(task);
            } else {
                servletResponse.setStatus(404);
                asyncContext.complete();
            }
            request.setHandled(true);
        } else {
            this._handler.handle(target, request, servletRequest, servletResponse);
        }
    }

    protected void doStop() throws Exception {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            log.warning("Failed to shutdown executor in time");
        }
        for (ProxyTarget target : this.portToProxyTargetMapping.values()) {
            target.close();
        }
        super.doStop();
    }

    private static class ProxyTarget
    implements AutoCloseable {
        final int port;
        final Duration clientTimeout;
        final Duration handlerTimeout;
        final Duration cacheExpiry;
        final SslContextFactory.Server serverSsl;
        final boolean proxyProtocol;
        volatile HttpClient client;
        volatile StatusResponse lastResponse;

        ProxyTarget(int port, Duration clientTimeout, Duration handlerTimeout, Duration cacheExpiry, SslContextFactory.Server serverSsl, boolean proxyProtocol) {
            this.port = port;
            this.clientTimeout = clientTimeout;
            this.cacheExpiry = cacheExpiry;
            this.serverSsl = serverSsl;
            this.proxyProtocol = proxyProtocol;
            this.handlerTimeout = handlerTimeout;
        }

        StatusResponse requestStatusHtml() {
            StatusResponse response = this.lastResponse;
            if (response != null && !response.isExpired(this.cacheExpiry)) {
                return response;
            }
            this.lastResponse = this.getStatusResponse();
            return this.lastResponse;
        }

        private StatusResponse getStatusResponse() {
            try {
                ContentResponse response;
                byte[] content;
                Request request = this.client().newRequest("https://localhost:" + this.port + HealthCheckProxyHandler.HEALTH_CHECK_PATH);
                request.timeout(this.clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                request.idleTimeout(this.clientTimeout.toMillis(), TimeUnit.MILLISECONDS);
                if (this.proxyProtocol) {
                    request.tag((Object)new ProxyProtocolClientConnectionFactory.V1.Tag());
                }
                if ((content = (response = request.send()).getContent()) != null && content.length > 0) {
                    return new StatusResponse(response.getStatus(), response.getMediaType(), content);
                }
                return new StatusResponse(response.getStatus(), null, null);
            }
            catch (TimeoutException e) {
                log.log(Level.FINE, e, () -> "Proxy request timeout ('" + e.getMessage() + "')");
                return new StatusResponse(503, null, null);
            }
            catch (Exception e) {
                log.log(Level.FINE, e, () -> "Proxy request failed ('" + e.getMessage() + "')");
                return new StatusResponse(500, "text/plain", e.getMessage().getBytes());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HttpClient client() throws Exception {
            if (this.client == null) {
                ProxyTarget proxyTarget = this;
                synchronized (proxyTarget) {
                    if (this.client == null) {
                        int timeoutMillis = (int)this.clientTimeout.toMillis();
                        SslContextFactory.Client clientSsl = new SslContextFactory.Client();
                        clientSsl.setHostnameVerifier((__, ___) -> true);
                        clientSsl.setSslContext(this.getSslContext(this.serverSsl));
                        HttpClient client = new HttpClient((SslContextFactory)clientSsl);
                        client.setMaxConnectionsPerDestination(4);
                        client.setConnectTimeout((long)timeoutMillis);
                        client.setStopTimeout((long)timeoutMillis);
                        client.setIdleTimeout((long)timeoutMillis);
                        client.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, "health-check-proxy-client"));
                        client.start();
                        this.client = client;
                    }
                }
            }
            return this.client;
        }

        private SSLContext getSslContext(SslContextFactory.Server sslContextFactory) {
            if (sslContextFactory.getNeedClientAuth()) {
                log.info(String.format("Port %d requires client certificate - client will provide its node certificate", this.port));
                TransportSecurityOptions options = (TransportSecurityOptions)TransportSecurityUtils.getOptions().orElseThrow(() -> new IllegalStateException("Vespa TLS configuration is required when using health check proxy to a port with client auth 'need'"));
                return new SslContextBuilder().withKeyStore((Path)options.getPrivateKeyFile().get(), (Path)options.getCertificatesFile().get()).withTrustManager((X509ExtendedTrustManager)new TrustAllX509TrustManager()).build();
            }
            log.info(String.format("Port %d does not require a client certificate - client will not provide a certificate", this.port));
            return new SslContextBuilder().withTrustManager((X509ExtendedTrustManager)new TrustAllX509TrustManager()).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            ProxyTarget proxyTarget = this;
            synchronized (proxyTarget) {
                if (this.client != null) {
                    this.client.stop();
                    this.client.destroy();
                    this.client = null;
                }
            }
        }
    }

    private static class ProxyRequestTask
    implements Runnable {
        final Object monitor = new Object();
        final AsyncContext asyncContext;
        final ProxyTarget target;
        final HttpServletResponse servletResponse;
        final ServletOutputStream output;
        State state = State.INITIALIZED;

        ProxyRequestTask(AsyncContext asyncContext, ProxyTarget target, HttpServletResponse servletResponse, ServletOutputStream output) {
            this.asyncContext = asyncContext;
            this.target = target;
            this.servletResponse = servletResponse;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.state == State.DONE) {
                    return;
                }
            }
            final StatusResponse statusResponse = this.target.requestStatusHtml();
            Object object2 = this.monitor;
            synchronized (object2) {
                if (this.state == State.DONE) {
                    return;
                }
            }
            this.output.setWriteListener(new WriteListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onWritePossible() throws IOException {
                    if (output.isReady()) {
                        Object object = monitor;
                        synchronized (object) {
                            if (state == State.DONE) {
                                return;
                            }
                            servletResponse.setStatus(statusResponse.statusCode);
                            if (statusResponse.contentType != null) {
                                servletResponse.setHeader("Content-Type", statusResponse.contentType);
                            }
                            servletResponse.setHeader("Vespa-Health-Check-Proxy-Target", Integer.toString(target.port));
                            if (statusResponse.content != null) {
                                output.write(statusResponse.content);
                            }
                            state = State.DONE;
                            asyncContext.complete();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Throwable t) {
                    log.log(Level.FINE, t, () -> "Failed to write status response: " + t.getMessage());
                    Object object = monitor;
                    synchronized (object) {
                        if (state == State.DONE) {
                            return;
                        }
                        state = State.DONE;
                        servletResponse.setStatus(500);
                        asyncContext.complete();
                    }
                }
            });
        }

        static enum State {
            INITIALIZED,
            DONE;

        }
    }

    private static class StatusResponse {
        final long createdAt = System.nanoTime();
        final int statusCode;
        final String contentType;
        final byte[] content;

        StatusResponse(int statusCode, String contentType, byte[] content) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.content = content;
        }

        boolean isExpired(Duration expiry) {
            return System.nanoTime() - this.createdAt > expiry.toNanos();
        }
    }
}

