/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.DataplaneProxyCredentials;
import com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;

public class CloudSslContextProvider
extends ConfiguredSslContextFactoryProvider {
    private final DataplaneProxyCredentials dataplaneProxyCredentials;

    public CloudSslContextProvider(ConnectorConfig connectorConfig, DataplaneProxyCredentials dataplaneProxyCredentials) {
        super(connectorConfig);
        this.dataplaneProxyCredentials = dataplaneProxyCredentials;
    }

    @Override
    Optional<String> getCaCertificates(ConnectorConfig.Ssl sslConfig) {
        String proxyCert;
        try {
            proxyCert = Files.readString(this.dataplaneProxyCredentials.certificateFile(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Dataplane proxy certificate not available", e);
        }
        if (!sslConfig.caCertificate().isBlank()) {
            return Optional.of(sslConfig.caCertificate() + "\n" + proxyCert);
        }
        if (!sslConfig.caCertificateFile().isBlank()) {
            return Optional.of(CloudSslContextProvider.readToString(sslConfig.caCertificateFile()) + "\n" + proxyCert);
        }
        return Optional.of(proxyCert);
    }
}

