/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClustersStatus
extends AbstractComponent {
    private boolean containerHasClusters;
    private final Object mutex = new Object();
    private final Map<String, Boolean> clusterStatus = new HashMap<String, Boolean>();

    @Inject
    public ClustersStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusters(Set<String> clusters) {
        Object object = this.mutex;
        synchronized (object) {
            this.containerHasClusters = clusters.size() > 0;
            Iterator<String> i = this.clusterStatus.keySet().iterator();
            while (i.hasNext()) {
                String existingCluster = i.next();
                if (clusters.contains(existingCluster)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUp(String clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDown(String clusterIdentifier) {
        Object object = this.mutex;
        synchronized (object) {
            this.clusterStatus.put(clusterIdentifier, Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerShouldReceiveTraffic(Require require) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.containerHasClusters) {
                switch (require) {
                    case ONE: {
                        return this.clusterStatus.values().stream().anyMatch(status -> status == true);
                    }
                }
                return !this.clusterStatus.isEmpty() && this.clusterStatus.values().stream().allMatch(status -> status == true);
            }
            return true;
        }
    }

    public static enum Require {
        ONE,
        ALL;

    }
}

