/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.http.filter;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilterChain;
import com.yahoo.jdisc.http.filter.SecurityResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityResponseFilterChain;
import com.yahoo.jdisc.http.filter.chain.RequestFilterChain;
import com.yahoo.jdisc.http.filter.chain.ResponseFilterChain;
import com.yahoo.processing.execution.chain.ChainRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FilterChainRepository
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(FilterChainRepository.class.getName());
    private final ComponentRegistry<Object> filterAndChains;

    public FilterChainRepository(ChainsConfig chainsConfig, ComponentRegistry<RequestFilter> requestFilters, ComponentRegistry<ResponseFilter> responseFilters, ComponentRegistry<SecurityRequestFilter> securityRequestFilters, ComponentRegistry<SecurityResponseFilter> securityResponseFilters) {
        ComponentRegistry filterAndChains = new ComponentRegistry();
        FilterChainRepository.addAllFilters((ComponentRegistry<Object>)filterAndChains, requestFilters, responseFilters, securityRequestFilters, securityResponseFilters);
        FilterChainRepository.addAllChains((ComponentRegistry<Object>)filterAndChains, chainsConfig, requestFilters, responseFilters, securityRequestFilters, securityResponseFilters);
        filterAndChains.freeze();
        this.filterAndChains = filterAndChains;
    }

    public Object getFilter(ComponentSpecification componentSpecification) {
        return this.filterAndChains.getComponent(componentSpecification);
    }

    private static void addAllFilters(ComponentRegistry<Object> destination, ComponentRegistry<?> ... registries) {
        for (ComponentRegistry<?> registry : registries) {
            registry.allComponentsById().forEach((id, filter) -> destination.register(id, FilterChainRepository.wrapIfSecurityFilter(filter)));
        }
    }

    private static void addAllChains(ComponentRegistry<Object> destination, ChainsConfig chainsConfig, ComponentRegistry<?> ... filters) {
        ChainRegistry<FilterWrapper> chainRegistry = FilterChainRepository.buildChainRegistry(chainsConfig, filters);
        chainRegistry.allComponents().forEach(chain -> destination.register(chain.getId(), FilterChainRepository.toJDiscChain(chain)));
    }

    private static ChainRegistry<FilterWrapper> buildChainRegistry(ChainsConfig chainsConfig, ComponentRegistry<?> ... filters) {
        ChainRegistry<FilterWrapper> chainRegistry = new ChainRegistry<FilterWrapper>();
        ChainsModel chainsModel = ChainsModelBuilder.buildFromConfig(chainsConfig);
        ChainsConfigurer.prepareChainRegistry(chainRegistry, chainsModel, FilterChainRepository.allFiltersWrapped(filters));
        FilterChainRepository.removeEmptyChains(chainRegistry);
        chainRegistry.freeze();
        return chainRegistry;
    }

    private static void removeEmptyChains(ChainRegistry<FilterWrapper> chainRegistry) {
        chainRegistry.allComponents().stream().filter(chain -> chain.components().isEmpty()).map(Chain::getId).peek(id -> log.warning("Removing empty filter chain: " + id)).forEach(arg_0 -> chainRegistry.unregister(arg_0));
    }

    private static Object toJDiscChain(Chain<FilterWrapper> chain) {
        if (chain.components().isEmpty()) {
            throw new IllegalArgumentException("Empty filter chain: " + chain.getId());
        }
        FilterChainRepository.checkFilterTypesCompatible(chain);
        List<Object> jdiscFilters = chain.components().stream().map(filterWrapper -> filterWrapper.filter).toList();
        List<?> wrappedFilters = FilterChainRepository.wrapSecurityFilters(jdiscFilters);
        Object head = wrappedFilters.get(0);
        if (wrappedFilters.size() == 1) {
            return head;
        }
        if (head instanceof RequestFilter) {
            return RequestFilterChain.newInstance(wrappedFilters);
        }
        if (head instanceof ResponseFilter) {
            return ResponseFilterChain.newInstance(wrappedFilters);
        }
        throw new IllegalStateException();
    }

    private static List<?> wrapSecurityFilters(List<?> filters) {
        ArrayList aggregatedSecurityFilters = new ArrayList();
        ArrayList<Object> wrappedFilters = new ArrayList<Object>();
        for (Object filter : filters) {
            if (FilterChainRepository.isSecurityFilter(filter)) {
                aggregatedSecurityFilters.add(filter);
                continue;
            }
            if (!aggregatedSecurityFilters.isEmpty()) {
                wrappedFilters.add(FilterChainRepository.createSecurityChain(aggregatedSecurityFilters));
                aggregatedSecurityFilters.clear();
            }
            wrappedFilters.add(filter);
        }
        if (!aggregatedSecurityFilters.isEmpty()) {
            wrappedFilters.add(FilterChainRepository.createSecurityChain(aggregatedSecurityFilters));
        }
        return wrappedFilters;
    }

    private static void checkFilterTypesCompatible(Chain<FilterWrapper> chain) {
        Set requestFilters = chain.components().stream().filter(filter -> filter instanceof RequestFilter || filter instanceof SecurityRequestFilter).map(AbstractComponent::getId).collect(Collectors.toSet());
        Set responseFilters = chain.components().stream().filter(filter -> filter instanceof ResponseFilter || filter instanceof SecurityResponseFilter).map(AbstractComponent::getId).collect(Collectors.toSet());
        if (!requestFilters.isEmpty() && !responseFilters.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't mix request and response filters in chain %s: request filters: %s, response filters: %s.", chain.getId(), requestFilters, responseFilters));
        }
    }

    private static ComponentRegistry<FilterWrapper> allFiltersWrapped(ComponentRegistry<?> ... registries) {
        ComponentRegistry wrappedFilters = new ComponentRegistry();
        for (ComponentRegistry<?> registry : registries) {
            registry.allComponentsById().forEach((id, filter) -> wrappedFilters.register(id, (Object)new FilterWrapper((ComponentId)id, filter)));
        }
        wrappedFilters.freeze();
        return wrappedFilters;
    }

    private static Object wrapIfSecurityFilter(Object filter) {
        if (FilterChainRepository.isSecurityFilter(filter)) {
            return FilterChainRepository.createSecurityChain(Collections.singletonList(filter));
        }
        return filter;
    }

    private static Object createSecurityChain(List<?> filters) {
        Object head = filters.get(0);
        if (head instanceof SecurityRequestFilter) {
            return SecurityRequestFilterChain.newInstance(filters);
        }
        if (head instanceof SecurityResponseFilter) {
            return SecurityResponseFilterChain.newInstance(filters);
        }
        throw new IllegalArgumentException("Unexpected class " + head.getClass());
    }

    private static boolean isSecurityFilter(Object filter) {
        return filter instanceof SecurityRequestFilter || filter instanceof SecurityResponseFilter;
    }

    private static class FilterWrapper
    extends ChainedComponent {
        public final Object filter;
        public final Class<?> filterType;

        public FilterWrapper(ComponentId id, Object filter) {
            super(id);
            this.filter = filter;
            this.filterType = FilterWrapper.getFilterType(filter);
        }

        private static Class<?> getFilterType(Object filter) {
            if (filter instanceof RequestFilter) {
                return RequestFilter.class;
            }
            if (filter instanceof ResponseFilter) {
                return ResponseFilter.class;
            }
            if (filter instanceof SecurityRequestFilter) {
                return SecurityRequestFilter.class;
            }
            if (filter instanceof SecurityResponseFilter) {
                return SecurityResponseFilter.class;
            }
            throw new IllegalArgumentException("Unsupported filter type: " + filter.getClass().getName());
        }
    }
}

