/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.dependencies.ordering;

import com.yahoo.component.chain.dependencies.ordering.OrderedReadyNodes;
import java.util.HashSet;
import java.util.Set;

abstract class Node {
    final int priority;
    private int numNodesBeforeThis = 0;
    Set<Node> nodesAfterThis = new HashSet<Node>();

    public Node(int priority) {
        this.priority = priority;
    }

    protected void before(Node node) {
        if (this.nodesAfterThis.add(node)) {
            node.notifyAfter();
        }
    }

    void notifyAfter() {
        ++this.numNodesBeforeThis;
    }

    void removed(OrderedReadyNodes readyNodes) {
        this.handleRemoved(readyNodes);
        for (Node node : this.nodesAfterThis) {
            node.beforeRemoved(readyNodes);
        }
    }

    void beforeRemoved(OrderedReadyNodes readyNodes) {
        --this.numNodesBeforeThis;
        if (this.ready()) {
            readyNodes.add(this);
        }
    }

    boolean ready() {
        return this.numNodesBeforeThis == 0;
    }

    protected void handleRemoved(OrderedReadyNodes readyNodes) {
    }

    void dotDependenciesString(StringBuilder s, Set<Node> used) {
        if (used.contains(this)) {
            return;
        }
        used.add(this);
        for (Node afterNode : this.nodesAfterThis) {
            String indent = "    ";
            s.append(indent);
            s.append(this.dotName()).append(" -> ").append(afterNode.dotName()).append('\n');
            afterNode.dotDependenciesString(s, used);
        }
    }

    protected abstract String dotName();

    abstract int classPriority();
}

