/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpResponse;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlerUtils;
import com.yahoo.jdisc.http.server.jetty.ErrorResponseContentCreator;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.ServletOutputStreamWriter;
import com.yahoo.jdisc.service.BindingSetNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;

class ServletResponseController {
    private static final Logger log = Logger.getLogger(ServletResponseController.class.getName());
    private final Object monitor = new Object();
    private final HttpServletRequest servletRequest;
    private final HttpServletResponse servletResponse;
    private final boolean developerMode;
    private final ErrorResponseContentCreator errorResponseContentCreator = new ErrorResponseContentCreator();
    private final ServletOutputStreamWriter out;
    private State state = State.WAITING_FOR_RESPONSE;
    private Response handlerResponse;
    private final ResponseHandler responseHandler = new ResponseHandler(){

        public ContentChannel handleResponse(Response response) {
            ServletResponseController.this.acceptResponseFromHandler(response);
            return ServletResponseController.this.responseContentChannel;
        }
    };
    private final ContentChannel responseContentChannel = new ContentChannel(){

        public void write(ByteBuffer buf, CompletionHandler handler) {
            ServletResponseController.this.commitResponseFromHandlerIfUncommitted(false);
            ServletResponseController.this.out.writeBuffer(buf, this.handlerOrNoopHandler(handler));
        }

        public void close(CompletionHandler handler) {
            ServletResponseController.this.commitResponseFromHandlerIfUncommitted(true);
            ServletResponseController.this.out.close(this.handlerOrNoopHandler(handler));
        }

        private CompletionHandler handlerOrNoopHandler(CompletionHandler handler) {
            return handler != null ? handler : CompletionHandlerUtils.NOOP_COMPLETION_HANDLER;
        }
    };

    ServletResponseController(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Janitor janitor, RequestMetricReporter metricReporter, boolean developerMode) throws IOException {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.developerMode = developerMode;
        this.out = new ServletOutputStreamWriter(servletResponse.getOutputStream(), janitor, metricReporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void trySendErrorResponse(Throwable t) {
        Object object = this.monitor;
        synchronized (object) {
            block14: {
                block13: {
                    try {
                        switch (this.state) {
                            case WAITING_FOR_RESPONSE: 
                            case ACCEPTED_RESPONSE_FROM_HANDLER: {
                                this.state = State.COMPLETED_WITH_ERROR_RESPONSE;
                                break;
                            }
                            case COMMITTED_RESPONSE_FROM_HANDLER: 
                            case COMPLETED_WITH_RESPONSE_FROM_HANDLER: {
                                if (!log.isLoggable(Level.FINE)) return;
                                RuntimeException exceptionWithStackTrace = new RuntimeException(t);
                                log.log(Level.FINE, "Response already committed, can't change response code", exceptionWithStackTrace);
                                return;
                            }
                            case COMPLETED_WITH_ERROR_RESPONSE: {
                                break block13;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        this.writeErrorResponse(t);
                        break block14;
                    }
                    catch (Throwable suppressed) {
                        t.addSuppressed(suppressed);
                        break block14;
                    }
                }
                return;
                finally {
                    this.out.close();
                }
            }
            return;
        }
    }

    void forceClose(Throwable t) {
        this.out.fail(t);
    }

    CompletableFuture<Void> finishedFuture() {
        return this.out.finishedFuture();
    }

    ResponseHandler responseHandler() {
        return this.responseHandler;
    }

    private void writeErrorResponse(Throwable t) {
        this.servletResponse.setHeader("Expires", null);
        this.servletResponse.setHeader("Last-Modified", null);
        this.servletResponse.setHeader("Cache-Control", null);
        this.servletResponse.setHeader("Content-Type", null);
        this.servletResponse.setHeader("Content-Length", null);
        String reasonPhrase = ServletResponseController.getReasonPhrase(t, this.developerMode);
        int statusCode = ServletResponseController.getStatusCode(t);
        ServletResponseController.setStatus(this.servletResponse, statusCode, reasonPhrase);
        if (statusCode != 204 && statusCode != 304 && statusCode != 206 && statusCode >= 200) {
            this.servletResponse.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            this.servletResponse.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.toString());
            byte[] errorContent = this.errorResponseContentCreator.createErrorContent(this.servletRequest.getRequestURI(), statusCode, reasonPhrase);
            this.servletResponse.setContentLength(errorContent.length);
            this.out.writeBuffer(ByteBuffer.wrap(errorContent), CompletionHandlerUtils.NOOP_COMPLETION_HANDLER);
        } else {
            this.servletResponse.setContentLength(0);
        }
    }

    private static int getStatusCode(Throwable t) {
        if (t instanceof BindingNotFoundException) {
            return 404;
        }
        if (t instanceof BindingSetNotFoundException) {
            return 404;
        }
        if (t instanceof RequestException) {
            return ((RequestException)t).getResponseStatus();
        }
        if (t instanceof TimeoutException) {
            return 503;
        }
        return 500;
    }

    private static String getReasonPhrase(Throwable t, boolean developerMode) {
        if (developerMode) {
            StringWriter out = new StringWriter();
            t.printStackTrace(new PrintWriter(out));
            return out.toString();
        }
        if (t.getMessage() != null) {
            return t.getMessage();
        }
        return t.toString();
    }

    private void acceptResponseFromHandler(Response response) {
        Object object = this.monitor;
        synchronized (object) {
            switch (this.state) {
                case WAITING_FOR_RESPONSE: 
                case ACCEPTED_RESPONSE_FROM_HANDLER: {
                    this.handlerResponse = response;
                    this.state = State.ACCEPTED_RESPONSE_FROM_HANDLER;
                    this.servletRequest.setAttribute("requestType", (Object)this.handlerResponse.getRequestType());
                    return;
                }
                case COMMITTED_RESPONSE_FROM_HANDLER: 
                case COMPLETED_WITH_RESPONSE_FROM_HANDLER: {
                    String message = "Response already committed, can't change response code. From: " + this.servletResponse.getStatus() + ", To: " + response.getStatus();
                    log.log(Level.FINE, message, response.getError());
                    throw new IllegalStateException(message);
                }
                case COMPLETED_WITH_ERROR_RESPONSE: {
                    log.log(Level.FINE, "Error response already written");
                    return;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static void setStatus(HttpServletResponse response, int statusCode, String reasonPhrase) {
        org.eclipse.jetty.server.Response jettyResponse = (org.eclipse.jetty.server.Response)response;
        if (reasonPhrase != null) {
            jettyResponse.setStatusWithReason(statusCode, reasonPhrase);
        } else {
            jettyResponse.setStatus(statusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResponseFromHandlerIfUncommitted(boolean close) {
        Object object = this.monitor;
        synchronized (object) {
            switch (this.state) {
                case ACCEPTED_RESPONSE_FROM_HANDLER: {
                    this.state = close ? State.COMPLETED_WITH_RESPONSE_FROM_HANDLER : State.COMMITTED_RESPONSE_FROM_HANDLER;
                    break;
                }
                case WAITING_FOR_RESPONSE: {
                    throw new IllegalStateException("No response provided");
                }
                case COMMITTED_RESPONSE_FROM_HANDLER: 
                case COMPLETED_WITH_RESPONSE_FROM_HANDLER: {
                    return;
                }
                case COMPLETED_WITH_ERROR_RESPONSE: {
                    log.fine("An error response is already committed - failure will be handled by ServletOutputStreamWriter");
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.handlerResponse instanceof HttpResponse) {
                ServletResponseController.setStatus(this.servletResponse, this.handlerResponse.getStatus(), ((HttpResponse)this.handlerResponse).getMessage());
            } else {
                String message = Optional.ofNullable(this.handlerResponse.getError()).flatMap(error -> Optional.ofNullable(error.getMessage())).orElse(null);
                ServletResponseController.setStatus(this.servletResponse, this.handlerResponse.getStatus(), message);
            }
            for (Map.Entry entry : this.handlerResponse.headers().entries()) {
                this.servletResponse.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.servletResponse.getContentType() == null) {
                this.servletResponse.setContentType("text/plain;charset=utf-8");
            }
        }
    }

    private static enum State {
        WAITING_FOR_RESPONSE,
        ACCEPTED_RESPONSE_FROM_HANDLER,
        COMMITTED_RESPONSE_FROM_HANDLER,
        COMPLETED_WITH_RESPONSE_FROM_HANDLER,
        COMPLETED_WITH_ERROR_RESPONSE;

    }
}

