/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.component.AbstractComponent;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.X509CertificateWithKey;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;

public class DataplaneProxyCredentials
extends AbstractComponent {
    private final Path certificateFile = Paths.get(Defaults.getDefaults().underVespaHome("tmp/proxy_cert.pem"), new String[0]);
    private final Path keyFile = Paths.get(Defaults.getDefaults().underVespaHome("tmp/proxy_key.pem"), new String[0]);

    public DataplaneProxyCredentials() {
        if (this.regenerateCredentials(this.certificateFile, this.keyFile)) {
            X509CertificateWithKey selfSigned = X509CertificateUtils.createSelfSigned((String)"cn=vespa dataplane proxy", (Duration)Duration.ofDays(30L));
            Exceptions.uncheck(() -> Files.writeString(this.certificateFile, (CharSequence)X509CertificateUtils.toPem((X509Certificate)selfSigned.certificate()), new OpenOption[0]));
            Exceptions.uncheck(() -> Files.writeString(this.keyFile, (CharSequence)KeyUtils.toPem((PrivateKey)selfSigned.privateKey()), new OpenOption[0]));
        }
    }

    private boolean regenerateCredentials(Path certificateFile, Path keyFile) {
        if (!Files.exists(certificateFile, new LinkOption[0]) || !Files.exists(keyFile, new LinkOption[0])) {
            return true;
        }
        try {
            X509Certificate x509Certificate = X509CertificateUtils.fromPem((String)Files.readString(certificateFile));
            PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)Files.readString(keyFile));
            return !X509CertificateUtils.privateKeyMatchesPublicKey((PrivateKey)privateKey, (PublicKey)x509Certificate.getPublicKey());
        }
        catch (IOException e) {
            return true;
        }
    }

    public Path certificateFile() {
        return this.certificateFile;
    }

    public Path keyFile() {
        return this.keyFile;
    }

    public void deconstruct() {
        super.deconstruct();
    }
}

