/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.Vtag;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.container.jdisc.state.CountMetric;
import com.yahoo.container.jdisc.state.GaugeMetric;
import com.yahoo.container.jdisc.state.JsonUtil;
import com.yahoo.container.jdisc.state.MetricDimensions;
import com.yahoo.container.jdisc.state.MetricSet;
import com.yahoo.container.jdisc.state.MetricSnapshot;
import com.yahoo.container.jdisc.state.MetricValue;
import com.yahoo.container.jdisc.state.SnapshotProvider;
import com.yahoo.container.jdisc.state.StateMetricContext;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.container.jdisc.utils.CapabilityRequiringRequestHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.security.tls.Capability;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StateHandler
extends AbstractRequestHandler
implements CapabilityRequiringRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    public static final String STATE_API_ROOT = "/state/v1";
    private static final String METRICS_PATH = "metrics";
    private static final String HISTOGRAMS_PATH = "metrics/histograms";
    private static final String CONFIG_GENERATION_PATH = "config";
    private static final String HEALTH_PATH = "health";
    private static final String VERSION_PATH = "version";
    private static final MetricDimensions NULL_DIMENSIONS = StateMetricContext.newInstance(null);
    private final StateMonitor monitor;
    private final Timer timer;
    private final JsonNode config;
    private final SnapshotProvider snapshotProvider;

    @Inject
    public StateHandler(StateMonitor monitor, Timer timer, ApplicationMetadataConfig config, ComponentRegistry<SnapshotProvider> snapshotProviders) {
        this.monitor = monitor;
        this.timer = timer;
        this.config = StateHandler.buildConfigJson(config);
        this.snapshotProvider = StateHandler.getSnapshotProviderOrThrow(snapshotProviders);
    }

    @Override
    public Capability requiredCapability(RequestView __) {
        return Capability.CONTAINER__STATE_API;
    }

    static SnapshotProvider getSnapshotProviderOrThrow(ComponentRegistry<SnapshotProvider> preprocessors) {
        List allPreprocessors = preprocessors.allComponents();
        if (allPreprocessors.size() > 0) {
            return (SnapshotProvider)allPreprocessors.get(0);
        }
        throw new IllegalArgumentException("At least one snapshot provider is required.");
    }

    public ContentChannel handleRequest(final Request request, ResponseHandler handler) {
        final ArrayList<ByteBuffer> input = new ArrayList<ByteBuffer>();
        ResponseDispatch respDisp = new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", StateHandler.this.resolveContentType(request.getUri()));
                return response;
            }

            protected Iterable<ByteBuffer> responseContent() {
                return Collections.singleton(StateHandler.this.buildContent(request.getUri(), input));
            }
        };
        return new MyContentChannel(input, () -> StateHandler.lambda$handleRequest$0(respDisp, handler));
    }

    private String resolveContentType(URI requestUri) {
        if (StateHandler.resolvePath(requestUri).equals(HISTOGRAMS_PATH)) {
            return "text/plain; charset=utf-8";
        }
        return "application/json";
    }

    private ByteBuffer buildContent(URI requestUri, List<ByteBuffer> input) {
        try {
            String suffix;
            return switch (suffix = StateHandler.resolvePath(requestUri)) {
                case "" -> ByteBuffer.wrap(this.apiLinks(requestUri));
                case CONFIG_GENERATION_PATH -> ByteBuffer.wrap(StateHandler.toPrettyString(this.config));
                case HISTOGRAMS_PATH -> ByteBuffer.wrap(this.buildHistogramsOutput());
                case HEALTH_PATH, METRICS_PATH -> ByteBuffer.wrap(this.buildMetricOutput(suffix));
                case VERSION_PATH -> ByteBuffer.wrap(StateHandler.buildVersionOutput());
                default -> ByteBuffer.wrap(this.buildMetricOutput(suffix));
            };
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Bad JSON construction", e);
        }
    }

    private byte[] apiLinks(URI requestUri) throws JsonProcessingException {
        int port = requestUri.getPort();
        String host = requestUri.getHost();
        StringBuilder base = new StringBuilder("http://");
        base.append(host);
        if (port != -1) {
            base.append(":").append(port);
        }
        base.append(STATE_API_ROOT);
        String uriBase = base.toString();
        ArrayNode linkList = jsonMapper.createArrayNode();
        for (String api : new String[]{METRICS_PATH, CONFIG_GENERATION_PATH, HEALTH_PATH, VERSION_PATH}) {
            ObjectNode resource = jsonMapper.createObjectNode();
            resource.put("url", uriBase + "/" + api);
            linkList.add((JsonNode)resource);
        }
        JsonNode resources = jsonMapper.createObjectNode().set("resources", (JsonNode)linkList);
        return StateHandler.toPrettyString(resources);
    }

    private static String resolvePath(URI uri) {
        String path = uri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith(STATE_API_ROOT)) {
            path = path.substring(STATE_API_ROOT.length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static JsonNode buildConfigJson(ApplicationMetadataConfig config) {
        return jsonMapper.createObjectNode().set(CONFIG_GENERATION_PATH, jsonMapper.createObjectNode().put("generation", config.generation()).set("container", (JsonNode)jsonMapper.createObjectNode().put("generation", config.generation())));
    }

    private static byte[] buildVersionOutput() throws JsonProcessingException {
        return StateHandler.toPrettyString((JsonNode)jsonMapper.createObjectNode().put(VERSION_PATH, Vtag.currentVersion.toString()));
    }

    private byte[] buildMetricOutput(String consumer) throws JsonProcessingException {
        return StateHandler.toPrettyString((JsonNode)this.buildJsonForConsumer(consumer));
    }

    private byte[] buildHistogramsOutput() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.snapshotProvider != null) {
            this.snapshotProvider.histogram(new PrintStream(baos));
        }
        return baos.toByteArray();
    }

    private ObjectNode buildJsonForConsumer(String consumer) {
        ObjectNode ret = jsonMapper.createObjectNode();
        ret.put("time", this.timer.currentTimeMillis());
        ret.set("status", (JsonNode)jsonMapper.createObjectNode().put("code", this.getStatus().name()));
        ret.set(METRICS_PATH, (JsonNode)this.buildJsonForSnapshot(consumer, this.getSnapshot()));
        return ret;
    }

    private MetricSnapshot getSnapshot() {
        return this.snapshotProvider.latestSnapshot();
    }

    private StateMonitor.Status getStatus() {
        return this.monitor.status();
    }

    private ObjectNode buildJsonForSnapshot(String consumer, MetricSnapshot metricSnapshot) {
        if (metricSnapshot == null) {
            return jsonMapper.createObjectNode();
        }
        ObjectNode jsonMetric = jsonMapper.createObjectNode();
        jsonMetric.set("snapshot", (JsonNode)jsonMapper.createObjectNode().put("from", JsonUtil.sanitizeDouble((double)metricSnapshot.getFromTime(TimeUnit.MILLISECONDS) / 1000.0)).put("to", JsonUtil.sanitizeDouble((double)metricSnapshot.getToTime(TimeUnit.MILLISECONDS) / 1000.0)));
        boolean includeDimensions = !consumer.equals(HEALTH_PATH);
        long periodInMillis = metricSnapshot.getToTime(TimeUnit.MILLISECONDS) - metricSnapshot.getFromTime(TimeUnit.MILLISECONDS);
        for (Tuple tuple : StateHandler.collapseMetrics(metricSnapshot, consumer)) {
            ArrayNode values;
            Iterator it;
            ObjectNode jsonTuple = jsonMapper.createObjectNode();
            jsonTuple.put("name", tuple.key);
            MetricValue metricValue = tuple.val;
            if (metricValue instanceof CountMetric) {
                CountMetric count = (CountMetric)metricValue;
                jsonTuple.set("values", (JsonNode)jsonMapper.createObjectNode().put("count", count.getCount()).put("rate", JsonUtil.sanitizeDouble((double)count.getCount() * 1000.0) / (double)periodInMillis));
            } else {
                metricValue = tuple.val;
                if (metricValue instanceof GaugeMetric) {
                    GaugeMetric gauge = (GaugeMetric)metricValue;
                    ObjectNode valueFields = jsonMapper.createObjectNode();
                    valueFields.put("average", JsonUtil.sanitizeDouble(gauge.getAverage())).put("sum", JsonUtil.sanitizeDouble(gauge.getSum())).put("count", gauge.getCount()).put("last", JsonUtil.sanitizeDouble(gauge.getLast())).put("max", JsonUtil.sanitizeDouble(gauge.getMax())).put("min", JsonUtil.sanitizeDouble(gauge.getMin())).put("rate", JsonUtil.sanitizeDouble((double)gauge.getCount() * 1000.0 / (double)periodInMillis));
                    if (gauge.getPercentiles().isPresent()) {
                        for (Tuple2<String, Double> prefixAndValue : gauge.getPercentiles().get()) {
                            valueFields.put((String)prefixAndValue.first + "percentile", JsonUtil.sanitizeDouble((Double)prefixAndValue.second));
                        }
                    }
                    jsonTuple.set("values", (JsonNode)valueFields);
                } else {
                    throw new UnsupportedOperationException(tuple.val.getClass().getName());
                }
            }
            if (tuple.dim != null && (it = tuple.dim.iterator()).hasNext() && includeDimensions) {
                ObjectNode jsonDim = jsonMapper.createObjectNode();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    jsonDim.put((String)entry.getKey(), (String)entry.getValue());
                }
                jsonTuple.set("dimensions", (JsonNode)jsonDim);
            }
            if ((values = (ArrayNode)jsonMetric.get("values")) == null) {
                values = jsonMapper.createArrayNode();
                jsonMetric.set("values", (JsonNode)values);
            }
            values.add((JsonNode)jsonTuple);
        }
        return jsonMetric;
    }

    private static List<Tuple> collapseMetrics(MetricSnapshot snapshot, String consumer) {
        return switch (consumer) {
            case HEALTH_PATH -> StateHandler.collapseHealthMetrics(snapshot);
            case "all", METRICS_PATH -> StateHandler.flattenAllMetrics(snapshot);
            default -> throw new IllegalArgumentException("Unknown consumer '" + consumer + "'.");
        };
    }

    private static List<Tuple> collapseHealthMetrics(MetricSnapshot snapshot) {
        Tuple requestsPerSecond = new Tuple(NULL_DIMENSIONS, "requestsPerSecond", null);
        Tuple latencySeconds = new Tuple(NULL_DIMENSIONS, "latencySeconds", null);
        for (Map.Entry<MetricDimensions, MetricSet> entry : snapshot) {
            MetricSet metricSet = entry.getValue();
            MetricValue val = metricSet.get("serverTotalSuccessfulResponseLatency");
            if (val instanceof GaugeMetric) {
                GaugeMetric gauge = (GaugeMetric)val;
                latencySeconds.add(GaugeMetric.newInstance(gauge.getLast() / 1000.0, gauge.getMax() / 1000.0, gauge.getMin() / 1000.0, gauge.getSum() / 1000.0, gauge.getCount()));
            }
            requestsPerSecond.add(metricSet.get("serverNumSuccessfulResponses"));
        }
        ArrayList<Tuple> lst = new ArrayList<Tuple>();
        if (requestsPerSecond.val != null) {
            lst.add(requestsPerSecond);
        }
        if (latencySeconds.val != null) {
            lst.add(latencySeconds);
        }
        return lst;
    }

    static List<Tuple> flattenAllMetrics(MetricSnapshot snapshot) {
        ArrayList<Tuple> metrics = new ArrayList<Tuple>();
        for (Map.Entry<MetricDimensions, MetricSet> snapshotEntry : snapshot) {
            for (Map.Entry<String, MetricValue> metricSetEntry : snapshotEntry.getValue()) {
                metrics.add(new Tuple(snapshotEntry.getKey(), metricSetEntry.getKey(), metricSetEntry.getValue()));
            }
        }
        return metrics;
    }

    private static byte[] toPrettyString(JsonNode resources) throws JsonProcessingException {
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resources).getBytes();
    }

    private static /* synthetic */ void lambda$handleRequest$0(1 respDisp, ResponseHandler handler) {
        respDisp.dispatch(handler);
    }

    private static class MyContentChannel
    implements ContentChannel {
        private final List<ByteBuffer> buffers;
        private final Runnable trigger;

        public void write(ByteBuffer buf, CompletionHandler handler) {
            this.buffers.add(buf);
            if (handler != null) {
                handler.completed();
            }
        }

        public void close(CompletionHandler handler) {
            this.trigger.run();
            if (handler != null) {
                handler.completed();
            }
        }

        MyContentChannel(List<ByteBuffer> buffers, Runnable trigger) {
            this.buffers = buffers;
            this.trigger = trigger;
        }
    }

    static class Tuple {
        final MetricDimensions dim;
        final String key;
        MetricValue val;

        Tuple(MetricDimensions dim, String key, MetricValue val) {
            this.dim = dim;
            this.key = key;
            this.val = val;
        }

        void add(MetricValue val) {
            if (val == null) {
                return;
            }
            if (this.val == null) {
                this.val = val;
            } else {
                this.val.add(val);
            }
        }
    }
}

