/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.handler.BindingNotFoundException;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.OverloadException;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.AccessLoggingRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FilteringRequestHandler;
import com.yahoo.jdisc.http.server.jetty.FormPostRequestHandler;
import com.yahoo.jdisc.http.server.jetty.HttpRequestFactory;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.http.server.jetty.ServletRequestReader;
import com.yahoo.jdisc.http.server.jetty.ServletResponseController;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpConnection;

class HttpRequestDispatch {
    private static final Logger log = Logger.getLogger(HttpRequestDispatch.class.getName());
    private static final String CHARSET_ANNOTATION = ";charset=";
    private final JDiscContext jDiscContext;
    private final org.eclipse.jetty.server.Request jettyRequest;
    private final ServletResponseController servletResponseController;
    private final RequestHandler requestHandler;
    private final RequestMetricReporter metricReporter;

    HttpRequestDispatch(JDiscContext jDiscContext, AccessLogEntry accessLogEntry, Metric.Context metricContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.jDiscContext = jDiscContext;
        this.requestHandler = HttpRequestDispatch.newRequestHandler(jDiscContext, accessLogEntry, servletRequest);
        this.jettyRequest = (org.eclipse.jetty.server.Request)servletRequest;
        this.metricReporter = new RequestMetricReporter(jDiscContext.metric, metricContext, this.jettyRequest.getTimeStamp());
        this.servletResponseController = new ServletResponseController(servletRequest, servletResponse, jDiscContext.janitor, this.metricReporter, jDiscContext.developerMode());
        HttpRequestDispatch.shutdownConnectionGracefullyIfThresholdReached(this.jettyRequest);
        this.metricReporter.uriLength(this.jettyRequest.getOriginalURI().length());
    }

    void dispatchRequest() {
        ServletRequestReader servletRequestReader;
        CompletableFuture<Void> requestCompletion = this.startServletAsyncExecution();
        try {
            servletRequestReader = this.handleRequest();
        }
        catch (Throwable t2) {
            this.servletResponseController.finishedFuture().whenComplete((__, ___) -> requestCompletion.completeExceptionally(t2));
            this.servletResponseController.trySendErrorResponse(t2);
            return;
        }
        servletRequestReader.finishedFuture().whenComplete((__, t) -> {
            if (t != null) {
                this.servletResponseController.trySendErrorResponse((Throwable)t);
            }
        });
        this.servletResponseController.finishedFuture().whenComplete((__, t) -> {
            if (t != null) {
                servletRequestReader.fail((Throwable)t);
            }
        });
        CompletableFuture.allOf(servletRequestReader.finishedFuture(), this.servletResponseController.finishedFuture()).whenComplete((r, t) -> {
            if (t != null) {
                requestCompletion.completeExceptionally((Throwable)t);
            } else {
                requestCompletion.complete(null);
            }
        });
        servletRequestReader.start();
    }

    private CompletableFuture<Void> startServletAsyncExecution() {
        final CompletableFuture<Void> requestCompletion = new CompletableFuture<Void>();
        AsyncContext asyncCtx = this.jettyRequest.startAsync();
        asyncCtx.setTimeout(0L);
        asyncCtx.addListener(new AsyncListener(){

            public void onStartAsync(AsyncEvent event) {
            }

            public void onComplete(AsyncEvent event) {
                requestCompletion.complete(null);
            }

            public void onTimeout(AsyncEvent event) {
                requestCompletion.completeExceptionally(new TimeoutException("Timeout from AsyncContext"));
            }

            public void onError(AsyncEvent event) {
                requestCompletion.completeExceptionally(event.getThrowable());
            }
        });
        requestCompletion.whenComplete((__, t) -> this.onRequestFinished(asyncCtx, (Throwable)t));
        return requestCompletion;
    }

    private void onRequestFinished(AsyncContext asyncCtx, Throwable error) {
        boolean reportedError = false;
        if (error != null) {
            this.servletResponseController.forceClose(error);
            if (HttpRequestDispatch.isErrorOfType(error, EofException.class, IOException.class)) {
                log.log(Level.FINE, error, () -> "Network connection was unexpectedly terminated: " + this.jettyRequest.getRequestURI());
                this.metricReporter.prematurelyClosed();
            } else if (HttpRequestDispatch.isErrorOfType(error, TimeoutException.class)) {
                log.log(Level.FINE, error, () -> "Request/stream was timed out by Jetty: " + this.jettyRequest.getRequestURI());
            } else if (!HttpRequestDispatch.isErrorOfType(error, OverloadException.class, BindingNotFoundException.class, RequestException.class)) {
                log.log(Level.WARNING, "Request failed: " + this.jettyRequest.getRequestURI(), error);
            }
            reportedError = true;
            this.metricReporter.failedResponse();
        } else {
            this.metricReporter.successfulResponse();
        }
        try {
            asyncCtx.complete();
            log.finest(() -> "Request completed successfully: " + this.jettyRequest.getRequestURI());
        }
        catch (Throwable throwable) {
            Level level = reportedError ? Level.FINE : Level.WARNING;
            log.log(level, "Async.complete failed", throwable);
        }
    }

    private static void shutdownConnectionGracefullyIfThresholdReached(org.eclipse.jetty.server.Request request) {
        double maxConnectionLifeInSeconds;
        ConnectorConfig connectorConfig = RequestUtils.getConnector(request).connectorConfig();
        int maxRequestsPerConnection = connectorConfig.maxRequestsPerConnection();
        Connection connection = RequestUtils.getConnection(request);
        if (maxRequestsPerConnection > 0 && connection.getMessagesIn() >= (long)maxRequestsPerConnection) {
            HttpRequestDispatch.gracefulShutdown(connection);
        }
        if ((maxConnectionLifeInSeconds = connectorConfig.maxConnectionLife()) > 0.0) {
            long createdAt = connection.getCreatedTimeStamp();
            long tenPctVariance = connection.hashCode() % 10;
            Instant expiredAt = Instant.ofEpochMilli((long)((double)createdAt + maxConnectionLifeInSeconds * 10.0 * (double)(100L - tenPctVariance)));
            boolean isExpired = Instant.now().isAfter(expiredAt);
            if (isExpired) {
                HttpRequestDispatch.gracefulShutdown(connection);
            }
        }
    }

    private static void gracefulShutdown(Connection connection) {
        if (connection instanceof HttpConnection) {
            HttpConnection http1 = (HttpConnection)connection;
            http1.getGenerator().setPersistent(false);
        } else if (connection instanceof HTTP2ServerConnection) {
            HTTP2ServerConnection http2 = (HTTP2ServerConnection)connection;
            http2.getSession().shutdown();
        }
    }

    @SafeVarargs
    private static boolean isErrorOfType(Throwable throwable, Class<? extends Throwable> ... handledTypes) {
        return Arrays.stream(handledTypes).anyMatch(exceptionType -> exceptionType.isInstance(throwable) || throwable instanceof CompletionException && exceptionType.isInstance(throwable.getCause()));
    }

    private ServletRequestReader handleRequest() throws IOException {
        ContentChannel requestContentChannel;
        HttpRequest jdiscRequest = HttpRequestFactory.newJDiscRequest(this.jDiscContext.container, (HttpServletRequest)this.jettyRequest);
        try (ResourceReference ref = References.fromResource((SharedResource)jdiscRequest);){
            HttpRequestFactory.copyHeaders((HttpServletRequest)this.jettyRequest, jdiscRequest);
            requestContentChannel = this.requestHandler.handleRequest((Request)jdiscRequest, this.servletResponseController.responseHandler());
        }
        return new ServletRequestReader((HttpServletRequest)this.jettyRequest, requestContentChannel, this.jDiscContext.janitor, this.metricReporter);
    }

    private static RequestHandler newRequestHandler(JDiscContext context, AccessLogEntry accessLogEntry, HttpServletRequest servletRequest) {
        RequestHandler requestHandler = HttpRequestDispatch.wrapHandlerIfFormPost((RequestHandler)new FilteringRequestHandler(context.filterResolver, (org.eclipse.jetty.server.Request)servletRequest), servletRequest, context.serverConfig.removeRawPostBodyForWwwUrlEncodedPost());
        return new AccessLoggingRequestHandler(requestHandler, accessLogEntry);
    }

    private static RequestHandler wrapHandlerIfFormPost(RequestHandler requestHandler, HttpServletRequest servletRequest, boolean removeBodyForFormPost) {
        if (!servletRequest.getMethod().equals("POST")) {
            return requestHandler;
        }
        String contentType = servletRequest.getHeader("Content-Type");
        if (contentType == null) {
            return requestHandler;
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded")) {
            return requestHandler;
        }
        return new FormPostRequestHandler(requestHandler, HttpRequestDispatch.getCharsetName(contentType), removeBodyForFormPost);
    }

    private static String getCharsetName(String contentType) {
        if (!contentType.startsWith(CHARSET_ANNOTATION, "application/x-www-form-urlencoded".length())) {
            return StandardCharsets.UTF_8.name();
        }
        return contentType.substring("application/x-www-form-urlencoded".length() + CHARSET_ANNOTATION.length());
    }
}

