/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.util;

import com.yahoo.jdisc.Container;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.DiscFilterRequest;
import com.yahoo.jdisc.service.CurrentContainer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FilterTestUtils {
    private FilterTestUtils() {
    }

    public static RequestBuilder newRequestBuilder() {
        return new RequestBuilder();
    }

    public static class RequestBuilder {
        private URI uri = URI.create("https://localhost:443/");
        private HttpRequest.Method method = HttpRequest.Method.GET;
        private Clock clock = Clock.systemUTC();
        private Principal principal;
        private final Map<String, Object> attributes = new TreeMap<String, Object>();
        private List<X509Certificate> certificates = List.of();
        private final Map<String, String> headers = new TreeMap<String, String>();
        private HttpRequest.Version version = HttpRequest.Version.HTTP_1_1;
        private SocketAddress remoteAddress;
        private final List<Cookie> cookies = new ArrayList<Cookie>();

        private RequestBuilder() {
        }

        public RequestBuilder withUri(String uri) {
            return this.withUri(URI.create(uri));
        }

        public RequestBuilder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public RequestBuilder withMethod(String method) {
            return this.withMethod(HttpRequest.Method.valueOf(method));
        }

        public RequestBuilder withMethod(HttpRequest.Method method) {
            this.method = method;
            return this;
        }

        public RequestBuilder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public RequestBuilder withPrincipal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public RequestBuilder withAttribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        public RequestBuilder withClientCertificate(X509Certificate cert) {
            return this.withClientCertificate(List.of(cert));
        }

        public RequestBuilder withClientCertificate(List<X509Certificate> certs) {
            this.certificates = List.copyOf(certs);
            return this;
        }

        public RequestBuilder withHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public RequestBuilder withHttpVersion(HttpRequest.Version version) {
            this.version = version;
            return this;
        }

        public RequestBuilder withRemoteAddress(String host, int port) {
            return this.withRemoteAddress(new InetSocketAddress(host, port));
        }

        public RequestBuilder withRemoteAddress(SocketAddress address) {
            this.remoteAddress = address;
            return this;
        }

        public RequestBuilder withCookie(String cookie) {
            this.cookies.addAll(Cookie.fromCookieHeader(cookie));
            return this;
        }

        public RequestBuilder withCookie(Cookie cookie) {
            this.cookies.add(cookie);
            return this;
        }

        public DiscFilterRequest build() {
            HttpRequest httpReq = HttpRequest.newServerRequest(new DummyContainer(this.clock), this.uri, this.method, this.version, this.remoteAddress, this.clock.millis(), this.clock.millis());
            DiscFilterRequest filterReq = new DiscFilterRequest(httpReq);
            filterReq.setUserPrincipal(this.principal);
            this.attributes.forEach(filterReq::setAttribute);
            filterReq.setAttribute("jdisc.request.X509Certificate", this.certificates.toArray(X509Certificate[]::new));
            this.headers.forEach(filterReq::addHeader);
            filterReq.setCookies(this.cookies);
            return filterReq;
        }
    }

    private record DummyContainer(Clock clock) implements CurrentContainer,
    Container,
    RequestHandler
    {
        public RequestHandler resolveHandler(Request request) {
            return this;
        }

        public <T> T getInstance(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        public void release() {
        }

        public long currentTimeMillis() {
            return this.clock.millis();
        }

        public ContentChannel handleRequest(Request request, ResponseHandler handler) {
            throw new UnsupportedOperationException();
        }

        public void handleTimeout(Request request, ResponseHandler handler) {
            throw new UnsupportedOperationException();
        }

        public Container newReference(URI uri, Object context) {
            return this;
        }

        public Container newReference(URI uri) {
            return this;
        }

        public ResourceReference refer(Object context) {
            return References.NOOP_REFERENCE;
        }

        public ResourceReference refer() {
            return References.NOOP_REFERENCE;
        }

        public Instant currentTime() {
            return this.clock.instant();
        }
    }
}

