/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.text.Lowercase;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompoundName {
    private final String name;
    private final String lowerCasedName;
    private final List<String> compounds;
    private final int hashCode;
    private final CompoundName rest;
    private final CompoundName first;
    public static final CompoundName empty = new CompoundName("");
    private static final Map<String, CompoundName> cache = new CopyOnWriteHashMap();
    private static final int MAX_CACHE_SIZE = 10000;

    public CompoundName(String name) {
        this(name, CompoundName.parse(name).toArray(new String[1]));
    }

    public static CompoundName fromComponents(String ... components) {
        return new CompoundName(List.of(components));
    }

    public CompoundName(List<String> compounds) {
        this(compounds.toArray(new String[0]));
    }

    private CompoundName(String[] compounds) {
        this(CompoundName.toCompoundString(compounds), compounds);
    }

    private CompoundName(String name, String[] compounds) {
        if (name == null) {
            throw new NullPointerException("Name can not be null");
        }
        this.name = name;
        this.lowerCasedName = Lowercase.toLowerCase((String)name);
        if (compounds.length == 1 && compounds[0].isEmpty()) {
            this.compounds = List.of();
            this.hashCode = 0;
            this.rest = this;
            this.first = this;
            return;
        }
        this.compounds = new ImmutableArrayList(compounds);
        this.hashCode = this.compounds.hashCode();
        this.rest = compounds.length > 1 ? new CompoundName(name.substring(compounds[0].length() + 1), Arrays.copyOfRange(compounds, 1, compounds.length)) : empty;
        this.first = compounds.length > 1 ? new CompoundName(name.substring(0, name.length() - (compounds[compounds.length - 1].length() + 1)), Arrays.copyOfRange(compounds, 0, compounds.length - 1)) : empty;
    }

    private static List<String> parse(String s) {
        ArrayList<String> l = null;
        int p = 0;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            if (s.charAt(i) != '.') continue;
            if (l == null) {
                l = new ArrayList<String>(8);
            }
            l.add(s.substring(p, i));
            p = i + 1;
        }
        if (p == 0) {
            if (l == null) {
                return List.of(s);
            }
            l.add(s);
        } else if (p < m) {
            l.add(s.substring(p, m));
        } else {
            throw new IllegalArgumentException("'" + s + "' is not a legal compound name. Names can not end with a dot.");
        }
        return l;
    }

    public CompoundName append(String name) {
        if (name.isEmpty()) {
            return this;
        }
        return this.append(new CompoundName(name));
    }

    public CompoundName append(CompoundName name) {
        if (name.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return name;
        }
        String[] newCompounds = new String[this.compounds.size() + name.compounds.size()];
        int count = 0;
        for (String s : this.compounds) {
            newCompounds[count++] = s;
        }
        for (String s : name.compounds) {
            newCompounds[count++] = s;
        }
        return new CompoundName(CompoundName.concat(this.name, name.name), newCompounds);
    }

    private static String concat(String name1, String name2) {
        return name1 + "." + name2;
    }

    public CompoundName prepend(String ... nameParts) {
        if (nameParts.length == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return CompoundName.fromComponents(nameParts);
        }
        ArrayList<String> newCompounds = new ArrayList<String>(nameParts.length + this.compounds.size());
        newCompounds.addAll(Arrays.asList(nameParts));
        newCompounds.addAll(this.compounds);
        return new CompoundName(newCompounds);
    }

    public String last() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return this.compounds.get(this.compounds.size() - 1);
    }

    public String first() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return this.compounds.get(0);
    }

    public CompoundName first(int n) {
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the first " + n + " components but '" + this + "' only have " + this.compounds.size() + " components.");
        }
        if (this.compounds.size() == n) {
            return this;
        }
        if (this.compounds.size() == 0) {
            return empty;
        }
        if (this.compounds.size() - 1 == n) {
            return this.first;
        }
        return this.first.first(n);
    }

    public CompoundName rest() {
        return this.rest;
    }

    public CompoundName rest(int n) {
        if (n == 0) {
            return this;
        }
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the rest after " + n + " components but '" + this + "' only have " + this.compounds.size() + " components.");
        }
        if (n == 1) {
            return this.rest();
        }
        if (this.compounds.size() == n) {
            return empty;
        }
        return this.rest.rest(n - 1);
    }

    public int size() {
        return this.compounds.size();
    }

    public String get(int i) {
        return this.compounds.get(i);
    }

    public CompoundName set(int i, String name) {
        if (this.get(i).equals(name)) {
            return this;
        }
        ArrayList<String> newCompounds = new ArrayList<String>(this.compounds);
        newCompounds.set(i, name);
        return new CompoundName(newCompounds);
    }

    public boolean isCompound() {
        return this.compounds.size() > 1;
    }

    public boolean isEmpty() {
        return this.compounds.isEmpty();
    }

    public boolean hasPrefix(CompoundName prefix) {
        if (prefix.size() > this.size()) {
            return false;
        }
        int prefixLength = prefix.name.length();
        if (prefixLength == 0) {
            return true;
        }
        if (this.name.length() > prefixLength && this.name.charAt(prefixLength) != '.') {
            return false;
        }
        return this.name.startsWith(prefix.name);
    }

    public List<String> asList() {
        return this.compounds;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (!(arg instanceof CompoundName)) return false;
        CompoundName o = (CompoundName)arg;
        if (!this.name.equals(o.name)) return false;
        return true;
    }

    public String toString() {
        return this.name;
    }

    public String getLowerCasedName() {
        return this.lowerCasedName;
    }

    private static String toCompoundString(String[] compounds) {
        int all = compounds.length;
        for (String compound : compounds) {
            all += compound.length();
        }
        StringBuilder b = new StringBuilder(all);
        for (String compound : compounds) {
            b.append(compound).append(".");
        }
        return b.length() == 0 ? "" : b.substring(0, b.length() - 1);
    }

    public static CompoundName from(String name) {
        CompoundName found = cache.get(name);
        if (found != null) {
            return found;
        }
        CompoundName compound = new CompoundName(name);
        if (cache.size() < 10000) {
            cache.put(name, compound);
        }
        return compound;
    }

    private static class ImmutableArrayList
    extends AbstractList<String> {
        private final String[] array;

        ImmutableArrayList(String[] array) {
            this.array = array;
        }

        @Override
        public String get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (String s : this.array) {
                hashCode ^= s.hashCode();
            }
            return hashCode;
        }
    }
}

