/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.utils;

import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.yolean.Exceptions;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.server.MultiPartFormInputStream;

public class MultiPartFormParser {
    private final MultiPartFormInputStream multipart;

    public MultiPartFormParser(InputStream in, String contentType) {
        this.multipart = new MultiPartFormInputStream(in, contentType, null, null);
    }

    public MultiPartFormParser(HttpRequest request) {
        this(request.getData(), request.getHeader("Content-Type"));
    }

    public Map<String, PartItem> readParts() throws MultiPartException {
        try {
            TreeMap<String, PartItem> result = new TreeMap<String, PartItem>();
            for (Part servletPart : this.multipart.getParts()) {
                result.put(servletPart.getName(), new PartItem(servletPart));
            }
            return result;
        }
        catch (Exception e) {
            throw new MultiPartException(e);
        }
    }

    public static class PartItem {
        private final String name;
        private final InputStream data;
        private final String contentType;

        private PartItem(Part servletPart) throws IOException {
            this(servletPart.getName(), servletPart.getInputStream(), servletPart.getContentType());
        }

        public PartItem(String name, InputStream data, String contentType) {
            this.name = name;
            this.data = data;
            this.contentType = contentType;
        }

        public String name() {
            return this.name;
        }

        public InputStream data() {
            return this.data;
        }

        public String contentType() {
            return this.contentType;
        }
    }

    public static class MultiPartException
    extends IOException {
        public MultiPartException(Throwable t) {
            super(Exceptions.toMessageString((Throwable)t), t);
        }
    }
}

