/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.component.annotation.Inject;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.VipStatusConfig;
import com.yahoo.container.handler.ClustersStatus;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.jdisc.Metric;
import com.yahoo.metrics.ContainerMetrics;
import java.util.Map;
import java.util.stream.Collectors;

public class VipStatus {
    private final Metric metric;
    private final ClustersStatus clustersStatus;
    private final StateMonitor healthState;
    private Boolean rotationOverride = null;
    private final boolean initiallyInRotation;
    private boolean currentlyInRotation;
    private final Object mutex = new Object();

    public VipStatus() {
        this(new ClustersStatus());
    }

    public VipStatus(QrSearchersConfig dispatchers) {
        this(dispatchers, new ClustersStatus());
    }

    public VipStatus(ClustersStatus clustersStatus) {
        this(new QrSearchersConfig.Builder().build(), clustersStatus);
    }

    public VipStatus(QrSearchersConfig dispatchers, ClustersStatus clustersStatus) {
        this(dispatchers, new VipStatusConfig.Builder().build(), clustersStatus, StateMonitor.createForTesting(), new NullMetric());
    }

    @Inject
    public VipStatus(QrSearchersConfig dispatchers, VipStatusConfig vipStatusConfig, ClustersStatus clustersStatus, StateMonitor healthState, Metric metric) {
        this.clustersStatus = clustersStatus;
        this.healthState = healthState;
        this.metric = metric;
        this.initiallyInRotation = vipStatusConfig.initiallyInRotation();
        clustersStatus.setClusters(dispatchers.searchcluster().stream().map(c -> c.name()).collect(Collectors.toSet()));
        this.updateCurrentlyInRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInRotation(Boolean inRotation) {
        Object object = this.mutex;
        synchronized (object) {
            this.rotationOverride = inRotation;
            this.updateCurrentlyInRotation();
        }
    }

    public void addToRotation(String clusterIdentifier) {
        this.clustersStatus.setUp(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    public void removeFromRotation(String clusterIdentifier) {
        this.clustersStatus.setDown(clusterIdentifier);
        this.updateCurrentlyInRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentlyInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentlyInRotation = this.rotationOverride != null ? this.rotationOverride : (this.healthState.status() == StateMonitor.Status.up ? this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ONE) : (this.healthState.status() == StateMonitor.Status.initializing ? this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ALL) && this.initiallyInRotation : this.clustersStatus.containerShouldReceiveTraffic(ClustersStatus.Require.ALL)));
            if (this.currentlyInRotation) {
                this.healthState.status(StateMonitor.Status.up);
            } else if (this.healthState.status() == StateMonitor.Status.up) {
                this.healthState.status(StateMonitor.Status.down);
            }
            this.metric.set(ContainerMetrics.IN_SERVICE.baseName(), (Number)(this.currentlyInRotation ? 1 : 0), this.metric.createContext(Map.of()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRotation() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentlyInRotation;
        }
    }

    private static class NullMetric
    implements Metric {
        private NullMetric() {
        }

        public void set(String key, Number val, Metric.Context ctx) {
        }

        public void add(String key, Number val, Metric.Context ctx) {
        }

        public Metric.Context createContext(Map<String, ?> properties) {
            return new NullContext();
        }

        private static class NullContext
        implements Metric.Context {
            private NullContext() {
            }
        }
    }
}

