/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import java.util.concurrent.atomic.AtomicBoolean;

class RequestMetricReporter {
    private final Metric metric;
    private final Metric.Context context;
    private final long requestStartTime;
    private final AtomicBoolean firstSetOfTimeToFirstByte = new AtomicBoolean(true);

    RequestMetricReporter(Metric metric, Metric.Context context, long requestStartTime) {
        this.metric = metric;
        this.context = context;
        this.requestStartTime = requestStartTime;
    }

    void successfulWrite(int numBytes) {
        this.setTimeToFirstByteFirstTime();
        this.metric.add(MetricDefinitions.NUM_SUCCESSFUL_WRITES, (Number)1, this.context);
        this.metric.set(MetricDefinitions.NUM_BYTES_SENT, (Number)numBytes, this.context);
    }

    private void setTimeToFirstByteFirstTime() {
        boolean isFirstWrite = this.firstSetOfTimeToFirstByte.getAndSet(false);
        if (isFirstWrite) {
            long timeToFirstByte = this.getRequestLatency();
            this.metric.set(MetricDefinitions.TIME_TO_FIRST_BYTE, (Number)timeToFirstByte, this.context);
        }
    }

    void failedWrite() {
        this.metric.add(MetricDefinitions.NUM_FAILED_WRITES, (Number)1, this.context);
    }

    void successfulResponse() {
        this.setTimeToFirstByteFirstTime();
        long requestLatency = this.getRequestLatency();
        this.metric.set(MetricDefinitions.TOTAL_SUCCESSFUL_LATENCY, (Number)requestLatency, this.context);
        this.metric.add(MetricDefinitions.NUM_SUCCESSFUL_RESPONSES, (Number)1, this.context);
    }

    void failedResponse() {
        this.setTimeToFirstByteFirstTime();
        this.metric.set(MetricDefinitions.TOTAL_FAILED_LATENCY, (Number)this.getRequestLatency(), this.context);
        this.metric.add(MetricDefinitions.NUM_FAILED_RESPONSES, (Number)1, this.context);
    }

    void prematurelyClosed() {
        this.metric.add(MetricDefinitions.NUM_PREMATURELY_CLOSED_CONNECTIONS, (Number)1, this.context);
    }

    void successfulRead(int bytes_received) {
        this.metric.set(MetricDefinitions.NUM_BYTES_RECEIVED, (Number)bytes_received, this.context);
    }

    private long getRequestLatency() {
        return System.currentTimeMillis() - this.requestStartTime;
    }

    void uriLength(int length) {
        this.metric.set(MetricDefinitions.URI_LENGTH, (Number)length, this.context);
    }

    void contentSize(int size) {
        this.metric.set(MetricDefinitions.CONTENT_SIZE, (Number)size, this.context);
    }
}

