/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.FileReference;
import com.yahoo.container.Container;
import com.yahoo.container.core.config.ApplicationBundleLoader;
import com.yahoo.container.core.config.FileAcquirerBundleInstaller;
import com.yahoo.container.core.config.PlatformBundleLoader;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.Container;
import com.yahoo.container.di.Osgi;
import com.yahoo.container.di.componentgraph.core.ComponentGraph;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.jdisc.application.BsnVersion;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.osgi.OsgiImpl;
import com.yahoo.osgi.OsgiWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class HandlersConfigurerDi {
    private static final Logger log = Logger.getLogger(HandlersConfigurerDi.class.getName());
    private static final Executor fallbackExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getThreadFactory((String)"HandlersConfigurerDI"));
    private final Container vespaContainer;
    private final com.yahoo.container.di.Container container;
    private volatile ComponentGraph currentGraph = new ComponentGraph(0L);

    public HandlersConfigurerDi(SubscriberFactory subscriberFactory, Container vespaContainer, String configId, ComponentDeconstructor deconstructor, Injector discInjector, OsgiFramework osgiFramework) {
        this(subscriberFactory, vespaContainer, configId, deconstructor, discInjector, new ContainerAndDiOsgi(osgiFramework, vespaContainer.getFileAcquirer()));
    }

    public HandlersConfigurerDi(SubscriberFactory subscriberFactory, Container vespaContainer, String configId, ComponentDeconstructor deconstructor, Injector discInjector, OsgiWrapper osgiWrapper) {
        this.vespaContainer = vespaContainer;
        this.container = new com.yahoo.container.di.Container(subscriberFactory, configId, deconstructor, osgiWrapper);
        Runnable cleanupTask = this.waitForNextGraphGeneration(discInjector, true);
        cleanupTask.run();
    }

    public Runnable waitForNextGraphGeneration(Injector discInjector, boolean isInitializing) {
        Container.ComponentGraphResult result = this.container.waitForNextGraphGeneration(this.currentGraph, this.createFallbackInjector(this.vespaContainer, discInjector), isInitializing);
        this.currentGraph = result.newGraph();
        return result.oldComponentsCleanupTask();
    }

    private Injector createFallbackInjector(final Container vespaContainer, Injector discInjector) {
        return discInjector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Container.class).toInstance((Object)vespaContainer);
                this.bind(AccessLog.class).toInstance((Object)AccessLog.NONE_INSTANCE);
                this.bind(Executor.class).toInstance((Object)fallbackExecutor);
                if (vespaContainer.getFileAcquirer() != null) {
                    this.bind(FileAcquirer.class).toInstance((Object)vespaContainer.getFileAcquirer());
                }
            }
        }});
    }

    public void reloadConfig(long generation) {
        this.container.reloadConfig(generation);
    }

    public <T> T getComponent(Class<T> componentClass) {
        return this.currentGraph.getInstance(componentClass);
    }

    public void shutdown() {
        this.container.shutdown(this.currentGraph);
    }

    public void shutdownConfigRetriever() {
        this.container.shutdownConfigRetriever();
    }

    public long generation() {
        return this.currentGraph.generation();
    }

    private static class ContainerAndDiOsgi
    extends OsgiImpl
    implements OsgiWrapper {
        private final OsgiFramework osgiFramework;
        private final ApplicationBundleLoader applicationBundleLoader;
        private final PlatformBundleLoader platformBundleLoader;

        public ContainerAndDiOsgi(OsgiFramework osgiFramework, FileAcquirer fileAcquirer) {
            super(osgiFramework);
            this.osgiFramework = osgiFramework;
            this.applicationBundleLoader = new ApplicationBundleLoader(this, new FileAcquirerBundleInstaller(fileAcquirer));
            this.platformBundleLoader = new PlatformBundleLoader(this);
        }

        @Override
        public void installPlatformBundles(Collection<String> bundlePaths) {
            if (this.osgiFramework.isFelixFramework()) {
                log.fine("Installing platform bundles.");
                this.platformBundleLoader.useBundles(new ArrayList<String>(bundlePaths));
            }
        }

        @Override
        public void useApplicationBundles(Collection<FileReference> bundles, long generation) {
            if (!bundles.isEmpty()) {
                log.info("Installing bundles for application generation " + generation);
            }
            this.applicationBundleLoader.useBundles(new ArrayList<FileReference>(bundles));
        }

        @Override
        public Set<Bundle> completeBundleGeneration(Osgi.GenerationStatus status) {
            return this.applicationBundleLoader.completeGeneration(status);
        }

        @Override
        protected String bundleResolutionErrorMessage(ComponentSpecification bundleSpec) {
            List<BsnVersion> activeBundles = this.applicationBundleLoader.activeBundlesBsnVersion();
            List<Version> activeVersions = ContainerAndDiOsgi.activeVersionsOfBundle(bundleSpec, activeBundles);
            Object versionsMessage = "";
            if (activeVersions.size() == 1) {
                versionsMessage = "There is an installed bundle with the same name with version: " + activeVersions.get(0) + " ";
            } else if (activeVersions.size() > 1) {
                versionsMessage = "There are installed bundles with the same name with versions: " + activeVersions + " ";
            }
            if (ContainerAndDiOsgi.qualifierIsUsed(bundleSpec, activeVersions)) {
                versionsMessage = (String)versionsMessage + " Note that qualifier strings must be matched exactly. ";
            }
            return String.format("%sInstalled application bundles: [%s]", versionsMessage, activeBundles.stream().map(BsnVersion::toReadableString).collect(Collectors.joining(", ")));
        }

        private static boolean qualifierIsUsed(ComponentSpecification bundleSpec, List<Version> activeVersions) {
            return !bundleSpec.getVersionSpecification().getQualifier().isEmpty() || activeVersions.stream().anyMatch(version -> !version.getQualifier().isEmpty());
        }

        private static List<Version> activeVersionsOfBundle(ComponentSpecification bundleSpec, List<BsnVersion> activeBundles) {
            return activeBundles.stream().filter(bundle -> bundle.symbolicName().equals(bundleSpec.getName())).map(BsnVersion::version).toList();
        }
    }

    public static class RegistriesHack {
        @Inject
        public RegistriesHack(Container vespaContainer, ComponentRegistry<AbstractComponent> allComponents, ComponentRegistry<RequestHandler> requestHandlerRegistry, ComponentRegistry<ClientProvider> clientProviderRegistry, ComponentRegistry<ServerProvider> serverProviderRegistry) {
            log.log(Level.FINE, () -> "RegistriesHack.init " + System.identityHashCode(this));
            vespaContainer.setComponentRegistry(allComponents);
            vespaContainer.setRequestHandlerRegistry(requestHandlerRegistry);
            vespaContainer.setClientProviderRegistry(clientProviderRegistry);
            vespaContainer.setServerProviderRegistry(serverProviderRegistry);
        }
    }
}

